% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showSymbolicQsprayOption<-}
\alias{showSymbolicQsprayOption<-}
\title{Set a show option to a 'symbolicQspray' object}
\usage{
showSymbolicQsprayOption(x, which) <- value
}
\arguments{
\item{x}{a \code{symbolicQspray} object}

\item{which}{which option to set; this can be \code{"a"}, \code{"X"},
\code{"quotientBar"}, \code{"showMonomial"}, \code{"showRatioOfQsprays"} or
\code{"showSymbolicQspray"}}

\item{value}{the value for the option}
}
\value{
This returns the updated \code{symbolicQspray}.
}
\description{
Set show option to a \code{symbolicQspray} object
}
\examples{
set.seed(421)
Qspray <- rSymbolicQspray()
showSymbolicQsprayOption(Qspray, "a") <- "x"
showSymbolicQsprayOption(Qspray, "X") <- "A"
showSymbolicQsprayOption(Qspray, "quotientBar") <- " / "
Qspray
showSymbolicQsprayOption(Qspray, "showRatioOfQsprays") <-
  showRatioOfQspraysXYZ()
Qspray
}
