% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{boot_mapping}
\alias{boot_mapping}
\title{Boot mapping}
\format{
This data frame contains the following columns:
\describe{
\item{\code{version}}{Country code for the version of the show}
\item{\code{version_season}}{Version season key}
\item{\code{season_name}}{The season name}
\item{\code{season}}{The season number}
\item{\code{episode}}{Episode number}
\item{\code{order}}{The number of boots that there have been in the game e.g. if \code{order == 2} there have been 2
boots in the game so far and there are N-2 castaways left in the game}
\item{\code{final_n}}{The final number of castaways e.g. you can filter to the final 4 by \code{filter(boot_mapping, final_n == 4)}. There
are missing values where players have returned to the game. This means there are multiple stages of the game where there is a different
make up of the final 8, for example. This field just takes the last set so that you can filter for \code{final_n} and it will return a
single set of castaways.}
\item{\code{n_boots}}{Similar to \code{final_n} but the number of boots in the game. This is different to \code{order} where order counts if
someone has been booted twice. \code{n_boots} is simply the number of people in the season minus the \code{final_n}.}
\item{\code{sog_id}}{Stage of game ID for joining to \code{vote_history} and \code{challenge_results}}
\item{\code{castaway_id}}{ID of the castaway (primary key). Consistent across seasons and name changes e.g. Amber Brkich / Amber Mariano. The first two letters reference the country of the version played e.g. US, AU.}
\item{\code{castaway}}{Name of the castaway}
\item{\code{tribe}}{Name of the tribe the castaway was on}
\item{\code{tribe_status}}{The status of the tribe e.g. original, swapped, merged, etc. See details for more}
\item{\code{game_status}}{Logical flag to identify if the castaway is currently in the game. If \code{FALSE} the castaway
is on Redemption Island or Edge of Extinction.}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}  \url{https://survivor.fandom.com/wiki/Main_Page}
}
\usage{
boot_mapping
}
\description{
A mapping table for easily filtering to the set of castaways that are still in the game
after a specified number of boots.
}
\keyword{datasets}
