% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_survdnn.R
\name{tune_survdnn}
\alias{tune_survdnn}
\title{Tune Hyperparameters for a survdnn Model via Cross-Validation}
\usage{
tune_survdnn(
  formula,
  data,
  times,
  metrics = "cindex",
  param_grid,
  folds = 3,
  .seed = 42,
  refit = FALSE,
  return = c("all", "summary", "best_model")
)
}
\arguments{
\item{formula}{A survival formula, e.g., `Surv(time, status) ~ x1 + x2`.}

\item{data}{A data frame.}

\item{times}{A numeric vector of evaluation time points.}

\item{metrics}{A character vector of evaluation metrics: "cindex", "brier", or "ibs".
Only the first metric is used for model selection.}

\item{param_grid}{A named list defining hyperparameter combinations to evaluate.
Required names: `hidden`, `lr`, `activation`, `epochs`, `loss`.}

\item{folds}{Number of cross-validation folds (default: 3).}

\item{.seed}{Optional seed for reproducibility (default: 42).}

\item{refit}{Logical. If TRUE, refits the best model on the full dataset.}

\item{return}{One of "all", "summary", or "best_model":
\describe{
  \item{"all"}{Returns the full cross-validation result across all combinations.}
  \item{"summary"}{Returns averaged results per configuration.}
  \item{"best_model"}{Returns the refitted model or best hyperparameters.}
}}
}
\value{
A tibble or model object depending on the `return` value.
}
\description{
Performs k-fold cross-validation over a user-defined hyperparameter grid
and selects the best configuration according to the specified evaluation metric.
}
