% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_scale.R
\name{ppi_scale}
\alias{ppi_scale}
\title{Simulate and Compare Index Scale on Structured vs Noisy Data}
\usage{
ppi_scale(data, index_fun, n_sim = 100, n_obs = 500, seed = NULL)
}
\arguments{
\item{data}{A data frame or tibble with at least two numeric columns.}

\item{index_fun}{A function that takes two numeric vectors (\code{x}, \code{y}) and returns a numeric scalar index.}

\item{n_sim}{Integer. Number of simulations. Default is 100.}

\item{n_obs}{Integer. Number of observations per simulation. Default is 500.}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
A tibble with columns:
\itemize{
\item \code{simulation}: simulation number
\item \code{var_i}, \code{var_j}: variable names
\item \code{var_pair}: pair name as a string
\item \code{sigma}: 0 for structured data, 1 for noisy data
\item \code{index}: index value returned by \code{index_fun}
}
}
\description{
Performs simulations to compute a projection pursuit index on structured
(sampled) data and on random noise, allowing a comparison of index scale across contexts.
}
\examples{
ppi_scale(data_gen("polynomial", degree = 3), scag_index("stringy"), n_sim = 2)

}
