% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scpcm.R
\name{scpcm}
\alias{scpcm}
\alias{scpcm,sf-method}
\alias{scpcm,SpatRaster-method}
\title{spatially convergent partial cross mapping}
\usage{
\S4method{scpcm}{sf}(
  data,
  cause,
  effect,
  conds,
  libsizes = NULL,
  E = 3,
  k = E + 2,
  tau = 1,
  style = 1,
  stack = FALSE,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  dist.average = TRUE,
  theta = 1,
  algorithm = "simplex",
  threads = detectThreads(),
  detrend = TRUE,
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE,
  cumulate = FALSE,
  nb = NULL
)

\S4method{scpcm}{SpatRaster}(
  data,
  cause,
  effect,
  conds,
  libsizes = NULL,
  E = 3,
  k = E + 2,
  tau = 1,
  style = 1,
  stack = FALSE,
  lib = NULL,
  pred = NULL,
  dist.metric = "L2",
  dist.average = TRUE,
  theta = 1,
  algorithm = "simplex",
  threads = detectThreads(),
  detrend = TRUE,
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE,
  cumulate = FALSE,
  grid.coord = TRUE,
  embed.direction = 0,
  win.ratio = 0
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{conds}{name of conditioning variables.}

\item{libsizes}{(optional) number of spatial units used (input needed: \code{vector} - spatial vector, \code{matrix} - spatial raster).}

\item{E}{(optional) embedding dimensions.}

\item{k}{(optional) number of nearest neighbors.}

\item{tau}{(optional) step of spatial lags.}

\item{style}{(optional) embedding style (\code{0} includes current state, \code{1} excludes it).}

\item{stack}{(optional) whether to stack embeddings.}

\item{lib}{(optional) libraries indices (input requirement same as \code{libsizes}).}

\item{pred}{(optional) predictions indices (input requirement same as \code{libsizes}).}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{dist.average}{(optional) whether to average distance.}

\item{theta}{(optional) weighting parameter for distances, useful when \code{algorithm} is \code{smap}.}

\item{algorithm}{(optional) prediction algorithm.}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{progressbar}{(optional) whether to show the progress bar.}

\item{cumulate}{(optional) serial or cumulative computation of partial cross mapping.}

\item{nb}{(optional) neighbours list.}

\item{grid.coord}{(optional) whether to detrend using cell center coordinates (\code{TRUE}) or row/column numbers (\code{FALSE}).}

\item{embed.direction}{(optional) direction selector for embeddings (\code{0} returns all directions, \code{1-8} correspond to NW, N, NE, W, E, SW, S, SE).}

\item{win.ratio}{(optional) ratio of sliding window scale to speed up state-space predictions.}
}
\value{
A list
\describe{
\item{\code{pxmap}}{partial cross mapping results}
\item{\code{xmap}}{cross mapping results}
\item{\code{varname}}{names of causal, effect and conditioning variables}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
spatially convergent partial cross mapping
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg",package="spEDM"))
\donttest{
g = scpcm(columbus,"hoval","crime","inc",libsizes = seq(5,45,5),E = 6)
g
plot(g,ylimits = c(-0.1,0.4),ybreaks = seq(-0.1,0.4,0.1))
}
}
