% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_utilities.R
\name{findBursts}
\alias{findBursts}
\title{Find bursts}
\usage{
findBursts(
  ampl,
  step,
  windowLength,
  interburst,
  burstThres,
  peakToTrough,
  troughLocation = "either",
  scale = c("dB", "linear")[2]
)
}
\arguments{
\item{ampl}{downsampled amplitude envelope}

\item{step}{time difference between two points in the envelope (ms)}

\item{windowLength}{length of FFT window, ms (multiple values in a vector
produce a multi-resolution spectrogram)}

\item{interburst}{minimum time between two consecutive bursts (ms). Defaults
to the average detected \code{(syllable + pause) / 2}}

\item{peakToTrough}{to qualify as a burst, a local maximum has to be at least
\code{peakToTrough} dB above the left and/or right local trough(s)
(controlled by \code{troughLocation}) over the analysis window (controlled
by \code{interburst}). Defaults to SNR + 3 dB}

\item{troughLocation}{should local maxima be compared to the trough on the
left and/or right of it? Values: 'left', 'right', 'both', 'either'}

\item{scale}{maximum possible amplitude of input used for normalization of
input vector (only needed if \code{x} is a numeric vector)}
}
\value{
Returns a dataframe with timing of bursts
}
\description{
Internal soundgen function.
}
\details{
Called by \code{\link{segment}}.
}
\keyword{internal}
