% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning_data.R
\name{limpiar_edad_event}
\alias{limpiar_edad_event}
\title{Limpiar las edades de los datos de una enfermedad o evento}
\usage{
limpiar_edad_event(data_event, col_edad = "edad")
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de una
enfermedad o evento.}

\item{col_edad}{Un `character` (cadena de caracteres) con
el nombre de la columna que contiene las edades en los datos de
la enfermedad o evento; su valor por defecto es `"edad"`.}
}
\value{
Un `data.frame` con los datos de una enfermedad o evento
con las edades limpias.
}
\description{
Función que limpia y estandariza las edades de los datos
de una enfermedad o evento, convirtiéndolas en años, según la
clasificación del Instituto Nacional de Salud:
\itemize{
  \item No aplica = 0
  \item Años = 1
  \item Meses = 2
  \item Días = 3
  \item Horas = 4
  \item Minutos = 5
}
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
limpiar_edad_event(data_event = data_limpia, col_edad = "edad")
}
