% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cluster_analysis.R
\name{plot.see_cluster_analysis}
\alias{plot.see_cluster_analysis}
\title{Plot method for computing cluster analysis}
\usage{
\method{plot}{see_cluster_analysis}(x, data = NULL, n_columns = NULL, size_bar = 0.6, ...)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model.}

\item{n_columns}{For models with multiple components (like fixed and random,
count and zero-inflated), defines the number of columns for the
panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{size_bar}{Size of bar geoms.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::cluster_analysis()}
function.
}
\examples{
library(parameters)
groups <- cluster_analysis(iris[, 1:4], 3)
plot(groups)
}
