% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.easycorrelation.R
\name{plot.see_easycorrelation}
\alias{plot.see_easycorrelation}
\title{Plot method for Gaussian Graphical Models}
\usage{
\method{plot}{see_easycorrelation}(x, size = 22, text_color = "white", node_color = "#647687", ...)
}
\arguments{
\item{x}{An object.}

\item{size}{Size of geoms. Depends on the context of the \code{plot()} function,
so this argument may change size of points, lines or bars.}

\item{text_color}{Color of text labels.}

\item{node_color}{Color of node- or circle-geoms.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{correlation::correlation()} function.
}
\examples{
\dontrun{
library(correlation)
library(ggraph)
result <- correlation(mtcars, partial = TRUE)
plot(result)
}
}
