% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studio.R
\name{launch}
\alias{launch}
\title{Launch surveydown Studio}
\usage{
launch(gssencmode = "auto")
}
\arguments{
\item{gssencmode}{Character string. The GSS encryption mode for the database
connection. Defaults to \code{"auto"}. Options include:
\itemize{
\item \code{"auto"}: Tries \code{"prefer"} first, then falls back to \code{"disable"} if GSSAPI fails (recommended)
\item \code{"prefer"}: Uses GSSAPI encryption if available, plain connection if not
\item \code{"disable"}: Forces plain connection without GSSAPI encryption
}}
}
\value{
No return value, called for its side effects of launching a Shiny app.
}
\description{
This function launches a Shiny app with 3 tabs: Build, Preview, and Responses.
The Build tab includes a template selection interface for creating new surveys.
}
\examples{
if (interactive()) {
  # Launch studio (uses "auto" mode by default)
  launch()

  # Launch studio with disabled GSS encryption (for VPN connections)
  launch(gssencmode = "disable")

  # Launch studio with prefer mode (no fallback)
  launch(gssencmode = "prefer")
}
}
