% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/history.R
\name{history}
\alias{history}
\title{Hourly weather data for specified date.}
\usage{
history(location, date = "20150101", use_metric = FALSE,
  key = get_api_key(), raw = FALSE, message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{date}{Date as YYYYMMDD format}

\item{use_metric}{Metric or imperial units}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df with date, temperature, dew point,
        humidity, wind speed, gust and direction,
        visibility, pressure, wind chill, heat index,
        precipitation, condition, fog, rain, snow,
        hail, thunder, tornado
}
\description{
Hourly weather data for specified date.
}
\examples{
\dontrun{
history(set_location(territory = "Hawaii", city = "Honolulu"), "20130101")
history(set_location(airport_code = "SEA"), "20130101")
history(set_location(zip_code = "90210"), "20130131")
history(set_location(territory = "IR", city = "Tehran"), "20140131")
}
}
