% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mean_run}
\alias{mean_run}
\title{Running mean}
\usage{
mean_run(
  x,
  k = integer(0),
  lag = integer(1),
  idx = integer(0),
  at = integer(0),
  na_rm = TRUE,
  na_pad = FALSE
)
}
\arguments{
\item{x}{\code{numeric} vector which running function is calculated on}

\item{k}{(\verb{integer`` vector or single value)\\cr Denoting size of the running window. If }k\verb{is a single value then window size is constant for all elements, otherwise if}length(k) == length(x)`
different window size for each element.}

\item{lag}{(\code{integer} vector or single value)\cr
Denoting window lag. If \code{lag} is a single value then window lag is constant
for all elements, otherwise if \code{length(lag) == length(x)} different window
size for each element. Negative value shifts window forward.}

\item{idx}{(\code{integer}, \code{Date}, \code{POSIXt})\cr
Optional integer vector containing sorted (ascending) index of observation.
By default \code{idx} is index incremented by one. User can provide index with
varying increment and with duplicated values. If specified then \code{k} and \code{lag}
are depending on \code{idx}. Length of \code{idx} have to be equal of length \code{x}.}

\item{at}{(\code{integer}, \code{Date}, \code{POSIXt}, \code{character} vector)\cr
Vector of any size and any value defining output data points. Values of the
vector defines the indexes which data is computed at.}

\item{na_rm}{\code{logical} single value (default \code{na_rm = TRUE}) -
if \code{TRUE} sum is calculating excluding \code{NA}.}

\item{na_pad}{(\code{logical} single value)\cr
Whether incomplete window should return \code{NA} (if \code{na_pad = TRUE})
Incomplete window is when some parts of the window are out of range.}
}
\value{
mean (\code{numeric}) vector of length equals length of \code{x}.
}
\description{
Running mean in specified window of numeric vector.
}
\examples{
set.seed(11)
x1 <- rnorm(15)
x2 <- sample(c(rep(NA, 5), rnorm(15)), 15, replace = TRUE)
k <- sample(1:15, 15, replace = TRUE)
mean_run(x1)
mean_run(x2, na_rm = TRUE)
mean_run(x2, na_rm = FALSE)
mean_run(x2, na_rm = TRUE, k = 4)
}
