% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-cv.R
\name{fitted.cv_poisson_rt}
\alias{fitted.cv_poisson_rt}
\title{Fitted cv_poisson_rt}
\usage{
\method{fitted}{cv_poisson_rt}(object, which_lambda = c("lambda.min", "lambda.1se"), ...)
}
\arguments{
\item{object}{result of cross validation of type \code{cv_poisson_rt}}

\item{which_lambda}{select which Rt's to output. If not provided, all Rt's
are returned. If provided a list of lambda,the corresponding Rt estimation
will be returned.

If provided a string, it must be either one of \code{lambda.min} or \code{lambda.1se}.
\itemize{
\item If provided \code{lambda.min}, return Rt which is generated from
the lambda that minimizes the cross validation score.
\item If provided \code{lambda.1se}, return Rt which is generated from the lambda
whose corresponding cross validation score is 1 standard error away of the
minimal cross validation score.
}}

\item{...}{not used.}
}
\value{
Rt's estimated from provided lambda
}
\description{
Fitted cv_poisson_rt
}
\examples{
y <- c(1, rpois(100, dnorm(1:100, 50, 15) * 500 + 1))
cv <- cv_estimate_rt(y, korder = 3, nfold = 3, nsol = 30)
f <- fitted(cv)
f <- fitted(cv, which_lambda = cv$lambda[1])
f <- fitted(cv, which_lambda = "lambda.1se")
f <- fitted(cv, which_lambda = NULL)
}
