% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_model_api.R
\name{validate_modality}
\alias{validate_modality}
\title{Validate Query Modality}
\usage{
validate_modality(query)
}
\arguments{
\item{query}{A list containing the query data.}
}
\value{
Invisibly returns TRUE if validation passes.
Throws an error If the modality key is missing or if the selected modality is not allowed.
}
\description{
Validates that the modality specified in the query is allowed for the v2.0 model.
This function checks that the `modality` value is one of the supported modalities.
}
\examples{
# Create a valid query
query <- get_valid_query()
validate_modality(query) # Passes validation

# Example with invalid modality
\dontrun{
invalid_query <- get_valid_query()
invalid_query$modality <- "unsupported_modality"
validate_modality(invalid_query) # Throws error for invalid modality
}
}
