% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{applications}
\alias{applications}
\title{List Deployed Applications}
\usage{
applications(account = NULL, server = NULL)
}
\arguments{
\item{account, server}{Uniquely identify a remote server with either your
user \code{account}, the \code{server} name, or both. If neither are supplied, and
there are multiple options, you'll be prompted to pick one.

Use \code{\link[=accounts]{accounts()}} to see the full list of available options.}
}
\value{
Returns a data frame with the following columns:
\tabular{ll}{
\code{id}         \tab Application unique id \cr
\code{name}       \tab Name of application \cr
\code{title}       \tab Application title \cr
\code{url}        \tab URL where application can be accessed \cr

\code{status}     \tab Current status of application. Valid values are \code{pending},
\code{deploying}, \code{running}, \code{terminating}, and \code{terminated} \cr
\code{size}       \tab Instance size (small, medium, large, etc.) (on
ShinyApps.io) \cr
\code{instances}  \tab Number of instances (on ShinyApps.io) \cr
\code{config_url} \tab URL where application can be configured \cr
}
}
\description{
List all applications currently deployed for a given account.

Supported servers: All servers
}
\note{
To register an account you call the \code{\link[=setAccountInfo]{setAccountInfo()}} function.
}
\examples{
\dontrun{

# list all applications for the default account
applications()

# list all applications for a specific account
applications("myaccount")

# view the list of applications in the data viewer
View(applications())
}
}
\seealso{
\code{\link[=deployApp]{deployApp()}}, \code{\link[=terminateApp]{terminateApp()}}

Other Deployment functions: 
\code{\link{deployAPI}()},
\code{\link{deployApp}()},
\code{\link{deployDoc}()},
\code{\link{deploySite}()},
\code{\link{deployTFModel}()}
}
\concept{Deployment functions}
