% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_classes.R
\name{create_triple_omic}
\alias{create_triple_omic}
\title{Create Triple Omic}
\usage{
create_triple_omic(
  measurement_df,
  feature_df = NULL,
  sample_df = NULL,
  feature_pk,
  sample_pk,
  omic_type_tag = "general"
)
}
\arguments{
\item{measurement_df}{A data.frame (or tibble) of measurements - one row
for each combination of feature and sample}

\item{feature_df}{A data.frame (or tibble) of features - one row per feature}

\item{sample_df}{A data.frame (or tibble) of samples - one row per sample}

\item{feature_pk}{A unique identifier for features}

\item{sample_pk}{A unique identifier for samples}

\item{omic_type_tag}{an optional subtype of omic data: metabolomics,
lipidomics, proteomics, genomics, general}
}
\value{
An S3 \code{triple_omic}/\code{tomic} object built on a \code{list}:
 \describe{
   \item{features}{A tibble of feature meta-data (one row per feature)}
   \item{samples}{A tibble of sample meta-data (one row per sample)}
   \item{measurements}{A tibble with one row per measurement
     (i.e., features x samples)}
   \item{design}{A list which organized the dataset's meta-data:
     \describe{
       \item{feature_pk}{variable specifying a unique feature}
       \item{sample_pk}{variable specifying a unique sample}
       \item{features}{tibble of feature attributes}
       \item{samples}{tibble of sample attributes}
       \item{measurements}{tibble of measurement attributes}
     }
   }
 }
}
\description{
A triple omics class contains three data.frames, one for features, one for
  samples, and one for abundances. This is a good format when there is a
  large amount of meta data associated with features or samples.
}
\details{
for now primary keys are unique (rather than allowing for a
  multi-index)
}
\examples{

library(dplyr)

measurement_df <- tidyr::expand_grid(
  feature_id = 1:10,
  sample_id = LETTERS[1:5]
) \%>\%
  dplyr::mutate(value = rnorm(n()))

feature_df <- tibble(
  feature_id = 1:10,
  feature_group = rep(c("a", "b"), each = 5)
)
sample_df <- tibble(
  sample_id = LETTERS[1:5],
  sample_group = c("a", "a", "b", "b", "b")
)

triple_omic <- create_triple_omic(
  measurement_df, feature_df, sample_df,
  "feature_id", "sample_id"
)
}
