% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.R
\name{patterns}
\alias{patterns}
\alias{apply_pattern}
\alias{apply_fundamental_pattern}
\alias{apply_direct_pattern}
\alias{apply_sequential_pattern}
\alias{apply_parallel_pattern}
\alias{apply_rolling_interaction_pattern}
\title{Apply patterns to formulas}
\usage{
apply_pattern(x, pattern)

apply_fundamental_pattern(x)

apply_direct_pattern(x)

apply_sequential_pattern(x)

apply_parallel_pattern(x)

apply_rolling_interaction_pattern(x)
}
\arguments{
\item{x}{A \code{tm} object}

\item{pattern}{A character string that specifies the pattern to use}
}
\value{
Returns a \code{tbl_df} object that has special column names and rows.
Each row is essentially a precursor to a new formula.

These columns and rows must be present to be used with the \code{fmls()}
function, and generally are the expected result of the specified pattern.
They will undergo further internal modification prior to being turned into
a \code{fmls} object, but this is an developer consideration. If developing a
pattern, please use this guide to ensure that the output is compatible with
the \code{fmls()} function.
\itemize{
\item outcome: a single term that is the expected outcome variable
\item exposure: a single term that is the expected exposure variable, which may not be present in every row
\item covariate_*: the covariates expand based on the number that are present (e.g. "covariate_1", "covariate_2", etc)
}
}
\description{
The family of \verb{apply_*_pattern()} functions that are used to expand \code{fmls}
by specified patterns. These functions are not intended to be used directly
but as internal functions. They have been exposed to allow for potential
user-defined use cases.
}
\details{
Currently supported patterns are: fundamental, direct, sequential, parallel.
}
