% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{natural_breaks}
\alias{natural_breaks}
\title{Natural Breaks (Jenks)}
\usage{
natural_breaks(k, df)
}
\arguments{
\item{k}{A numeric value indicates how many breaks}

\item{df}{A data frame with selected variable. E.g. guerry["Crm_prs"]}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Natural Breaks group data whose boundaries are set where there
are relatively big differences.
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
natural_breaks(k=5, guerry['Crm_prs'])
}
