% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{schc}
\alias{schc}
\title{Spatially Constrained Hierarchical Clucstering (SCHC)}
\usage{
schc(
  k,
  w,
  df,
  method = "average",
  bound_variable = data.frame(),
  min_bound = 0,
  scale_method = "standardize",
  distance_method = "euclidean"
)
}
\arguments{
\item{k}{The number of clusters}

\item{w}{An instance of Weight class}

\item{df}{A data frame with selected variables only. E.g. guerry[c("Crm_prs", "Crm_prp", "Litercy")]}

\item{method}{{"single", "complete", "average","ward"}}

\item{bound_variable}{(optional) A data frame with selected bound variabl}

\item{min_bound}{(optional) A minimum bound value that applies to all clusters}

\item{scale_method}{One of the scaling methods {'raw', 'standardize', 'demean', 'mad', 'range_standardize', 'range_adjust'} to apply on input data. Default is 'standardize' (Z-score normalization).}

\item{distance_method}{(optional) The distance method used to compute the distance betwen observation i and j. Defaults to "euclidean". Options are "euclidean" and "manhattan"}
}
\value{
A names list with names "Clusters", "Total sum of squares", "Within-cluster sum of squares", "Total within-cluster sum of squares", and "The ratio of between to total sum of squares".
}
\description{
Spatially constrained hierarchical clustering is a special form of constrained clustering, where the constraint is based on contiguity (common borders).
The method builds up the clusters using agglomerative hierarchical clustering methods:
single linkage, complete linkage, average linkage and Ward's method (a special form of centroid linkage).
Meanwhile, it also maintains the spatial contiguity when merging two clusters.
}
\examples{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
data <- guerry[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
guerry_clusters <- schc(4, queen_w, data, "complete")
guerry_clusters
}
