% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{schc}
\alias{schc}
\title{Spatially Constrained Hierarchical Clucstering (SCHC)}
\usage{
schc(
  k,
  w,
  data,
  method = "average",
  bound_vals = vector("numeric"),
  min_bound = 0,
  distance_method = "euclidean"
)
}
\arguments{
\item{k}{The number of clusters}

\item{w}{An instance of Weight class}

\item{data}{A list of numeric vectors of selected variable}

\item{method}{{"single", "complete", "average","ward"}}

\item{bound_vals}{(optional) A numeric vector of selected bounding variable}

\item{min_bound}{(optional) A minimum value that the sum value of bounding variable int each cluster should be greater than}

\item{distance_method}{(optional) The distance method used to compute the distance betwen observation i and j. Defaults to "euclidean". Options are "euclidean" and "manhattan"}
}
\value{
A list of numeric vectors represents a group of clusters
}
\description{
Spatially constrained hierarchical clustering is a special form of constrained clustering, where the constraint is based on contiguity (common borders).
The method builds up the clusters using agglomerative hierarchical clustering methods:
single linkage, complete linkage, average linkage and Ward's method (a special form of centroid linkage).
Meanwhile, it also maintains the spatial contiguity when merging two clusters.
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
queen_w <- queen_weights(guerry)
guerry_df <- as.data.frame(guerry) # use as data.frame
data <- guerry_df[c('Crm_prs','Crm_prp','Litercy','Donatns','Infants','Suicids')]
guerry_clusters <- schc(4, queen_w, data, "complete")
guerry_clusters
}
