% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_unregistered_curves.R
\name{simulate_unregistered_curves}
\alias{simulate_unregistered_curves}
\title{Simulate unregistered curves}
\usage{
simulate_unregistered_curves(
  I = 50,
  D = 100,
  lambda = 15,
  seed = 1988,
  period = 2 * pi,
  spline_based = FALSE,
  phase_variation = TRUE
)
}
\arguments{
\item{I}{Number of subjects. Defaults is 50.}

\item{D}{Number of grid points per subject. Default is 100.}

\item{lambda}{Standard deviation for subject-specific amplitudes.}

\item{seed}{Seed for reproducibility. Default is 1988.}

\item{period}{Controls the period of the mean curve}

\item{spline_based}{If FALSE curve is constructed using sine and cosine functions,
if TRUE, curve is constructed using B-spline basis.}

\item{phase_variation}{If TRUE, creates phase variation 
(registered curves are observed on uneven grid). If FALSE, no phase variation.}
}
\value{
A simulated dataframe with variables id, value, index, latent_mean, and t. Index is the domain
on which curves are unregistered and t is the domain on which curves are registered.
}
\description{
This function simulates unregistered curves, providing the time values for both 
the unregistered curves (t_star) and the registered curves (t). Curves all have one peak, the location
of which is shifted on the unregistered domain, meant to mimic accelerometer data.
}
\author{
Julia Wrobel \email{jw3134@cumc.columbia.edu},
Jeff Goldsmith \email{ajg2202@cumc.columbia.edu}
}
