% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata.R
\name{get_osm_railways}
\alias{get_osm_railways}
\title{Get OpenStreetMap railways}
\usage{
get_osm_railways(
  aoi,
  crs = NULL,
  railway_values = "rail",
  force_download = FALSE
)
}
\arguments{
\item{aoi}{Area of interest as sf object or bbox}

\item{crs}{Coordinate reference system as EPSG code}

\item{railway_values}{A character or character vector with the railway values
to retrieve.}

\item{force_download}{Download data even if cached data is available}
}
\value{
An sf object with the railways
}
\description{
Get OpenStreetMap railways
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bb <- get_osm_bb("Bucharest")
crs <- get_utm_zone(bb)
get_osm_railways(bb, crs)
\dontshow{\}) # examplesIf}
}
