% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-zonstat.R, R/op-cdo-zonavg.R,
%   R/op-cdo-zonkurt.R, R/op-cdo-zonmax.R, R/op-cdo-zonmean.R,
%   R/op-cdo-zonmedian.R, R/op-cdo-zonmin.R, R/op-cdo-zonpctl.R,
%   R/op-cdo-zonrange.R, R/op-cdo-zonskew.R, R/op-cdo-zonstd.R,
%   R/op-cdo-zonstd1.R, R/op-cdo-zonsum.R, R/op-cdo-zonvar.R, R/op-cdo-zonvar1.R
\name{zonstat}
\alias{zonstat}
\alias{cdo_zonavg}
\alias{cdo_zonkurt}
\alias{cdo_zonmax}
\alias{cdo_zonmean}
\alias{cdo_zonmedian}
\alias{cdo_zonmin}
\alias{cdo_zonpctl}
\alias{cdo_zonrange}
\alias{cdo_zonskew}
\alias{cdo_zonstd}
\alias{cdo_zonstd1}
\alias{cdo_zonsum}
\alias{cdo_zonvar}
\alias{cdo_zonvar1}
\title{Zonal statistics}
\usage{
cdo_zonavg(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonkurt(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonmax(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonmean(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonmedian(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonmin(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonpctl(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonrange(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonskew(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonstd(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonstd1(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonsum(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonvar(ifile, p = NULL, zonaldes = NULL, ofile = NULL)

cdo_zonvar1(ifile, p = NULL, zonaldes = NULL, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{p}{FLOAT - Percentile number in \{0, ..., 100\}}

\item{zonaldes}{STRING - Description of the zonal latitude bins needed for data on an unstructured grid. A predefined zonal description is zonal_<DY>. DY is the increment of the latitudes in degrees.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module computes zonal statistical values of the input fields. Depending on the chosen operator, the zonal minimum, maximum, range, sum, average, standard deviation, variance, skewness, kurtosis, median or a certain percentile of the field is written to outfile. Operators of this module require all variables on the same regular lon/lat grid. Only the zonal mean (zonmean) can be calculated for data on an unstructured grid if the latitude bins are defined with the optional parameter zonaldes.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{zonmin     Zonal minimum
           For every latitude the minimum over all longitudes is computed.
zonmax     Zonal maximum
           For every latitude the maximum over all longitudes is computed.
zonrange   Zonal range
           For every latitude the range over all longitudes is computed.
zonsum     Zonal sum
           For every latitude the sum over all longitudes is computed.
zonmean    Zonal mean
           For every latitude the mean over all longitudes is computed.
           Use the optional parameter zonaldes for data on an unstructured grid.
zonavg     Zonal average
           For every latitude the average over all longitudes is computed.
zonstd     Zonal standard deviation
           For every latitude the standard deviation over all longitudes is computed. Normalize by n.
zonstd1    Zonal standard deviation (n-1)
           For every latitude the standard deviation over all longitudes is computed. Normalize by (n-1).
zonvar     Zonal variance
           For every latitude the variance over all longitudes is computed. Normalize by n.
zonvar1    Zonal variance (n-1)
           For every latitude the variance over all longitudes is computed. Normalize by (n-1).
zonskew    Zonal skewness
           For every latitude the skewness over all longitudes is computed.
zonkurt    Zonal kurtosis
           For every latitude the kurtosis over all longitudes is computed.
zonmedian  Zonal median
           For every latitude the median over all longitudes is computed.
zonpctl    Zonal percentiles
           For every latitude the pth percentile over all longitudes is computed.
}\if{html}{\out{</div>}}
}
