% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-splitsel.R, R/op-cdo-splitsel.R
\name{splitsel}
\alias{splitsel}
\alias{cdo_splitsel}
\title{Split selected timesteps}
\usage{
cdo_splitsel(ifile, nsets = NULL, noffset = NULL, nskip = NULL, obase = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{nsets}{INTEGER - Number of input timesteps for each output file}

\item{noffset}{INTEGER - Number of input timesteps skipped before the first timestep range (optional)}

\item{nskip}{INTEGER - Number of input timesteps skipped between timestep ranges (optional)}

\item{obase}{String with the basename of the output files.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This operator splits infile into pieces, one for each adjacent sequence t_1, ...., t_n of timesteps of the same selected time range. The output files will be named <obase><nnnnnn><suffix> where nnnnnn is the sequence number and suffix is the filename extension derived from the file format.
}
