% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-seasstat.R, R/op-cdo-seasavg.R,
%   R/op-cdo-seasmax.R, R/op-cdo-seasmean.R, R/op-cdo-seasmin.R,
%   R/op-cdo-seasrange.R, R/op-cdo-seasstd.R, R/op-cdo-seasstd1.R,
%   R/op-cdo-seassum.R, R/op-cdo-seasvar.R, R/op-cdo-seasvar1.R
\name{seasstat}
\alias{seasstat}
\alias{cdo_seasavg}
\alias{cdo_seasmax}
\alias{cdo_seasmean}
\alias{cdo_seasmin}
\alias{cdo_seasrange}
\alias{cdo_seasstd}
\alias{cdo_seasstd1}
\alias{cdo_seassum}
\alias{cdo_seasvar}
\alias{cdo_seasvar1}
\title{Seasonal statistics}
\usage{
cdo_seasavg(ifile, ofile = NULL)

cdo_seasmax(ifile, ofile = NULL)

cdo_seasmean(ifile, ofile = NULL)

cdo_seasmin(ifile, ofile = NULL)

cdo_seasrange(ifile, ofile = NULL)

cdo_seasstd(ifile, ofile = NULL)

cdo_seasstd1(ifile, ofile = NULL)

cdo_seassum(ifile, ofile = NULL)

cdo_seasvar(ifile, ofile = NULL)

cdo_seasvar1(ifile, ofile = NULL)
}
\arguments{
\item{ifile}{String with the path to the input file.}

\item{ofile}{String with the path to the output file.}
}
\value{
Operators that output one or more files return a character vector to the
output files.

Operators that output an indefinite number of files return a string with the
basename of the files.

Operators that don't return filenames return a character vector with the
string output.
}
\description{
This module computes statistical values over timesteps of the same meteorological season. Depending on the chosen operator the minimum, maximum, range, sum, average, variance or standard deviation of timesteps of the same season is written to outfile. The time of outfile is determined by the time in the middle of all contributing timesteps of infile. This can be change with the CDO option --timestat_date <first|middle|last>. Be careful about the first and the last output timestep, they may be incorrect values if the seasons have incomplete timesteps.
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{seasmin    Seasonal minimum
           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = min\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasmax    Seasonal maximum
           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = max\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasrange  Seasonal range
           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = range\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seassum    Seasonal sum
           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = sum\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasmean   Seasonal mean
           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = mean\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasavg    Seasonal average
           For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = avg\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasstd    Seasonal standard deviation
           Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = std\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasstd1   Seasonal standard deviation (n-1)
           Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = std1\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasvar    Seasonal variance
           Normalize by n. For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = var\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
seasvar1   Seasonal variance (n-1)
           Normalize by (n-1). For every adjacent sequence t_1, ...,t_n of timesteps of the same season it is:
           
           o(t,x) = var1\\\{i(t',x), t1 &lt; t' &lt;= tn\\\}
}\if{html}{\out{</div>}}
}
