% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crosscalibrate_lens.R
\name{crosscalibrate_lens}
\alias{crosscalibrate_lens}
\title{Cross-calibrate lens}
\usage{
crosscalibrate_lens(
  path_to_csv_uncal,
  path_to_csv_cal,
  zenith_colrow_uncal,
  zenith_colrow_cal,
  diameter_cal,
  lens_coef,
  degree = 3
)
}
\arguments{
\item{path_to_csv_uncal, path_to_csv_cal}{Character vector of length one. Path
to a CSV file created with the
\href{https://imagej.net/ij/docs/guide/146-19.html#sec:Multi-point-Tool}{point selection tool of ‘ImageJ’ software}
(\emph{cal} and \emph{uncal} stand for calibrated and uncalibrated, respectively).}

\item{zenith_colrow_uncal, zenith_colrow_cal}{Numeric vector of length two.
Raster coordinates of the zenith. See
\code{\link[=calc_zenith_colrow]{calc_zenith_colrow()}} (\emph{cal} and \emph{uncal} stand
for calibrated and uncalibrated, respectively).}

\item{diameter_cal}{Numeric vector of length one. Diameter in pixels of the
image taken with the calibrated camera.}

\item{lens_coef}{numeric}

\item{degree}{Numeric vector of length one. Polynomial model degree.}
}
\value{
An object of class \emph{list} with named elements. \emph{ds} is the dataset
used to fit the model, \emph{model} is the fitted model (class \code{lm}, see
\code{\link[stats:lm]{stats::lm()}}), \emph{horizon_radius} is the radius at 90º, \emph{lens_coef} is a
numeric vector of length equal to the \code{degree} argument containing the
polynomial model coefficients for predicting relative radius
(\code{coefficients(model)/horizon_radius}).
}
\description{
Cross-calibrate lens
}
\details{
Read the help page of \code{\link[=calibrate_lens]{calibrate_lens()}} for understanding the theory
being this function.

This function is intended to be used when a camera calibrated with a method
of higher accuracy than the one proposed in \code{\link[=calibrate_lens]{calibrate_lens()}} is
available or there is a main camera to which all other devices should be
adjusted.

It requires two photographs taken from the exact same location with the
calibrated and uncalibrated camera. This means that the lens entrance pupils
should match and the optical axes should be aligned.

Points should be digitized in tandem with ImageJ and saved as CSV files.
}
\seealso{
Other Lens Functions: 
\code{\link{azimuth_image}()},
\code{\link{calc_diameter}()},
\code{\link{calc_relative_radius}()},
\code{\link{calc_zenith_colrow}()},
\code{\link{calibrate_lens}()},
\code{\link{expand_noncircular}()},
\code{\link{extract_radiometry}()},
\code{\link{fisheye_to_equidistant}()},
\code{\link{fisheye_to_pano}()},
\code{\link{lens}()},
\code{\link{test_lens_coef}()},
\code{\link{zenith_image}()}
}
\concept{Lens Functions}
