% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpaRaoP.R
\name{mpaRaoP}
\alias{mpaRaoP}
\title{Multidimensional parallel Parametric Rao's index of quadratic entropy (Q)}
\usage{
mpaRaoP(
  x,
  alpha,
  window,
  dist_m,
  na.tolerance,
  rescale,
  lambda,
  diag,
  time_vector,
  stepness,
  midpoint,
  cycle_length,
  time_scale,
  debugging,
  isfloat,
  mfactor,
  np,
  progBar
)
}
\arguments{
\item{x}{input list.}

\item{alpha}{alpha value for order of diversity in Hill's Index.}

\item{window}{half of the side of the square moving window.}

\item{dist_m}{Type of distance used.}

\item{na.tolerance}{a numeric value \eqn{(0.0-1.0)} which indicates the proportion
of NA values that will be tolerated to calculate Rao's index in each moving
window over \emph{x}. If the relative proportion of NA's in a moving window is
bigger than na.tolerance, then the value of the window will be set as NA,
otherwise Rao's index will be calculated considering the non-NA values.
Default values is 0.0 (i.e., no tolerance for NA's).}

\item{rescale}{Scale and centre values in each of the element of x.}

\item{lambda}{Lambda value for Minkowski distance.}

\item{diag}{Boolean. Diagonal of the distance matrix.}

\item{time_vector}{time;}

\item{stepness}{numeric; steepness of the logistic function.}

\item{midpoint}{numeric; midpoint of the logistic function}

\item{cycle_length}{string; The length of the cycle. Can be a numeric value or a string specifying the units ('year', 'month', 'day', 'hour', 'minute', 'second'). When numeric, the cycle length is in the same units as time_scale. When a string, it specifies the time unit of the cycle.}

\item{time_scale}{string; Specifies the time scale for the conversion. Must be one of 'year', 'month', 'day', 'hour', 'minute', 'second'. When cycle_length is a string, time_scale changes the unit in which the result is expressed. When cycle_length is numeric, time_scale is used to compute the elapsed time in seconds.}

\item{debugging}{a boolean variable set to FALSE by default. If TRUE, additional
messages will be printed. For de-bugging only.}

\item{isfloat}{Are the input data floats?}

\item{mfactor}{Multiplication factor in case of input data as float numbers.}

\item{np}{the number of processes (cores) which will be spawned.}

\item{progBar}{logical. If TRUE a progress bar is shown.}
}
\value{
A list of matrices of dimension \code{dim(x)} with length equal to the
  length of \code{alpha}.
}
\description{
Multidimensional parametric Rao's index of quadratic entropy (Q).
}
\seealso{
\code{\link{paRao}}
}
\author{
Duccio Rocchini \email{duccio.rocchini@unibo.it}, Marcantonio Matteo
  \email{marcantoniomatteo@gmail.com}
}
\keyword{internal}
