#functions for doing diurnal rhythm analyses
#
#
#a function to estimate diurnal phase of mood data
#the input is a data frame or matrix with 
#time of measurement (in 24 hour clock)
#and  then the mood measures (1 or many) 
#Version of October 22, 2008
#
#find the best fitting phase  (in hours)
"cosinor" <- 
function(data,code=NULL,period=24) {
nvar <- dim(data)[2]-1
if(is.null(code)) { fit <- cosinor1(data,period=period)
plot(data[,1:2])
m.resp <- mean(data[2])
s.resp <- sd(data[2])
curve(cos((x-fit[1,1])*pi/12)*s.resp+m.resp,add=TRUE)
     }  else  { fit.list <- by(data,code,cosinor1,period=period)
   ncases <- length(fit.list)
   fit<- matrix(unlist(fit.list),nrow=ncases,byrow=TRUE)
   colnames(fit) <- c(paste(colnames(data[2:(nvar+1)]), "phase",sep="."),paste(colnames(data[2:(nvar+1)]), "fit",sep="."))  
 }
return(fit)
}

"cosinor1" <-
function(data,period) {
response <- data
num.var <- dim(data)[2] -1
fit <- matrix(NA,nrow=num.var,ncol=2)
for (i in 1:num.var) {
fits <- optimize(f=phaser,c(0,24),time=data[,1],response=data[,1+i],period=period,maximum=TRUE)
fit[i,1] <- fits$maximum
fit[i,2] <- fits$objective
}
colnames(fit) <- c("phase","fit")
return(fit)
}

"phaser" <- function(phase,time,response,period) {
   phaser <- cor(cos(((time-phase)*2*pi)/period),response)}
   
   
##
#
#find the mean phase of output from cosiner or any other circular data set
#can find the mean phase of data in radians or hours (default)
#
"circadian.mean" <- 
function(angle,hours=TRUE) {
if(hours) { angle <- angle*2*pi/24 }
x <- cos(angle)
y <- sin(angle)
if (is.vector(angle)) {
mx <- mean(x)
my <- mean(y) } else { 
mx <- colMeans(x)
my <- colMeans(y) }
mean.angle <- sign(my) * acos((mx)/sqrt(mx^2+my^2)) 
#mean.angle <- atan(my/mx)   #according to circular stats, but the other form is clearer
if (hours) {mean.angle <- mean.angle*24/(2*pi)
mean.angle[mean.angle <= 0] <-  mean.angle[mean.angle<=0] + 24}
return(mean.angle)
}


## The circular correlation matrix of phase data
#adapted from the circStats package
#

"circadian.cor"  <- 
function(angle,hours=TRUE) {
if(hours) { angle <- angle*2*pi/24 }
nvar <- dim(angle)[2]
correl <- diag(nvar)
x <- cos(angle)
y <- sin(angle)
mx <- colMeans(x)
my <- colMeans(y) 
mean.angle <- sign(my) * acos((mx)/sqrt(mx^2+my^2)) 

for (i in 1:nvar) {#the logic is that larger deviations are weighted more, up to the sin(theta)
  for (j in 1:i) {covar <-  sum(sin(angle[,i] -mean.angle[i]) *sin(angle[,j] -mean.angle[j]))   
  correl[i,j] <- correl[j,i] <- covar}
}
sd <- diag(sqrt(1/diag(correl)))
correl <- sd %*% correl %*% sd
colnames(correl) <- rownames(correl) <- colnames(angle)
return(correl) }





"circadian.linear.cor" <- 
function(angle,x,hours=TRUE) {
if(hours) { angle <- angle*2*pi/24 }
cos.angle <- cos(angle)
sin.angle <- sin(angle)
cor.cos <- cor(cos.angle,x)
cor.sin <- cor(sin.angle,x)
if(!is.vector(angle)) {cor.cs <- diag(cor(cos.angle,sin.angle))} else {cor.cs <- cor(cos.angle,sin.angle)}
R <- sqrt((cor.cos^2 + cor.sin^2 - 2 * cor.cos * cor.sin * cor.cs)/(1-cor.cs^2))
return(R) }



