% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{general_clean_directory}
\alias{general_clean_directory}
\title{Mutate operation(s) in Scottish post office general directory data.frame
column(s)}
\usage{
general_clean_directory(directory, progress = TRUE, verbose = FALSE)
}
\arguments{
\item{directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{forename}, \code{surname}, \code{occupation} and \code{addresses}.}

\item{progress}{Whether progress should be shown (\code{TRUE}) or not (\code{FALSE}).}

\item{verbose}{Whether the function should be executed silently (\code{FALSE}) or
not (\code{TRUE}).}
}
\value{
A \code{\link[tibble]{tibble}}; columns include at least
\code{forename}, \code{surname}, \code{occupation}, \code{address.trade.number},
\code{address.trade.body}, \code{address.house.number} and \code{address.house.body}.
"house" suffix in \code{occupation} column is move to \code{addresses}, occupation
information is repatriated from \code{addresses} to \code{occupation} column;
\code{addresses} is split into trade and house address columns; additional
records are created for each extra trade address identified. Entries are
further cleaned of optical character recognition (OCR) errors and subject
to a number of standardisation operations.
}
\description{
Attempts to clean the provided Scottish post office general directory
data.frame.
}
\examples{
pages <- rep("71", 2L)
surnames <- c("ABOT", "ABRCROMBIE")
forenames <- c("Wm.", "Alex")
occupations <- c("Wine and spirit mercht - See Advertisement in Appendix.", "")
addresses = c(
  "1S20 Londn rd; ho. 13<J Queun sq",
  "Bkr; I2 Dixon Street, & 29 Auderstn Qu.; res 2G5 Argul st."
)
directory <- tibble::tibble(
  page = pages, surname = surnames, forename = forenames,
  occupation = occupations, addresses = addresses
)
general_clean_directory(directory, progress = TRUE, verbose = FALSE)

}
