% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pl_search.R
\name{pl_search}
\alias{pl_search}
\alias{pl_search_loc}
\alias{pl_search_names}
\alias{pl_search_places}
\title{Search for a place, name or location.}
\usage{
pl_search(query = NULL, ...)

pl_search_loc(query = NULL, ...)

pl_search_names(query = NULL, ...)

pl_search_places(query = NULL, ...)
}
\arguments{
\item{query}{A place ID. If left NULL, returns the table, which is of
class \code{tbl}, which can then be passed on to other
\pkg{dplyr} functions.}

\item{...}{Further args passed on to \code{\link[dplyr]{tbl}}}
}
\description{
This function searches a locally created SQLite database created
from csv files.
}
\details{
On the first query if not run before, the function takes a bit
to get the raw data (if not already gotten), temporarily load the raw
csv data, then create a SQLite database, and create the pointer to it.
Subsequent calls should be very fast.

There is a function \code{\link{pl_cache}}, used to download the raw
csv files. That function is run internally in these functions if you have
not run it before, or if only some fo the files are present.
}
\examples{
\dontrun{
pl_search()
pl_search_loc()
pl_search_names()
pl_search_places()

pl_search_loc("SELECT * FROM locations limit 5")
pl_search_names("SELECT * FROM names limit 5")
pl_search_places("SELECT * FROM places limit 5")

library(dplyr)
locs <- pl_search("SELECT * FROM locations limit 1000") \%>\%
  select(pid, reprLat, reprLong)
nms <- pl_search("SELECT * FROM names limit 1000") \%>\% select(pid)
left_join(locs, nms, "pid", copy = TRUE) \%>\% collect \%>\% NROW
}
}

