% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj_inv.R
\name{proj_inv}
\alias{proj_inv}
\title{Calculates projected inventories and coverages and perform an analysis vs stocks targets}
\usage{
proj_inv(dataset, DFU, Period, Demand, Opening, Supply, Min.Cov, Max.Cov)
}
\arguments{
\item{dataset}{a dataframe with the demand and supply features for an item per period}

\item{DFU}{name of an item, a SKU, or a node like an item x location}

\item{Period}{a period of time monthly or weekly buckets for example}

\item{Demand}{the quantity of an item planned to be consumed in units for a given period}

\item{Opening}{the opening inventories of an item in units at the beginning of the horizon}

\item{Supply}{the quantity of an item planned to be supplied in units for a given period}

\item{Min.Cov}{minimum stocks target of an item expressed in periods}

\item{Max.Cov}{maximum stocks target of an item expressed in periods}
}
\value{
a dataframe with the calculated projected inventories and coverages and the related analysis
}
\description{
Calculates projected inventories and coverages and perform an analysis vs stocks targets
}
\examples{
proj_inv(dataset = blueprint, DFU, Period, Demand, Opening, Supply, Min.Cov, Max.Cov)
}
