% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_generative_trees.R
\name{create_bd_tree}
\alias{create_bd_tree}
\title{Create a (constant-rate) birth-death (BD) tree}
\usage{
create_bd_tree(n_taxa = 6, crown_age = 10, n_0 = 2, mu = 0.1)
}
\arguments{
\item{n_taxa}{number of tree tips}

\item{crown_age}{the fixed crown age of the posterior. Set to NA
to let it be estimated}

\item{n_0}{number of starting species}

\item{mu}{per-species extinction rate}
}
\value{
a phylogenetic tree of type \link[ape]{phylo}
}
\description{
Create a (constant-rate) birth-death (BD) tree
}
\examples{
n_taxa <- 31
crown_age <- 41
phylogeny <- create_bd_tree(
  n_taxa = n_taxa,
  crown_age = crown_age
)
}
\author{
Giovanni Laudanno, Richèl J.C. Bilderbeek
}
