% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{wl_midpoint}
\alias{wl_midpoint}
\alias{midpoint}
\alias{midpoint.default}
\alias{midpoint.numeric}
\alias{midpoint.waveband}
\alias{midpoint.generic_spct}
\alias{midpoint.generic_mspct}
\title{Midpoint}
\usage{
wl_midpoint(x, ...)

midpoint(x, ...)

\method{midpoint}{default}(x, ...)

\method{midpoint}{numeric}(x, ...)

\method{midpoint}{waveband}(x, ...)

\method{midpoint}{generic_spct}(x, ...)

\method{midpoint}{generic_mspct}(x, ..., idx = "spct.idx")
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
A numeric value equal to \code{max(x) - min(x)) / 2}. In the case of
  spectral objects a wavelength [\eqn{nm}]. For any other R object, according
  to available definitions of \code{\link{min}} and \code{\link{max}}.
}
\description{
A method that returns the wavelength [\eqn{nm}] (or value) at the center of
the wavelength range of objects of classes \code{waveband} or of class
\code{generic_spct} or derived (or the midpoint from a \code{numeric}
vector).
}
\section{Methods (by class)}{
\itemize{
\item \code{midpoint(default)}: Default method for generic function

\item \code{midpoint(numeric)}: Default method for generic function

\item \code{midpoint(waveband)}: Wavelength at center of a "waveband".

\item \code{midpoint(generic_spct)}: Method for "generic_spct".

\item \code{midpoint(generic_mspct)}: Method for "generic_mspct" objects.

}}
\examples{
midpoint(10:20)
midpoint(sun.spct)
wl_midpoint(sun.spct)

midpoint(sun.spct)

}
\seealso{
Other wavelength summaries: 
\code{\link{wl_min}()},
\code{\link{wl_range}()},
\code{\link{wl_stepsize}()}

Other wavelength summaries: 
\code{\link{wl_min}()},
\code{\link{wl_range}()},
\code{\link{wl_stepsize}()}

Other wavelength summaries: 
\code{\link{wl_min}()},
\code{\link{wl_range}()},
\code{\link{wl_stepsize}()}
}
\concept{wavelength summaries}
