\name{fit_phenology}
\alias{fit_phenology}
\title{Fits the phenology parameters to timeseries.}
\usage{
  fit_phenology(data = NULL, parametersfit = NULL,
    parametersfixed = NA, trace = 1,
    method_incertitude = 2, zero_counts = TRUE,
    hessian = TRUE, help = FALSE)
}
\arguments{
  \item{data}{A dataset generated by add_format}

  \item{parametersfixed}{Set of fixed parameters}

  \item{parametersfit}{Set of parameters to be fitted}

  \item{trace}{If 1, display the progression of fit; 0 is
  silent}

  \item{method_incertitude}{2 [default] is the correct one
  from a statistical point of view; 0 is an aproximate
  method more rapid; 1 is an alternative more rapid but
  biased.}

  \item{zero_counts}{example c(TRUE, TRUE, FALSE) indicates
  whether the zeros have been recorder for each of these
  timeseries. Defaut is TRUE for all.}

  \item{hessian}{If FALSE does not estimate se of
  parameters}

  \item{help}{If TRUE, an help is displayed}
}
\value{
  Return a list of with data and result
}
\description{
  Function of the package phenology to fit parameters to
  timeseries. To fit data, the syntaxe is :
  Result<-fit_phenology(data=dataset, parametersfit=par,
  parametersfixed=pfixed, trace=1, + method_incertitude=2,
  zero_counts=TRUE, hessian=TRUE) or if no parameter is
  fixed : Result<-fit_phenology(data=dataset,
  parametersfit=par) or fit_phenology(help=TRUE) to have
  this help ! Add trace=1 [default] to have information on
  the fit progression. or trace=0 to hide information on
  the fit progression. method_incertitude=2 [default] is
  the correct one from a statistical point of view.
  method_incertitude=0 is an aproximate method more rapid.
  method_incertitude=1 is an alternative more rapid but
  biased. zero_counts=c(TRUE, TRUE, FALSE) indicates
  whether the zeros have been recorder for each of these
  timeseries. Defaut is TRUE for all. hessian=FALSE does
  not estimate se of parameters.
}
\details{
  fit_phenology fits parameters to timeseries.
}
\author{
  Marc Girondot
}

