% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_fleet_history}
\alias{ec2_describe_fleet_history}
\title{Describes the events for the specified EC2 Fleet during the specified
time}
\usage{
ec2_describe_fleet_history(
  DryRun = NULL,
  EventType = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  FleetId,
  StartTime
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{EventType}{The type of events to describe. By default, all events are described.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{FleetId}{[required] The ID of the EC2 Fleet.}

\item{StartTime}{[required] The start date and time for the events, in UTC format (for example,
\emph{YYYY}-\emph{MM}-\emph{DD}T\emph{HH}:\emph{MM}:\emph{SS}Z).}
}
\description{
Describes the events for the specified EC2 Fleet during the specified time.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_fleet_history/} for full documentation.
}
\keyword{internal}
