% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_add_layer_version_permission}
\alias{lambda_add_layer_version_permission}
\title{Adds permissions to the resource-based policy of a version of an Lambda
layer}
\usage{
lambda_add_layer_version_permission(
  LayerName,
  VersionNumber,
  StatementId,
  Action,
  Principal,
  OrganizationId = NULL,
  RevisionId = NULL
)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{VersionNumber}{[required] The version number.}

\item{StatementId}{[required] An identifier that distinguishes the policy from others on the same
layer version.}

\item{Action}{[required] The API action that grants access to the layer. For example,
\code{lambda:GetLayerVersion}.}

\item{Principal}{[required] An account ID, or \code{*} to grant layer usage permission to all accounts in
an organization, or all Amazon Web Services accounts (if
\code{organizationId} is not specified). For the last case, make sure that
you really do want all Amazon Web Services accounts to have usage
permission to this layer.}

\item{OrganizationId}{With the principal set to \code{*}, grant permission to all accounts in the
specified organization.}

\item{RevisionId}{Only update the policy if the revision ID matches the ID specified. Use
this option to avoid modifying a policy that has changed since you last
read it.}
}
\description{
Adds permissions to the resource-based policy of a version of an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{Lambda layer}. Use this action to grant layer usage permission to other accounts. You can grant permission to a single account, all accounts in an organization, or all Amazon Web Services accounts.

See \url{https://www.paws-r-sdk.com/docs/lambda_add_layer_version_permission/} for full documentation.
}
\keyword{internal}
