% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_subnet_cidr_reservation}
\alias{ec2_create_subnet_cidr_reservation}
\title{Creates a subnet CIDR reservation}
\usage{
ec2_create_subnet_cidr_reservation(
  SubnetId,
  Cidr,
  ReservationType,
  Description = NULL,
  DryRun = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{SubnetId}{[required] The ID of the subnet.}

\item{Cidr}{[required] The IPv4 or IPV6 CIDR range to reserve.}

\item{ReservationType}{[required] The type of reservation.

The following are valid values:
\itemize{
\item \code{prefix}: The Amazon EC2 Prefix Delegation feature assigns the IP
addresses to network interfaces that are associated with an
instance. For information about Prefix Delegation, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/}{Prefix Delegation for Amazon EC2 network interfaces} in
the \emph{Amazon Elastic Compute Cloud User Guide}.
\item \code{explicit}: You manually assign the IP addresses to resources that
reside in your subnet.
}}

\item{Description}{The description to assign to the subnet CIDR reservation.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to assign to the subnet CIDR reservation.}
}
\description{
Creates a subnet CIDR reservation. For information about subnet CIDR reservations, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/subnet-cidr-reservation.html}{Subnet CIDR reservations} in the \emph{Amazon Virtual Private Cloud User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_subnet_cidr_reservation/} for full documentation.
}
\keyword{internal}
