# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ecr_service.R
NULL

#' Checks the availability of one or more image layers in a repository
#'
#' @description
#' Checks the availability of one or more image layers in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_batch_check_layer_availability/](https://www.paws-r-sdk.com/docs/ecr_batch_check_layer_availability/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the image layers to check. If you do not specify a registry,
#' the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the image layers to
#' check.
#' @param layerDigests &#91;required&#93; The digests of the image layers to check.
#'
#' @keywords internal
#'
#' @rdname ecr_batch_check_layer_availability
ecr_batch_check_layer_availability <- function(registryId = NULL, repositoryName, layerDigests) {
  op <- new_operation(
    name = "BatchCheckLayerAvailability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$batch_check_layer_availability_input(registryId = registryId, repositoryName = repositoryName, layerDigests = layerDigests)
  output <- .ecr$batch_check_layer_availability_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$batch_check_layer_availability <- ecr_batch_check_layer_availability

#' Deletes a list of specified images within a repository
#'
#' @description
#' Deletes a list of specified images within a repository. Images are specified with either an `imageTag` or `imageDigest`.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_batch_delete_image/](https://www.paws-r-sdk.com/docs/ecr_batch_delete_image/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the image to delete. If you do not specify a registry, the
#' default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository that contains the image to delete.
#' @param imageIds &#91;required&#93; A list of image ID references that correspond to images to delete. The
#' format of the `imageIds` reference is `imageTag=tag` or
#' `imageDigest=digest`.
#'
#' @keywords internal
#'
#' @rdname ecr_batch_delete_image
ecr_batch_delete_image <- function(registryId = NULL, repositoryName, imageIds) {
  op <- new_operation(
    name = "BatchDeleteImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$batch_delete_image_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds)
  output <- .ecr$batch_delete_image_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$batch_delete_image <- ecr_batch_delete_image

#' Gets detailed information for an image
#'
#' @description
#' Gets detailed information for an image. Images are specified with either an `imageTag` or `imageDigest`.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_batch_get_image/](https://www.paws-r-sdk.com/docs/ecr_batch_get_image/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the images to describe. If you do not specify a registry, the
#' default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository that contains the images to describe.
#' @param imageIds &#91;required&#93; A list of image ID references that correspond to images to describe. The
#' format of the `imageIds` reference is `imageTag=tag` or
#' `imageDigest=digest`.
#' @param acceptedMediaTypes The accepted media types for the request.
#' 
#' Valid values: `application/vnd.docker.distribution.manifest.v1+json` |
#' `application/vnd.docker.distribution.manifest.v2+json` |
#' `application/vnd.oci.image.manifest.v1+json`
#'
#' @keywords internal
#'
#' @rdname ecr_batch_get_image
ecr_batch_get_image <- function(registryId = NULL, repositoryName, imageIds, acceptedMediaTypes = NULL) {
  op <- new_operation(
    name = "BatchGetImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$batch_get_image_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds, acceptedMediaTypes = acceptedMediaTypes)
  output <- .ecr$batch_get_image_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$batch_get_image <- ecr_batch_get_image

#' Gets the scanning configuration for one or more repositories
#'
#' @description
#' Gets the scanning configuration for one or more repositories.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_batch_get_repository_scanning_configuration/](https://www.paws-r-sdk.com/docs/ecr_batch_get_repository_scanning_configuration/) for full documentation.
#'
#' @param repositoryNames &#91;required&#93; One or more repository names to get the scanning configuration for.
#'
#' @keywords internal
#'
#' @rdname ecr_batch_get_repository_scanning_configuration
ecr_batch_get_repository_scanning_configuration <- function(repositoryNames) {
  op <- new_operation(
    name = "BatchGetRepositoryScanningConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$batch_get_repository_scanning_configuration_input(repositoryNames = repositoryNames)
  output <- .ecr$batch_get_repository_scanning_configuration_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$batch_get_repository_scanning_configuration <- ecr_batch_get_repository_scanning_configuration

#' Informs Amazon ECR that the image layer upload has completed for a
#' specified registry, repository name, and upload ID
#'
#' @description
#' Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and upload ID. You can optionally provide a `sha256` digest of the image layer for data validation purposes.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_complete_layer_upload/](https://www.paws-r-sdk.com/docs/ecr_complete_layer_upload/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry to which
#' to upload layers. If you do not specify a registry, the default registry
#' is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to associate with the image layer.
#' @param uploadId &#91;required&#93; The upload ID from a previous
#' [`initiate_layer_upload`][ecr_initiate_layer_upload] operation to
#' associate with the image layer.
#' @param layerDigests &#91;required&#93; The `sha256` digest of the image layer.
#'
#' @keywords internal
#'
#' @rdname ecr_complete_layer_upload
ecr_complete_layer_upload <- function(registryId = NULL, repositoryName, uploadId, layerDigests) {
  op <- new_operation(
    name = "CompleteLayerUpload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$complete_layer_upload_input(registryId = registryId, repositoryName = repositoryName, uploadId = uploadId, layerDigests = layerDigests)
  output <- .ecr$complete_layer_upload_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$complete_layer_upload <- ecr_complete_layer_upload

#' Creates a pull through cache rule
#'
#' @description
#' Creates a pull through cache rule. A pull through cache rule provides a way to cache images from an external public registry in your Amazon ECR private registry.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_create_pull_through_cache_rule/](https://www.paws-r-sdk.com/docs/ecr_create_pull_through_cache_rule/) for full documentation.
#'
#' @param ecrRepositoryPrefix &#91;required&#93; The repository name prefix to use when caching images from the source
#' registry.
#' @param upstreamRegistryUrl &#91;required&#93; The registry URL of the upstream public registry to use as the source
#' for the pull through cache rule.
#' @param registryId The Amazon Web Services account ID associated with the registry to
#' create the pull through cache rule for. If you do not specify a
#' registry, the default registry is assumed.
#'
#' @keywords internal
#'
#' @rdname ecr_create_pull_through_cache_rule
ecr_create_pull_through_cache_rule <- function(ecrRepositoryPrefix, upstreamRegistryUrl, registryId = NULL) {
  op <- new_operation(
    name = "CreatePullThroughCacheRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$create_pull_through_cache_rule_input(ecrRepositoryPrefix = ecrRepositoryPrefix, upstreamRegistryUrl = upstreamRegistryUrl, registryId = registryId)
  output <- .ecr$create_pull_through_cache_rule_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$create_pull_through_cache_rule <- ecr_create_pull_through_cache_rule

#' Creates a repository
#'
#' @description
#' Creates a repository. For more information, see [Amazon ECR repositories](https://docs.aws.amazon.com/AmazonECR/latest/userguide/Repositories.html) in the *Amazon Elastic Container Registry User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_create_repository/](https://www.paws-r-sdk.com/docs/ecr_create_repository/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry to
#' create the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name to use for the repository. The repository name may be specified
#' on its own (such as `nginx-web-app`) or it can be prepended with a
#' namespace to group the repository into a category (such as
#' `project-a/nginx-web-app`).
#' @param tags The metadata that you apply to the repository to help you categorize and
#' organize them. Each tag consists of a key and an optional value, both of
#' which you define. Tag keys can have a maximum character length of 128
#' characters, and tag values can have a maximum length of 256 characters.
#' @param imageTagMutability The tag mutability setting for the repository. If this parameter is
#' omitted, the default setting of `MUTABLE` will be used which will allow
#' image tags to be overwritten. If `IMMUTABLE` is specified, all image
#' tags within the repository will be immutable which will prevent them
#' from being overwritten.
#' @param imageScanningConfiguration The image scanning configuration for the repository. This determines
#' whether images are scanned for known vulnerabilities after being pushed
#' to the repository.
#' @param encryptionConfiguration The encryption configuration for the repository. This determines how the
#' contents of your repository are encrypted at rest.
#'
#' @keywords internal
#'
#' @rdname ecr_create_repository
ecr_create_repository <- function(registryId = NULL, repositoryName, tags = NULL, imageTagMutability = NULL, imageScanningConfiguration = NULL, encryptionConfiguration = NULL) {
  op <- new_operation(
    name = "CreateRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$create_repository_input(registryId = registryId, repositoryName = repositoryName, tags = tags, imageTagMutability = imageTagMutability, imageScanningConfiguration = imageScanningConfiguration, encryptionConfiguration = encryptionConfiguration)
  output <- .ecr$create_repository_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$create_repository <- ecr_create_repository

#' Deletes the lifecycle policy associated with the specified repository
#'
#' @description
#' Deletes the lifecycle policy associated with the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_delete_lifecycle_policy/](https://www.paws-r-sdk.com/docs/ecr_delete_lifecycle_policy/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository.
#'
#' @keywords internal
#'
#' @rdname ecr_delete_lifecycle_policy
ecr_delete_lifecycle_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "DeleteLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_lifecycle_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$delete_lifecycle_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_lifecycle_policy <- ecr_delete_lifecycle_policy

#' Deletes a pull through cache rule
#'
#' @description
#' Deletes a pull through cache rule.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_delete_pull_through_cache_rule/](https://www.paws-r-sdk.com/docs/ecr_delete_pull_through_cache_rule/) for full documentation.
#'
#' @param ecrRepositoryPrefix &#91;required&#93; The Amazon ECR repository prefix associated with the pull through cache
#' rule to delete.
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the pull through cache rule. If you do not specify a registry,
#' the default registry is assumed.
#'
#' @keywords internal
#'
#' @rdname ecr_delete_pull_through_cache_rule
ecr_delete_pull_through_cache_rule <- function(ecrRepositoryPrefix, registryId = NULL) {
  op <- new_operation(
    name = "DeletePullThroughCacheRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_pull_through_cache_rule_input(ecrRepositoryPrefix = ecrRepositoryPrefix, registryId = registryId)
  output <- .ecr$delete_pull_through_cache_rule_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_pull_through_cache_rule <- ecr_delete_pull_through_cache_rule

#' Deletes the registry permissions policy
#'
#' @description
#' Deletes the registry permissions policy.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_delete_registry_policy/](https://www.paws-r-sdk.com/docs/ecr_delete_registry_policy/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ecr_delete_registry_policy
ecr_delete_registry_policy <- function() {
  op <- new_operation(
    name = "DeleteRegistryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_registry_policy_input()
  output <- .ecr$delete_registry_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_registry_policy <- ecr_delete_registry_policy

#' Deletes a repository
#'
#' @description
#' Deletes a repository. If the repository contains images, you must either delete all images in the repository or use the `force` option to delete the repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_delete_repository/](https://www.paws-r-sdk.com/docs/ecr_delete_repository/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository to delete. If you do not specify a registry, the
#' default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to delete.
#' @param force If a repository contains images, forces the deletion.
#'
#' @keywords internal
#'
#' @rdname ecr_delete_repository
ecr_delete_repository <- function(registryId = NULL, repositoryName, force = NULL) {
  op <- new_operation(
    name = "DeleteRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_repository_input(registryId = registryId, repositoryName = repositoryName, force = force)
  output <- .ecr$delete_repository_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_repository <- ecr_delete_repository

#' Deletes the repository policy associated with the specified repository
#'
#' @description
#' Deletes the repository policy associated with the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_delete_repository_policy/](https://www.paws-r-sdk.com/docs/ecr_delete_repository_policy/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository policy to delete. If you do not specify a
#' registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the repository policy
#' to delete.
#'
#' @keywords internal
#'
#' @rdname ecr_delete_repository_policy
ecr_delete_repository_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "DeleteRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$delete_repository_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$delete_repository_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$delete_repository_policy <- ecr_delete_repository_policy

#' Returns the replication status for a specified image
#'
#' @description
#' Returns the replication status for a specified image.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_describe_image_replication_status/](https://www.paws-r-sdk.com/docs/ecr_describe_image_replication_status/) for full documentation.
#'
#' @param repositoryName &#91;required&#93; The name of the repository that the image is in.
#' @param imageId &#91;required&#93; 
#' @param registryId The Amazon Web Services account ID associated with the registry. If you
#' do not specify a registry, the default registry is assumed.
#'
#' @keywords internal
#'
#' @rdname ecr_describe_image_replication_status
ecr_describe_image_replication_status <- function(repositoryName, imageId, registryId = NULL) {
  op <- new_operation(
    name = "DescribeImageReplicationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_image_replication_status_input(repositoryName = repositoryName, imageId = imageId, registryId = registryId)
  output <- .ecr$describe_image_replication_status_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_image_replication_status <- ecr_describe_image_replication_status

#' Returns the scan findings for the specified image
#'
#' @description
#' Returns the scan findings for the specified image.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_describe_image_scan_findings/](https://www.paws-r-sdk.com/docs/ecr_describe_image_scan_findings/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository in which to describe the image scan findings
#' for. If you do not specify a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository for the image for which to describe the scan findings.
#' @param imageId &#91;required&#93; 
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings]
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value. This value is null when
#' there are no more results to return.
#' @param maxResults The maximum number of image scan results returned by
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings] in
#' paginated output. When this parameter is used,
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings] only
#' returns `maxResults` results in a single page along with a `nextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings]
#' request with the returned `nextToken` value. This value can be between 1
#' and 1000. If this parameter is not used, then
#' [`describe_image_scan_findings`][ecr_describe_image_scan_findings]
#' returns up to 100 results and a `nextToken` value, if applicable.
#'
#' @keywords internal
#'
#' @rdname ecr_describe_image_scan_findings
ecr_describe_image_scan_findings <- function(registryId = NULL, repositoryName, imageId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeImageScanFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_image_scan_findings_input(registryId = registryId, repositoryName = repositoryName, imageId = imageId, nextToken = nextToken, maxResults = maxResults)
  output <- .ecr$describe_image_scan_findings_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_image_scan_findings <- ecr_describe_image_scan_findings

#' Returns metadata about the images in a repository
#'
#' @description
#' Returns metadata about the images in a repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_describe_images/](https://www.paws-r-sdk.com/docs/ecr_describe_images/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository in which to describe images. If you do not
#' specify a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository that contains the images to describe.
#' @param imageIds The list of image IDs for the requested repository.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_images`][ecr_describe_images] request where `maxResults` was
#' used and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value. This value is `null` when there are no more results
#' to return. This option cannot be used when you specify images with
#' `imageIds`.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_images`][ecr_describe_images] in paginated output. When this
#' parameter is used, [`describe_images`][ecr_describe_images] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`describe_images`][ecr_describe_images] request with
#' the returned `nextToken` value. This value can be between 1 and 1000. If
#' this parameter is not used, then
#' [`describe_images`][ecr_describe_images] returns up to 100 results and a
#' `nextToken` value, if applicable. This option cannot be used when you
#' specify images with `imageIds`.
#' @param filter The filter key and value with which to filter your
#' [`describe_images`][ecr_describe_images] results.
#'
#' @keywords internal
#'
#' @rdname ecr_describe_images
ecr_describe_images <- function(registryId = NULL, repositoryName, imageIds = NULL, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_images_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .ecr$describe_images_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_images <- ecr_describe_images

#' Returns the pull through cache rules for a registry
#'
#' @description
#' Returns the pull through cache rules for a registry.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_describe_pull_through_cache_rules/](https://www.paws-r-sdk.com/docs/ecr_describe_pull_through_cache_rules/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry to
#' return the pull through cache rules for. If you do not specify a
#' registry, the default registry is assumed.
#' @param ecrRepositoryPrefixes The Amazon ECR repository prefixes associated with the pull through
#' cache rules to return. If no repository prefix value is specified, all
#' pull through cache rules are returned.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `DescribePullThroughCacheRulesRequest` request where `maxResults` was
#' used and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value. This value is null when there are no more results to
#' return.
#' @param maxResults The maximum number of pull through cache rules returned by
#' `DescribePullThroughCacheRulesRequest` in paginated output. When this
#' parameter is used, `DescribePullThroughCacheRulesRequest` only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another `DescribePullThroughCacheRulesRequest` request with the
#' returned `nextToken` value. This value can be between 1 and 1000. If
#' this parameter is not used, then `DescribePullThroughCacheRulesRequest`
#' returns up to 100 results and a `nextToken` value, if applicable.
#'
#' @keywords internal
#'
#' @rdname ecr_describe_pull_through_cache_rules
ecr_describe_pull_through_cache_rules <- function(registryId = NULL, ecrRepositoryPrefixes = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribePullThroughCacheRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_pull_through_cache_rules_input(registryId = registryId, ecrRepositoryPrefixes = ecrRepositoryPrefixes, nextToken = nextToken, maxResults = maxResults)
  output <- .ecr$describe_pull_through_cache_rules_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_pull_through_cache_rules <- ecr_describe_pull_through_cache_rules

#' Describes the settings for a registry
#'
#' @description
#' Describes the settings for a registry. The replication configuration for a repository can be created or updated with the [`put_replication_configuration`][ecr_put_replication_configuration] API action.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_describe_registry/](https://www.paws-r-sdk.com/docs/ecr_describe_registry/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ecr_describe_registry
ecr_describe_registry <- function() {
  op <- new_operation(
    name = "DescribeRegistry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_registry_input()
  output <- .ecr$describe_registry_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_registry <- ecr_describe_registry

#' Describes image repositories in a registry
#'
#' @description
#' Describes image repositories in a registry.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_describe_repositories/](https://www.paws-r-sdk.com/docs/ecr_describe_repositories/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repositories to be described. If you do not specify a
#' registry, the default registry is assumed.
#' @param repositoryNames A list of repositories to describe. If this parameter is omitted, then
#' all repositories in a registry are described.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`describe_repositories`][ecr_describe_repositories] request where
#' `maxResults` was used and the results exceeded the value of that
#' parameter. Pagination continues from the end of the previous results
#' that returned the `nextToken` value. This value is `null` when there are
#' no more results to return. This option cannot be used when you specify
#' repositories with `repositoryNames`.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of repository results returned by
#' [`describe_repositories`][ecr_describe_repositories] in paginated
#' output. When this parameter is used,
#' [`describe_repositories`][ecr_describe_repositories] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`describe_repositories`][ecr_describe_repositories]
#' request with the returned `nextToken` value. This value can be between 1
#' and 1000. If this parameter is not used, then
#' [`describe_repositories`][ecr_describe_repositories] returns up to 100
#' results and a `nextToken` value, if applicable. This option cannot be
#' used when you specify repositories with `repositoryNames`.
#'
#' @keywords internal
#'
#' @rdname ecr_describe_repositories
ecr_describe_repositories <- function(registryId = NULL, repositoryNames = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$describe_repositories_input(registryId = registryId, repositoryNames = repositoryNames, nextToken = nextToken, maxResults = maxResults)
  output <- .ecr$describe_repositories_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$describe_repositories <- ecr_describe_repositories

#' Retrieves an authorization token
#'
#' @description
#' Retrieves an authorization token. An authorization token represents your IAM authentication credentials and can be used to access any Amazon ECR registry that your IAM principal has access to. The authorization token is valid for 12 hours.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_get_authorization_token/](https://www.paws-r-sdk.com/docs/ecr_get_authorization_token/) for full documentation.
#'
#' @param registryIds A list of Amazon Web Services account IDs that are associated with the
#' registries for which to get AuthorizationData objects. If you do not
#' specify a registry, the default registry is assumed.
#'
#' @keywords internal
#'
#' @rdname ecr_get_authorization_token
ecr_get_authorization_token <- function(registryIds = NULL) {
  op <- new_operation(
    name = "GetAuthorizationToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_authorization_token_input(registryIds = registryIds)
  output <- .ecr$get_authorization_token_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_authorization_token <- ecr_get_authorization_token

#' Retrieves the pre-signed Amazon S3 download URL corresponding to an
#' image layer
#'
#' @description
#' Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can only get URLs for image layers that are referenced in an image.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_get_download_url_for_layer/](https://www.paws-r-sdk.com/docs/ecr_get_download_url_for_layer/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the image layer to download. If you do not specify a registry,
#' the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that is associated with the image layer to
#' download.
#' @param layerDigest &#91;required&#93; The digest of the image layer to download.
#'
#' @keywords internal
#'
#' @rdname ecr_get_download_url_for_layer
ecr_get_download_url_for_layer <- function(registryId = NULL, repositoryName, layerDigest) {
  op <- new_operation(
    name = "GetDownloadUrlForLayer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_download_url_for_layer_input(registryId = registryId, repositoryName = repositoryName, layerDigest = layerDigest)
  output <- .ecr$get_download_url_for_layer_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_download_url_for_layer <- ecr_get_download_url_for_layer

#' Retrieves the lifecycle policy for the specified repository
#'
#' @description
#' Retrieves the lifecycle policy for the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_get_lifecycle_policy/](https://www.paws-r-sdk.com/docs/ecr_get_lifecycle_policy/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository.
#'
#' @keywords internal
#'
#' @rdname ecr_get_lifecycle_policy
ecr_get_lifecycle_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "GetLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_lifecycle_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$get_lifecycle_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_lifecycle_policy <- ecr_get_lifecycle_policy

#' Retrieves the results of the lifecycle policy preview request for the
#' specified repository
#'
#' @description
#' Retrieves the results of the lifecycle policy preview request for the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_get_lifecycle_policy_preview/](https://www.paws-r-sdk.com/docs/ecr_get_lifecycle_policy_preview/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository.
#' @param imageIds The list of imageIDs to be included.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `GetLifecyclePolicyPreviewRequest` request where `maxResults` was used
#' and the results exceeded the value of that parameter. Pagination
#' continues from the end of the previous results that returned the
#' `nextToken` value. This value is `null` when there are no more results
#' to return. This option cannot be used when you specify images with
#' `imageIds`.
#' @param maxResults The maximum number of repository results returned by
#' `GetLifecyclePolicyPreviewRequest` in paginated output. When this
#' parameter is used, `GetLifecyclePolicyPreviewRequest` only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another `GetLifecyclePolicyPreviewRequest` request with the
#' returned `nextToken` value. This value can be between 1 and 1000. If
#' this parameter is not used, then `GetLifecyclePolicyPreviewRequest`
#' returns up to 100 results and a `nextToken` value, if applicable. This
#' option cannot be used when you specify images with `imageIds`.
#' @param filter An optional parameter that filters results based on image tag status and
#' all tags, if tagged.
#'
#' @keywords internal
#'
#' @rdname ecr_get_lifecycle_policy_preview
ecr_get_lifecycle_policy_preview <- function(registryId = NULL, repositoryName, imageIds = NULL, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "GetLifecyclePolicyPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_lifecycle_policy_preview_input(registryId = registryId, repositoryName = repositoryName, imageIds = imageIds, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .ecr$get_lifecycle_policy_preview_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_lifecycle_policy_preview <- ecr_get_lifecycle_policy_preview

#' Retrieves the permissions policy for a registry
#'
#' @description
#' Retrieves the permissions policy for a registry.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_get_registry_policy/](https://www.paws-r-sdk.com/docs/ecr_get_registry_policy/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ecr_get_registry_policy
ecr_get_registry_policy <- function() {
  op <- new_operation(
    name = "GetRegistryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_registry_policy_input()
  output <- .ecr$get_registry_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_registry_policy <- ecr_get_registry_policy

#' Retrieves the scanning configuration for a registry
#'
#' @description
#' Retrieves the scanning configuration for a registry.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_get_registry_scanning_configuration/](https://www.paws-r-sdk.com/docs/ecr_get_registry_scanning_configuration/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname ecr_get_registry_scanning_configuration
ecr_get_registry_scanning_configuration <- function() {
  op <- new_operation(
    name = "GetRegistryScanningConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_registry_scanning_configuration_input()
  output <- .ecr$get_registry_scanning_configuration_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_registry_scanning_configuration <- ecr_get_registry_scanning_configuration

#' Retrieves the repository policy for the specified repository
#'
#' @description
#' Retrieves the repository policy for the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_get_repository_policy/](https://www.paws-r-sdk.com/docs/ecr_get_repository_policy/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository with the policy to retrieve.
#'
#' @keywords internal
#'
#' @rdname ecr_get_repository_policy
ecr_get_repository_policy <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "GetRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$get_repository_policy_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$get_repository_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$get_repository_policy <- ecr_get_repository_policy

#' Notifies Amazon ECR that you intend to upload an image layer
#'
#' @description
#' Notifies Amazon ECR that you intend to upload an image layer.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_initiate_layer_upload/](https://www.paws-r-sdk.com/docs/ecr_initiate_layer_upload/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry to which
#' you intend to upload layers. If you do not specify a registry, the
#' default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to which you intend to upload layers.
#'
#' @keywords internal
#'
#' @rdname ecr_initiate_layer_upload
ecr_initiate_layer_upload <- function(registryId = NULL, repositoryName) {
  op <- new_operation(
    name = "InitiateLayerUpload",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$initiate_layer_upload_input(registryId = registryId, repositoryName = repositoryName)
  output <- .ecr$initiate_layer_upload_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$initiate_layer_upload <- ecr_initiate_layer_upload

#' Lists all the image IDs for the specified repository
#'
#' @description
#' Lists all the image IDs for the specified repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_list_images/](https://www.paws-r-sdk.com/docs/ecr_list_images/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository in which to list images. If you do not specify a
#' registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The repository with image IDs to be listed.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' [`list_images`][ecr_list_images] request where `maxResults` was used and
#' the results exceeded the value of that parameter. Pagination continues
#' from the end of the previous results that returned the `nextToken`
#' value. This value is `null` when there are no more results to return.
#' 
#' This token should be treated as an opaque identifier that is only used
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param maxResults The maximum number of image results returned by
#' [`list_images`][ecr_list_images] in paginated output. When this
#' parameter is used, [`list_images`][ecr_list_images] only returns
#' `maxResults` results in a single page along with a `nextToken` response
#' element. The remaining results of the initial request can be seen by
#' sending another [`list_images`][ecr_list_images] request with the
#' returned `nextToken` value. This value can be between 1 and 1000. If
#' this parameter is not used, then [`list_images`][ecr_list_images]
#' returns up to 100 results and a `nextToken` value, if applicable.
#' @param filter The filter key and value with which to filter your
#' [`list_images`][ecr_list_images] results.
#'
#' @keywords internal
#'
#' @rdname ecr_list_images
ecr_list_images <- function(registryId = NULL, repositoryName, nextToken = NULL, maxResults = NULL, filter = NULL) {
  op <- new_operation(
    name = "ListImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$list_images_input(registryId = registryId, repositoryName = repositoryName, nextToken = nextToken, maxResults = maxResults, filter = filter)
  output <- .ecr$list_images_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$list_images <- ecr_list_images

#' List the tags for an Amazon ECR resource
#'
#' @description
#' List the tags for an Amazon ECR resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/ecr_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the only supported resource is an Amazon ECR
#' repository.
#'
#' @keywords internal
#'
#' @rdname ecr_list_tags_for_resource
ecr_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ecr$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$list_tags_for_resource <- ecr_list_tags_for_resource

#' Creates or updates the image manifest and tags associated with an image
#'
#' @description
#' Creates or updates the image manifest and tags associated with an image.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_put_image/](https://www.paws-r-sdk.com/docs/ecr_put_image/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository in which to put the image. If you do not specify
#' a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in which to put the image.
#' @param imageManifest &#91;required&#93; The image manifest corresponding to the image to be uploaded.
#' @param imageManifestMediaType The media type of the image manifest. If you push an image manifest that
#' does not contain the `mediaType` field, you must specify the
#' `imageManifestMediaType` in the request.
#' @param imageTag The tag to associate with the image. This parameter is required for
#' images that use the Docker Image Manifest V2 Schema 2 or Open Container
#' Initiative (OCI) formats.
#' @param imageDigest The image digest of the image manifest corresponding to the image.
#'
#' @keywords internal
#'
#' @rdname ecr_put_image
ecr_put_image <- function(registryId = NULL, repositoryName, imageManifest, imageManifestMediaType = NULL, imageTag = NULL, imageDigest = NULL) {
  op <- new_operation(
    name = "PutImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_image_input(registryId = registryId, repositoryName = repositoryName, imageManifest = imageManifest, imageManifestMediaType = imageManifestMediaType, imageTag = imageTag, imageDigest = imageDigest)
  output <- .ecr$put_image_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_image <- ecr_put_image

#' The PutImageScanningConfiguration API is being deprecated, in favor of
#' specifying the image scanning configuration at the registry level
#'
#' @description
#' The [`put_image_scanning_configuration`][ecr_put_image_scanning_configuration] API is being deprecated, in favor of specifying the image scanning configuration at the registry level. For more information, see [`put_registry_scanning_configuration`][ecr_put_registry_scanning_configuration].
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_put_image_scanning_configuration/](https://www.paws-r-sdk.com/docs/ecr_put_image_scanning_configuration/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository in which to update the image scanning
#' configuration setting. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in which to update the image scanning
#' configuration setting.
#' @param imageScanningConfiguration &#91;required&#93; The image scanning configuration for the repository. This setting
#' determines whether images are scanned for known vulnerabilities after
#' being pushed to the repository.
#'
#' @keywords internal
#'
#' @rdname ecr_put_image_scanning_configuration
ecr_put_image_scanning_configuration <- function(registryId = NULL, repositoryName, imageScanningConfiguration) {
  op <- new_operation(
    name = "PutImageScanningConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_image_scanning_configuration_input(registryId = registryId, repositoryName = repositoryName, imageScanningConfiguration = imageScanningConfiguration)
  output <- .ecr$put_image_scanning_configuration_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_image_scanning_configuration <- ecr_put_image_scanning_configuration

#' Updates the image tag mutability settings for the specified repository
#'
#' @description
#' Updates the image tag mutability settings for the specified repository. For more information, see [Image tag mutability](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-tag-mutability.html) in the *Amazon Elastic Container Registry User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_put_image_tag_mutability/](https://www.paws-r-sdk.com/docs/ecr_put_image_tag_mutability/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository in which to update the image tag mutability
#' settings. If you do not specify a registry, the default registry is
#' assumed.
#' @param repositoryName &#91;required&#93; The name of the repository in which to update the image tag mutability
#' settings.
#' @param imageTagMutability &#91;required&#93; The tag mutability setting for the repository. If `MUTABLE` is
#' specified, image tags can be overwritten. If `IMMUTABLE` is specified,
#' all image tags within the repository will be immutable which will
#' prevent them from being overwritten.
#'
#' @keywords internal
#'
#' @rdname ecr_put_image_tag_mutability
ecr_put_image_tag_mutability <- function(registryId = NULL, repositoryName, imageTagMutability) {
  op <- new_operation(
    name = "PutImageTagMutability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_image_tag_mutability_input(registryId = registryId, repositoryName = repositoryName, imageTagMutability = imageTagMutability)
  output <- .ecr$put_image_tag_mutability_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_image_tag_mutability <- ecr_put_image_tag_mutability

#' Creates or updates the lifecycle policy for the specified repository
#'
#' @description
#' Creates or updates the lifecycle policy for the specified repository. For more information, see [Lifecycle policy template](https://docs.aws.amazon.com/AmazonECR/latest/userguide/LifecyclePolicies.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_put_lifecycle_policy/](https://www.paws-r-sdk.com/docs/ecr_put_lifecycle_policy/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to receive the policy.
#' @param lifecyclePolicyText &#91;required&#93; The JSON repository policy text to apply to the repository.
#'
#' @keywords internal
#'
#' @rdname ecr_put_lifecycle_policy
ecr_put_lifecycle_policy <- function(registryId = NULL, repositoryName, lifecyclePolicyText) {
  op <- new_operation(
    name = "PutLifecyclePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_lifecycle_policy_input(registryId = registryId, repositoryName = repositoryName, lifecyclePolicyText = lifecyclePolicyText)
  output <- .ecr$put_lifecycle_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_lifecycle_policy <- ecr_put_lifecycle_policy

#' Creates or updates the permissions policy for your registry
#'
#' @description
#' Creates or updates the permissions policy for your registry.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_put_registry_policy/](https://www.paws-r-sdk.com/docs/ecr_put_registry_policy/) for full documentation.
#'
#' @param policyText &#91;required&#93; The JSON policy text to apply to your registry. The policy text follows
#' the same format as IAM policy text. For more information, see [Registry
#' permissions](https://docs.aws.amazon.com/AmazonECR/latest/userguide/registry-permissions.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#'
#' @keywords internal
#'
#' @rdname ecr_put_registry_policy
ecr_put_registry_policy <- function(policyText) {
  op <- new_operation(
    name = "PutRegistryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_registry_policy_input(policyText = policyText)
  output <- .ecr$put_registry_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_registry_policy <- ecr_put_registry_policy

#' Creates or updates the scanning configuration for your private registry
#'
#' @description
#' Creates or updates the scanning configuration for your private registry.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_put_registry_scanning_configuration/](https://www.paws-r-sdk.com/docs/ecr_put_registry_scanning_configuration/) for full documentation.
#'
#' @param scanType The scanning type to set for the registry.
#' 
#' When a registry scanning configuration is not defined, by default the
#' `BASIC` scan type is used. When basic scanning is used, you may specify
#' filters to determine which individual repositories, or all repositories,
#' are scanned when new images are pushed to those repositories.
#' Alternatively, you can do manual scans of images with basic scanning.
#' 
#' When the `ENHANCED` scan type is set, Amazon Inspector provides
#' automated vulnerability scanning. You may choose between continuous
#' scanning or scan on push and you may specify filters to determine which
#' individual repositories, or all repositories, are scanned.
#' @param rules The scanning rules to use for the registry. A scanning rule is used to
#' determine which repository filters are used and at what frequency
#' scanning will occur.
#'
#' @keywords internal
#'
#' @rdname ecr_put_registry_scanning_configuration
ecr_put_registry_scanning_configuration <- function(scanType = NULL, rules = NULL) {
  op <- new_operation(
    name = "PutRegistryScanningConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_registry_scanning_configuration_input(scanType = scanType, rules = rules)
  output <- .ecr$put_registry_scanning_configuration_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_registry_scanning_configuration <- ecr_put_registry_scanning_configuration

#' Creates or updates the replication configuration for a registry
#'
#' @description
#' Creates or updates the replication configuration for a registry. The existing replication configuration for a repository can be retrieved with the [`describe_registry`][ecr_describe_registry] API action. The first time the PutReplicationConfiguration API is called, a service-linked IAM role is created in your account for the replication process. For more information, see [Using service-linked roles for Amazon ECR](https://docs.aws.amazon.com/AmazonECR/latest/userguide/using-service-linked-roles.html) in the *Amazon Elastic Container Registry User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_put_replication_configuration/](https://www.paws-r-sdk.com/docs/ecr_put_replication_configuration/) for full documentation.
#'
#' @param replicationConfiguration &#91;required&#93; An object representing the replication configuration for a registry.
#'
#' @keywords internal
#'
#' @rdname ecr_put_replication_configuration
ecr_put_replication_configuration <- function(replicationConfiguration) {
  op <- new_operation(
    name = "PutReplicationConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$put_replication_configuration_input(replicationConfiguration = replicationConfiguration)
  output <- .ecr$put_replication_configuration_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$put_replication_configuration <- ecr_put_replication_configuration

#' Applies a repository policy to the specified repository to control
#' access permissions
#'
#' @description
#' Applies a repository policy to the specified repository to control access permissions. For more information, see [Amazon ECR Repository policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policies.html) in the *Amazon Elastic Container Registry User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_set_repository_policy/](https://www.paws-r-sdk.com/docs/ecr_set_repository_policy/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to receive the policy.
#' @param policyText &#91;required&#93; The JSON repository policy text to apply to the repository. For more
#' information, see [Amazon ECR repository
#' policies](https://docs.aws.amazon.com/AmazonECR/latest/userguide/repository-policy-examples.html)
#' in the *Amazon Elastic Container Registry User Guide*.
#' @param force If the policy you are attempting to set on a repository policy would
#' prevent you from setting another policy in the future, you must force
#' the [`set_repository_policy`][ecr_set_repository_policy] operation. This
#' is intended to prevent accidental repository lock outs.
#'
#' @keywords internal
#'
#' @rdname ecr_set_repository_policy
ecr_set_repository_policy <- function(registryId = NULL, repositoryName, policyText, force = NULL) {
  op <- new_operation(
    name = "SetRepositoryPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$set_repository_policy_input(registryId = registryId, repositoryName = repositoryName, policyText = policyText, force = force)
  output <- .ecr$set_repository_policy_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$set_repository_policy <- ecr_set_repository_policy

#' Starts an image vulnerability scan
#'
#' @description
#' Starts an image vulnerability scan. An image scan can only be started once per 24 hours on an individual image. This limit includes if an image was scanned on initial push. For more information, see [Image scanning](https://docs.aws.amazon.com/AmazonECR/latest/userguide/image-scanning.html) in the *Amazon Elastic Container Registry User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_start_image_scan/](https://www.paws-r-sdk.com/docs/ecr_start_image_scan/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository in which to start an image scan request. If you
#' do not specify a registry, the default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository that contains the images to scan.
#' @param imageId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname ecr_start_image_scan
ecr_start_image_scan <- function(registryId = NULL, repositoryName, imageId) {
  op <- new_operation(
    name = "StartImageScan",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$start_image_scan_input(registryId = registryId, repositoryName = repositoryName, imageId = imageId)
  output <- .ecr$start_image_scan_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$start_image_scan <- ecr_start_image_scan

#' Starts a preview of a lifecycle policy for the specified repository
#'
#' @description
#' Starts a preview of a lifecycle policy for the specified repository. This allows you to see the results before associating the lifecycle policy with the repository.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_start_lifecycle_policy_preview/](https://www.paws-r-sdk.com/docs/ecr_start_lifecycle_policy_preview/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry that
#' contains the repository. If you do not specify a registry, the default
#' registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to be evaluated.
#' @param lifecyclePolicyText The policy to be evaluated against. If you do not specify a policy, the
#' current policy for the repository is used.
#'
#' @keywords internal
#'
#' @rdname ecr_start_lifecycle_policy_preview
ecr_start_lifecycle_policy_preview <- function(registryId = NULL, repositoryName, lifecyclePolicyText = NULL) {
  op <- new_operation(
    name = "StartLifecyclePolicyPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$start_lifecycle_policy_preview_input(registryId = registryId, repositoryName = repositoryName, lifecyclePolicyText = lifecyclePolicyText)
  output <- .ecr$start_lifecycle_policy_preview_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$start_lifecycle_policy_preview <- ecr_start_lifecycle_policy_preview

#' Adds specified tags to a resource with the specified ARN
#'
#' @description
#' Adds specified tags to a resource with the specified ARN. Existing tags on a resource are not changed if they are not specified in the request parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_tag_resource/](https://www.paws-r-sdk.com/docs/ecr_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the the resource to which to add tags.
#' Currently, the only supported resource is an Amazon ECR repository.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#' Tag keys can have a maximum character length of 128 characters, and tag
#' values can have a maximum length of 256 characters.
#'
#' @keywords internal
#'
#' @rdname ecr_tag_resource
ecr_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ecr$tag_resource_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$tag_resource <- ecr_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_untag_resource/](https://www.paws-r-sdk.com/docs/ecr_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to remove
#' tags. Currently, the only supported resource is an Amazon ECR
#' repository.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname ecr_untag_resource
ecr_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ecr$untag_resource_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$untag_resource <- ecr_untag_resource

#' Uploads an image layer part to Amazon ECR
#'
#' @description
#' Uploads an image layer part to Amazon ECR.
#'
#' See [https://www.paws-r-sdk.com/docs/ecr_upload_layer_part/](https://www.paws-r-sdk.com/docs/ecr_upload_layer_part/) for full documentation.
#'
#' @param registryId The Amazon Web Services account ID associated with the registry to which
#' you are uploading layer parts. If you do not specify a registry, the
#' default registry is assumed.
#' @param repositoryName &#91;required&#93; The name of the repository to which you are uploading layer parts.
#' @param uploadId &#91;required&#93; The upload ID from a previous
#' [`initiate_layer_upload`][ecr_initiate_layer_upload] operation to
#' associate with the layer part upload.
#' @param partFirstByte &#91;required&#93; The position of the first byte of the layer part witin the overall image
#' layer.
#' @param partLastByte &#91;required&#93; The position of the last byte of the layer part within the overall image
#' layer.
#' @param layerPartBlob &#91;required&#93; The base64-encoded layer part payload.
#'
#' @keywords internal
#'
#' @rdname ecr_upload_layer_part
ecr_upload_layer_part <- function(registryId = NULL, repositoryName, uploadId, partFirstByte, partLastByte, layerPartBlob) {
  op <- new_operation(
    name = "UploadLayerPart",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ecr$upload_layer_part_input(registryId = registryId, repositoryName = repositoryName, uploadId = uploadId, partFirstByte = partFirstByte, partLastByte = partLastByte, layerPartBlob = layerPartBlob)
  output <- .ecr$upload_layer_part_output()
  config <- get_config()
  svc <- .ecr$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ecr$operations$upload_layer_part <- ecr_upload_layer_part
