% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_delete_service_template_version}
\alias{proton_delete_service_template_version}
\title{If no other minor versions of a service template exist, delete a major
version of the service template if it's not the Recommended version}
\usage{
proton_delete_service_template_version(
  majorVersion,
  minorVersion,
  templateName
)
}
\arguments{
\item{majorVersion}{[required] The service template major version to delete.}

\item{minorVersion}{[required] The service template minor version to delete.}

\item{templateName}{[required] The name of the service template.}
}
\description{
If no other minor versions of a service template exist, delete a major version of the service template if it's not the \code{Recommended} version. Delete the \code{Recommended} version of the service template if no other major versions or minor versions of the service template exist. A major version of a service template is a version that \emph{isn't} backwards compatible.

See \url{https://paws-r.github.io/docs/proton/delete_service_template_version.html} for full documentation.
}
\keyword{internal}
