% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_event_source_mapping}
\alias{lambda_update_event_source_mapping}
\title{Updates an event source mapping}
\usage{
lambda_update_event_source_mapping(
  UUID,
  FunctionName = NULL,
  Enabled = NULL,
  BatchSize = NULL,
  FilterCriteria = NULL,
  MaximumBatchingWindowInSeconds = NULL,
  DestinationConfig = NULL,
  MaximumRecordAgeInSeconds = NULL,
  BisectBatchOnFunctionError = NULL,
  MaximumRetryAttempts = NULL,
  ParallelizationFactor = NULL,
  SourceAccessConfigurations = NULL,
  TumblingWindowInSeconds = NULL,
  FunctionResponseTypes = NULL
)
}
\arguments{
\item{UUID}{[required] The identifier of the event source mapping.}

\item{FunctionName}{The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Enabled}{When true, the event source mapping is active. When false, Lambda pauses
polling and invocation.

Default: True}

\item{BatchSize}{The maximum number of records in each batch that Lambda pulls from your
stream or queue and sends to your function. Lambda passes all of the
records in the batch to the function in a single call, up to the payload
limit for synchronous invocation (6 MB).
\itemize{
\item \strong{Amazon Kinesis} - Default 100. Max 10,000.
\item \strong{Amazon DynamoDB Streams} - Default 100. Max 10,000.
\item \strong{Amazon Simple Queue Service} - Default 10. For standard queues
the max is 10,000. For FIFO queues the max is 10.
\item \strong{Amazon Managed Streaming for Apache Kafka} - Default 100. Max
10,000.
\item \strong{Self-Managed Apache Kafka} - Default 100. Max 10,000.
\item \strong{Amazon MQ (ActiveMQ and RabbitMQ)} - Default 100. Max 10,000.
}}

\item{FilterCriteria}{(Streams and Amazon SQS) An object that defines the filter criteria that
determine whether Lambda should process an event. For more information,
see \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html}{Lambda event filtering}.}

\item{MaximumBatchingWindowInSeconds}{(Streams and Amazon SQS standard queues) The maximum amount of time, in
seconds, that Lambda spends gathering records before invoking the
function.

Default: 0

Related setting: When you set \code{BatchSize} to a value greater than 10,
you must set \code{MaximumBatchingWindowInSeconds} to at least 1.}

\item{DestinationConfig}{(Streams only) An Amazon SQS queue or Amazon SNS topic destination for
discarded records.}

\item{MaximumRecordAgeInSeconds}{(Streams only) Discard records older than the specified age. The default
value is infinite (-1).}

\item{BisectBatchOnFunctionError}{(Streams only) If the function returns an error, split the batch in two
and retry.}

\item{MaximumRetryAttempts}{(Streams only) Discard records after the specified number of retries.
The default value is infinite (-1). When set to infinite (-1), failed
records will be retried until the record expires.}

\item{ParallelizationFactor}{(Streams only) The number of batches to process from each shard
concurrently.}

\item{SourceAccessConfigurations}{An array of authentication protocols or VPC components required to
secure your event source.}

\item{TumblingWindowInSeconds}{(Streams only) The duration in seconds of a processing window. The range
is between 1 second up to 900 seconds.}

\item{FunctionResponseTypes}{(Streams and Amazon SQS) A list of current response type enums applied
to the event source mapping.}
}
\description{
Updates an event source mapping. You can change the function that Lambda invokes, or pause invocation and resume later from the same location.

See \url{https://paws-r.github.io/docs/lambda/update_event_source_mapping.html} for full documentation.
}
\keyword{internal}
