% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_internet_gateway}
\alias{ec2_create_internet_gateway}
\title{Creates an internet gateway for use with a VPC}
\usage{
ec2_create_internet_gateway(DryRun)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates an internet gateway for use with a VPC. After creating the
internet gateway, you attach it to a VPC using AttachInternetGateway.
}
\details{
For more information about your VPC and internet gateway, see the
\href{https://docs.aws.amazon.com/vpc/latest/userguide/}{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_internet_gateway(
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example creates an Internet gateway.
\dontrun{svc$create_internet_gateway()}

}
\keyword{internal}
