% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_event_source_mapping}
\alias{lambda_update_event_source_mapping}
\title{Updates an event source mapping}
\usage{
lambda_update_event_source_mapping(UUID, FunctionName, Enabled,
  BatchSize)
}
\arguments{
\item{UUID}{[required] The identifier of the event source mapping.}

\item{FunctionName}{The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\code{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} -
\code{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} - \code{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Enabled}{Disables the event source mapping to pause polling and invocation.}

\item{BatchSize}{The maximum number of items to retrieve in a single batch.
\itemize{
\item \strong{Amazon Kinesis} - Default 100. Max 10,000.
\item \strong{Amazon DynamoDB Streams} - Default 100. Max 1,000.
\item \strong{Amazon Simple Queue Service} - Default 10. Max 10.
}}
}
\description{
Updates an event source mapping. You can change the function that AWS
Lambda invokes, or pause invocation and resume later from the same
location.
}
\section{Request syntax}{
\preformatted{svc$update_event_source_mapping(
  UUID = "string",
  FunctionName = "string",
  Enabled = TRUE|FALSE,
  BatchSize = 123
)
}
}

\examples{
# This operation updates a Lambda function event source mapping
\donttest{svc$update_event_source_mapping(
  BatchSize = 123L,
  Enabled = TRUE,
  FunctionName = "myFunction",
  UUID = "1234xCy789012"
)}

}
\keyword{internal}
