% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_key_pair}
\alias{ec2_create_key_pair}
\title{Creates a 2048-bit RSA key pair with the specified name}
\usage{
ec2_create_key_pair(KeyName, DryRun, TagSpecifications)
}
\arguments{
\item{KeyName}{[required] A unique name for the key pair.

Constraints: Up to 255 ASCII characters}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to apply to the new key pair.}
}
\value{
A list with the following syntax:\preformatted{list(
  KeyFingerprint = "string",
  KeyMaterial = "string",
  KeyName = "string",
  KeyPairId = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Creates a 2048-bit RSA key pair with the specified name. Amazon EC2
stores the public key and displays the private key for you to save to a
file. The private key is returned as an unencrypted PEM encoded PKCS#1
private key. If a key with the specified name already exists, Amazon EC2
returns an error.

You can have up to five thousand key pairs per Region.

The key pair returned to you is available only in the Region in which
you create it. If you prefer, you can create your own key pair using a
third-party tool and upload it to any Region using
\code{\link[=ec2_import_key_pair]{import_key_pair}}.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html}{Key Pairs}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_key_pair(
  KeyName = "string",
  DryRun = TRUE|FALSE,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\examples{
\dontrun{
# This example creates a key pair named my-key-pair.
svc$create_key_pair(
  KeyName = "my-key-pair"
)
}

}
\keyword{internal}
