# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lightsail_service.R
NULL

#' Allocates a static IP address
#'
#' @description
#' Allocates a static IP address.
#'
#' @usage
#' lightsail_allocate_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP address.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$allocate_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_allocate_static_ip
lightsail_allocate_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "AllocateStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$allocate_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$allocate_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$allocate_static_ip <- lightsail_allocate_static_ip

#' Attaches an SSL/TLS certificate to your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Attaches an SSL/TLS certificate to your Amazon Lightsail content
#' delivery network (CDN) distribution.
#' 
#' After the certificate is attached, your distribution accepts HTTPS
#' traffic for all of the domains that are associated with the certificate.
#' 
#' Use the [`create_certificate`][lightsail_create_certificate] action to
#' create a certificate that you can attach to your distribution.
#' 
#' Only certificates created in the `us-east-1` AWS Region can be attached
#' to Lightsail distributions. Lightsail distributions are global resources
#' that can reference an origin in any AWS Region, and distribute its
#' content globally. However, all distributions are located in the
#' `us-east-1` Region.
#'
#' @usage
#' lightsail_attach_certificate_to_distribution(distributionName,
#'   certificateName)
#'
#' @param distributionName &#91;required&#93; The name of the distribution that the certificate will be attached to.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param certificateName &#91;required&#93; The name of the certificate to attach to a distribution.
#' 
#' Only certificates with a status of `ISSUED` can be attached to a
#' distribution.
#' 
#' Use the [`get_certificates`][lightsail_get_certificates] action to get a
#' list of certificate names that you can specify.
#' 
#' This is the name of the certificate resource type and is used only to
#' reference the certificate in other API actions. It can be different than
#' the domain name of the certificate. For example, your certificate name
#' might be `WordPress-Blog-Certificate` and the domain name of the
#' certificate might be `example.com`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_certificate_to_distribution(
#'   distributionName = "string",
#'   certificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_certificate_to_distribution
lightsail_attach_certificate_to_distribution <- function(distributionName, certificateName) {
  op <- new_operation(
    name = "AttachCertificateToDistribution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_certificate_to_distribution_input(distributionName = distributionName, certificateName = certificateName)
  output <- .lightsail$attach_certificate_to_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_certificate_to_distribution <- lightsail_attach_certificate_to_distribution

#' Attaches a block storage disk to a running or stopped Lightsail instance
#' and exposes it to the instance with the specified disk name
#'
#' @description
#' Attaches a block storage disk to a running or stopped Lightsail instance
#' and exposes it to the instance with the specified disk name.
#' 
#' The `attach disk` operation supports tag-based access control via
#' resource tags applied to the resource identified by `disk name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_attach_disk(diskName, instanceName, diskPath)
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (e.g., `my-disk`).
#' @param instanceName &#91;required&#93; The name of the Lightsail instance where you want to utilize the storage
#' disk.
#' @param diskPath &#91;required&#93; The disk path to expose to the instance (e.g., `/dev/xvdf`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_disk(
#'   diskName = "string",
#'   instanceName = "string",
#'   diskPath = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_disk
lightsail_attach_disk <- function(diskName, instanceName, diskPath) {
  op <- new_operation(
    name = "AttachDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_disk_input(diskName = diskName, instanceName = instanceName, diskPath = diskPath)
  output <- .lightsail$attach_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_disk <- lightsail_attach_disk

#' Attaches one or more Lightsail instances to a load balancer
#'
#' @description
#' Attaches one or more Lightsail instances to a load balancer.
#' 
#' After some time, the instances are attached to the load balancer and the
#' health check status is available.
#' 
#' The `attach instances to load balancer` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' `load balancer name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_attach_instances_to_load_balancer(loadBalancerName,
#'   instanceNames)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#' @param instanceNames &#91;required&#93; An array of strings representing the instance name(s) you want to attach
#' to your load balancer.
#' 
#' An instance must be `running` before you can attach it to your load
#' balancer.
#' 
#' There are no additional limits on the number of instances you can attach
#' to your load balancer, aside from the limit of Lightsail instances you
#' can create in your account (20).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_instances_to_load_balancer(
#'   loadBalancerName = "string",
#'   instanceNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_instances_to_load_balancer
lightsail_attach_instances_to_load_balancer <- function(loadBalancerName, instanceNames) {
  op <- new_operation(
    name = "AttachInstancesToLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_instances_to_load_balancer_input(loadBalancerName = loadBalancerName, instanceNames = instanceNames)
  output <- .lightsail$attach_instances_to_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_instances_to_load_balancer <- lightsail_attach_instances_to_load_balancer

#' Attaches a Transport Layer Security (TLS) certificate to your load
#' balancer
#'
#' @description
#' Attaches a Transport Layer Security (TLS) certificate to your load
#' balancer. TLS is just an updated, more secure version of Secure Socket
#' Layer (SSL).
#' 
#' Once you create and validate your certificate, you can attach it to your
#' load balancer. You can also use this API to rotate the certificates on
#' your account. Use the
#' [`attach_load_balancer_tls_certificate`][lightsail_attach_load_balancer_tls_certificate]
#' action with the non-attached certificate, and it will replace the
#' existing one and become the attached certificate.
#' 
#' The
#' [`attach_load_balancer_tls_certificate`][lightsail_attach_load_balancer_tls_certificate]
#' operation supports tag-based access control via resource tags applied to
#' the resource identified by `load balancer name`. For more information,
#' see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_attach_load_balancer_tls_certificate(loadBalancerName,
#'   certificateName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer to which you want to associate the SSL/TLS
#' certificate.
#' @param certificateName &#91;required&#93; The name of your SSL/TLS certificate.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_load_balancer_tls_certificate(
#'   loadBalancerName = "string",
#'   certificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_load_balancer_tls_certificate
lightsail_attach_load_balancer_tls_certificate <- function(loadBalancerName, certificateName) {
  op <- new_operation(
    name = "AttachLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName)
  output <- .lightsail$attach_load_balancer_tls_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_load_balancer_tls_certificate <- lightsail_attach_load_balancer_tls_certificate

#' Attaches a static IP address to a specific Amazon Lightsail instance
#'
#' @description
#' Attaches a static IP address to a specific Amazon Lightsail instance.
#'
#' @usage
#' lightsail_attach_static_ip(staticIpName, instanceName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP.
#' @param instanceName &#91;required&#93; The instance name to which you want to attach the static IP address.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$attach_static_ip(
#'   staticIpName = "string",
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_attach_static_ip
lightsail_attach_static_ip <- function(staticIpName, instanceName) {
  op <- new_operation(
    name = "AttachStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$attach_static_ip_input(staticIpName = staticIpName, instanceName = instanceName)
  output <- .lightsail$attach_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$attach_static_ip <- lightsail_attach_static_ip

#' Closes ports for a specific Amazon Lightsail instance
#'
#' @description
#' Closes ports for a specific Amazon Lightsail instance.
#' 
#' The
#' [`close_instance_public_ports`][lightsail_close_instance_public_ports]
#' action supports tag-based access control via resource tags applied to
#' the resource identified by `instanceName`. For more information, see the
#' Lightsail Dev Guide.
#'
#' @usage
#' lightsail_close_instance_public_ports(portInfo, instanceName)
#'
#' @param portInfo &#91;required&#93; An object to describe the ports to close for the specified instance.
#' @param instanceName &#91;required&#93; The name of the instance for which to close ports.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$close_instance_public_ports(
#'   portInfo = list(
#'     fromPort = 123,
#'     toPort = 123,
#'     protocol = "tcp"|"all"|"udp"|"icmp",
#'     cidrs = list(
#'       "string"
#'     ),
#'     cidrListAliases = list(
#'       "string"
#'     )
#'   ),
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_close_instance_public_ports
lightsail_close_instance_public_ports <- function(portInfo, instanceName) {
  op <- new_operation(
    name = "CloseInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$close_instance_public_ports_input(portInfo = portInfo, instanceName = instanceName)
  output <- .lightsail$close_instance_public_ports_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$close_instance_public_ports <- lightsail_close_instance_public_ports

#' Copies a manual snapshot of an instance or disk as another manual
#' snapshot, or copies an automatic snapshot of an instance or disk as a
#' manual snapshot
#'
#' @description
#' Copies a manual snapshot of an instance or disk as another manual
#' snapshot, or copies an automatic snapshot of an instance or disk as a
#' manual snapshot. This operation can also be used to copy a manual or
#' automatic snapshot of an instance or a disk from one AWS Region to
#' another in Amazon Lightsail.
#' 
#' When copying a *manual snapshot*, be sure to define the `source region`,
#' `source snapshot name`, and `target snapshot name` parameters.
#' 
#' When copying an *automatic snapshot*, be sure to define the
#' `source region`, `source resource name`, `target snapshot name`, and
#' either the `restore date` or the `use latest restorable auto snapshot`
#' parameters.
#'
#' @usage
#' lightsail_copy_snapshot(sourceSnapshotName, sourceResourceName,
#'   restoreDate, useLatestRestorableAutoSnapshot, targetSnapshotName,
#'   sourceRegion)
#'
#' @param sourceSnapshotName The name of the source manual snapshot to copy.
#' 
#' Constraint:
#' 
#' -   Define this parameter only when copying a manual snapshot as another
#'     manual snapshot.
#' @param sourceResourceName The name of the source instance or disk from which the source automatic
#' snapshot was created.
#' 
#' Constraint:
#' 
#' -   Define this parameter only when copying an automatic snapshot as a
#'     manual snapshot. For more information, see the Lightsail Dev Guide.
#' @param restoreDate The date of the source automatic snapshot to copy. Use the
#' `get auto snapshots` operation to identify the dates of the available
#' automatic snapshots.
#' 
#' Constraints:
#' 
#' -   Must be specified in `YYYY-MM-DD` format.
#' 
#' -   This parameter cannot be defined together with the
#'     `use latest restorable auto snapshot` parameter. The `restore date`
#'     and `use latest restorable auto snapshot` parameters are mutually
#'     exclusive.
#' 
#' -   Define this parameter only when copying an automatic snapshot as a
#'     manual snapshot. For more information, see the Lightsail Dev Guide.
#' @param useLatestRestorableAutoSnapshot A Boolean value to indicate whether to use the latest available
#' automatic snapshot of the specified source instance or disk.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the `restore date`
#'     parameter. The `use latest restorable auto snapshot` and
#'     `restore date` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when copying an automatic snapshot as a
#'     manual snapshot. For more information, see the Lightsail Dev Guide.
#' @param targetSnapshotName &#91;required&#93; The name of the new manual snapshot to be created as a copy.
#' @param sourceRegion &#91;required&#93; The AWS Region where the source manual or automatic snapshot is located.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$copy_snapshot(
#'   sourceSnapshotName = "string",
#'   sourceResourceName = "string",
#'   restoreDate = "string",
#'   useLatestRestorableAutoSnapshot = TRUE|FALSE,
#'   targetSnapshotName = "string",
#'   sourceRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_copy_snapshot
lightsail_copy_snapshot <- function(sourceSnapshotName = NULL, sourceResourceName = NULL, restoreDate = NULL, useLatestRestorableAutoSnapshot = NULL, targetSnapshotName, sourceRegion) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$copy_snapshot_input(sourceSnapshotName = sourceSnapshotName, sourceResourceName = sourceResourceName, restoreDate = restoreDate, useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot, targetSnapshotName = targetSnapshotName, sourceRegion = sourceRegion)
  output <- .lightsail$copy_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$copy_snapshot <- lightsail_copy_snapshot

#' Creates an SSL/TLS certificate for a Amazon Lightsail content delivery
#' network (CDN) distribution
#'
#' @description
#' Creates an SSL/TLS certificate for a Amazon Lightsail content delivery
#' network (CDN) distribution.
#' 
#' After the certificate is created, use the
#' [`attach_certificate_to_distribution`][lightsail_attach_certificate_to_distribution]
#' action to attach the certificate to your distribution.
#' 
#' Only certificates created in the `us-east-1` AWS Region can be attached
#' to Lightsail distributions. Lightsail distributions are global resources
#' that can reference an origin in any AWS Region, and distribute its
#' content globally. However, all distributions are located in the
#' `us-east-1` Region.
#'
#' @usage
#' lightsail_create_certificate(certificateName, domainName,
#'   subjectAlternativeNames, tags)
#'
#' @param certificateName &#91;required&#93; The name for the certificate.
#' @param domainName &#91;required&#93; The domain name (e.g., `example.com`) for the certificate.
#' @param subjectAlternativeNames An array of strings that specify the alternate domains (e.g.,
#' `example2.com`) and subdomains (e.g., `blog.example.com`) for the
#' certificate.
#' 
#' You can specify a maximum of nine alternate domains (in addition to the
#' primary domain name).
#' 
#' Wildcard domain entries (e.g., `*.example.com`) are not supported.
#' @param tags The tag keys and optional values to add to the certificate during
#' create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   certificate = list(
#'     certificateArn = "string",
#'     certificateName = "string",
#'     domainName = "string",
#'     certificateDetail = list(
#'       arn = "string",
#'       name = "string",
#'       domainName = "string",
#'       status = "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED",
#'       serialNumber = "string",
#'       subjectAlternativeNames = list(
#'         "string"
#'       ),
#'       domainValidationRecords = list(
#'         list(
#'           domainName = "string",
#'           resourceRecord = list(
#'             name = "string",
#'             type = "string",
#'             value = "string"
#'           )
#'         )
#'       ),
#'       requestFailureReason = "string",
#'       inUseResourceCount = 123,
#'       keyAlgorithm = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       issuedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       issuerCA = "string",
#'       notBefore = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       notAfter = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       eligibleToRenew = "string",
#'       renewalSummary = list(
#'         domainValidationRecords = list(
#'           list(
#'             domainName = "string",
#'             resourceRecord = list(
#'               name = "string",
#'               type = "string",
#'               value = "string"
#'             )
#'           )
#'         ),
#'         renewalStatus = "PendingAutoRenewal"|"PendingValidation"|"Success"|"Failed",
#'         renewalStatusReason = "string",
#'         updatedAt = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       revokedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       revocationReason = "string",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       supportCode = "string"
#'     ),
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   ),
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_certificate(
#'   certificateName = "string",
#'   domainName = "string",
#'   subjectAlternativeNames = list(
#'     "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_certificate
lightsail_create_certificate <- function(certificateName, domainName, subjectAlternativeNames = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_certificate_input(certificateName = certificateName, domainName = domainName, subjectAlternativeNames = subjectAlternativeNames, tags = tags)
  output <- .lightsail$create_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_certificate <- lightsail_create_certificate

#' Creates an AWS CloudFormation stack, which creates a new Amazon EC2
#' instance from an exported Amazon Lightsail snapshot
#'
#' @description
#' Creates an AWS CloudFormation stack, which creates a new Amazon EC2
#' instance from an exported Amazon Lightsail snapshot. This operation
#' results in a CloudFormation stack record that can be used to track the
#' AWS CloudFormation stack created. Use the
#' `get cloud formation stack records` operation to get a list of the
#' CloudFormation stacks created.
#' 
#' Wait until after your new Amazon EC2 instance is created before running
#' the `create cloud formation stack` operation again with the same export
#' snapshot record.
#'
#' @usage
#' lightsail_create_cloud_formation_stack(instances)
#'
#' @param instances &#91;required&#93; An array of parameters that will be used to create the new Amazon EC2
#' instance. You can only pass one instance entry at a time in this array.
#' You will get an invalid parameter error if you pass more than one
#' instance entry in this array.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_cloud_formation_stack(
#'   instances = list(
#'     list(
#'       sourceName = "string",
#'       instanceType = "string",
#'       portInfoSource = "DEFAULT"|"INSTANCE"|"NONE"|"CLOSED",
#'       userData = "string",
#'       availabilityZone = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_cloud_formation_stack
lightsail_create_cloud_formation_stack <- function(instances) {
  op <- new_operation(
    name = "CreateCloudFormationStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_cloud_formation_stack_input(instances = instances)
  output <- .lightsail$create_cloud_formation_stack_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_cloud_formation_stack <- lightsail_create_cloud_formation_stack

#' Creates an email or SMS text message contact method
#'
#' @description
#' Creates an email or SMS text message contact method.
#' 
#' A contact method is used to send you notifications about your Amazon
#' Lightsail resources. You can add one email address and one mobile phone
#' number contact method in each AWS Region. However, SMS text messaging is
#' not supported in some AWS Regions, and SMS text messages cannot be sent
#' to some countries/regions. For more information, see Notifications in
#' Amazon Lightsail.
#'
#' @usage
#' lightsail_create_contact_method(protocol, contactEndpoint)
#'
#' @param protocol &#91;required&#93; The protocol of the contact method, such as `Email` or `SMS` (text
#' messaging).
#' 
#' The `SMS` protocol is supported only in the following AWS Regions.
#' 
#' -   US East (N. Virginia) (`us-east-1`)
#' 
#' -   US West (Oregon) (`us-west-2`)
#' 
#' -   Europe (Ireland) (`eu-west-1`)
#' 
#' -   Asia Pacific (Tokyo) (`ap-northeast-1`)
#' 
#' -   Asia Pacific (Singapore) (`ap-southeast-1`)
#' 
#' -   Asia Pacific (Sydney) (`ap-southeast-2`)
#' 
#' For a list of countries/regions where SMS text messages can be sent, and
#' the latest AWS Regions where SMS text messaging is supported, see
#' [Supported Regions and
#' Countries](https://docs.aws.amazon.com/sns/latest/dg/sns-supported-regions-countries.html)
#' in the *Amazon SNS Developer Guide*.
#' 
#' For more information about notifications in Amazon Lightsail, see
#' Notifications in Amazon Lightsail.
#' @param contactEndpoint &#91;required&#93; The destination of the contact method, such as an email address or a
#' mobile phone number.
#' 
#' Use the E.164 format when specifying a mobile phone number. E.164 is a
#' standard for the phone number structure used for international
#' telecommunication. Phone numbers that follow this format can have a
#' maximum of 15 digits, and they are prefixed with the plus character (+)
#' and the country code. For example, a U.S. phone number in E.164 format
#' would be specified as +1XXX5550100. For more information, see
#' [E.164](https://en.wikipedia.org/wiki/E.164) on *Wikipedia*.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_contact_method(
#'   protocol = "Email"|"SMS",
#'   contactEndpoint = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_contact_method
lightsail_create_contact_method <- function(protocol, contactEndpoint) {
  op <- new_operation(
    name = "CreateContactMethod",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_contact_method_input(protocol = protocol, contactEndpoint = contactEndpoint)
  output <- .lightsail$create_contact_method_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_contact_method <- lightsail_create_contact_method

#' Creates an Amazon Lightsail container service
#'
#' @description
#' Creates an Amazon Lightsail container service.
#' 
#' A Lightsail container service is a compute resource to which you can
#' deploy containers. For more information, see Container services in
#' Amazon Lightsail in the *Lightsail Dev Guide*.
#'
#' @usage
#' lightsail_create_container_service(serviceName, power, scale, tags,
#'   publicDomainNames, deployment)
#'
#' @param serviceName &#91;required&#93; The name for the container service.
#' 
#' The name that you specify for your container service will make up part
#' of its default domain. The default domain of a container service is
#' typically
#' `https://<ServiceName>.<RandomGUID>.<AWSRegion>.cs.amazonlightsail.com`.
#' If the name of your container service is `container-service-1`, and it's
#' located in the US East (Ohio) AWS region (`us-east-2`), then the domain
#' for your container service will be like the following example:
#' `https://container-service-1.ur4EXAMPLE2uq.us-east-2.cs.amazonlightsail.com`
#' 
#' The following are the requirements for container service names:
#' 
#' -   Must be unique within each AWS Region in your Lightsail account.
#' 
#' -   Must contain 1 to 63 characters.
#' 
#' -   Must contain only alphanumeric characters and hyphens.
#' 
#' -   A hyphen (-) can separate words but cannot be at the start or end of
#'     the name.
#' @param power &#91;required&#93; The power specification for the container service.
#' 
#' The power specifies the amount of memory, vCPUs, and base monthly cost
#' of each node of the container service. The `power` and `scale` of a
#' container service makes up its configured capacity. To determine the
#' monthly price of your container service, multiply the base price of the
#' `power` with the `scale` (the number of nodes) of the service.
#' 
#' Use the
#' [`get_container_service_powers`][lightsail_get_container_service_powers]
#' action to get a list of power options that you can specify using this
#' parameter, and their base monthly cost.
#' @param scale &#91;required&#93; The scale specification for the container service.
#' 
#' The scale specifies the allocated compute nodes of the container
#' service. The `power` and `scale` of a container service makes up its
#' configured capacity. To determine the monthly price of your container
#' service, multiply the base price of the `power` with the `scale` (the
#' number of nodes) of the service.
#' @param tags The tag keys and optional values for the container service.
#' 
#' For more information about tags in Lightsail, see the Lightsail Dev
#' Guide.
#' @param publicDomainNames The public domain names to use with the container service, such as
#' `example.com` and `www.example.com`.
#' 
#' You can specify up to four public domain names for a container service.
#' The domain names that you specify are used when you create a deployment
#' with a container configured as the public endpoint of your container
#' service.
#' 
#' If you don't specify public domain names, then you can use the default
#' domain of the container service.
#' 
#' You must create and validate an SSL/TLS certificate before you can use
#' public domain names with your container service. Use the
#' [`create_certificate`][lightsail_create_certificate] action to create a
#' certificate for the public domain names you want to use with your
#' container service.
#' 
#' You can specify public domain names using a string to array map as shown
#' in the example later on this page.
#' @param deployment An object that describes a deployment for the container service.
#' 
#' A deployment specifies the containers that will be launched on the
#' container service and their settings, such as the ports to open, the
#' environment variables to apply, and the launch command to run. It also
#' specifies the container that will serve as the public endpoint of the
#' deployment and its settings, such as the HTTP or HTTPS port to use, and
#' the health check configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   containerService = list(
#'     containerServiceName = "string",
#'     arn = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
#'     powerId = "string",
#'     state = "PENDING"|"READY"|"RUNNING"|"UPDATING"|"DELETING"|"DISABLED",
#'     scale = 123,
#'     currentDeployment = list(
#'       version = 123,
#'       state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'       containers = list(
#'         list(
#'           image = "string",
#'           command = list(
#'             "string"
#'           ),
#'           environment = list(
#'             "string"
#'           ),
#'           ports = list(
#'             "HTTP"|"HTTPS"|"TCP"|"UDP"
#'           )
#'         )
#'       ),
#'       publicEndpoint = list(
#'         containerName = "string",
#'         containerPort = 123,
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           unhealthyThreshold = 123,
#'           timeoutSeconds = 123,
#'           intervalSeconds = 123,
#'           path = "string",
#'           successCodes = "string"
#'         )
#'       ),
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     nextDeployment = list(
#'       version = 123,
#'       state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'       containers = list(
#'         list(
#'           image = "string",
#'           command = list(
#'             "string"
#'           ),
#'           environment = list(
#'             "string"
#'           ),
#'           ports = list(
#'             "HTTP"|"HTTPS"|"TCP"|"UDP"
#'           )
#'         )
#'       ),
#'       publicEndpoint = list(
#'         containerName = "string",
#'         containerPort = 123,
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           unhealthyThreshold = 123,
#'           timeoutSeconds = 123,
#'           intervalSeconds = 123,
#'           path = "string",
#'           successCodes = "string"
#'         )
#'       ),
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     isDisabled = TRUE|FALSE,
#'     principalArn = "string",
#'     privateDomainName = "string",
#'     publicDomainNames = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     url = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_container_service(
#'   serviceName = "string",
#'   power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
#'   scale = 123,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   publicDomainNames = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   deployment = list(
#'     containers = list(
#'       list(
#'         image = "string",
#'         command = list(
#'           "string"
#'         ),
#'         environment = list(
#'           "string"
#'         ),
#'         ports = list(
#'           "HTTP"|"HTTPS"|"TCP"|"UDP"
#'         )
#'       )
#'     ),
#'     publicEndpoint = list(
#'       containerName = "string",
#'       containerPort = 123,
#'       healthCheck = list(
#'         healthyThreshold = 123,
#'         unhealthyThreshold = 123,
#'         timeoutSeconds = 123,
#'         intervalSeconds = 123,
#'         path = "string",
#'         successCodes = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_container_service
lightsail_create_container_service <- function(serviceName, power, scale, tags = NULL, publicDomainNames = NULL, deployment = NULL) {
  op <- new_operation(
    name = "CreateContainerService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_container_service_input(serviceName = serviceName, power = power, scale = scale, tags = tags, publicDomainNames = publicDomainNames, deployment = deployment)
  output <- .lightsail$create_container_service_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_container_service <- lightsail_create_container_service

#' Creates a deployment for your Amazon Lightsail container service
#'
#' @description
#' Creates a deployment for your Amazon Lightsail container service.
#' 
#' A deployment specifies the containers that will be launched on the
#' container service and their settings, such as the ports to open, the
#' environment variables to apply, and the launch command to run. It also
#' specifies the container that will serve as the public endpoint of the
#' deployment and its settings, such as the HTTP or HTTPS port to use, and
#' the health check configuration.
#' 
#' You can deploy containers to your container service using container
#' images from a public registry like Docker Hub, or from your local
#' machine. For more information, see Creating container images for your
#' Amazon Lightsail container services in the *Lightsail Dev Guide*.
#'
#' @usage
#' lightsail_create_container_service_deployment(serviceName, containers,
#'   publicEndpoint)
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to create the deployment.
#' @param containers An object that describes the settings of the containers that will be
#' launched on the container service.
#' @param publicEndpoint An object that describes the settings of the public endpoint for the
#' container service.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   containerService = list(
#'     containerServiceName = "string",
#'     arn = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
#'     powerId = "string",
#'     state = "PENDING"|"READY"|"RUNNING"|"UPDATING"|"DELETING"|"DISABLED",
#'     scale = 123,
#'     currentDeployment = list(
#'       version = 123,
#'       state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'       containers = list(
#'         list(
#'           image = "string",
#'           command = list(
#'             "string"
#'           ),
#'           environment = list(
#'             "string"
#'           ),
#'           ports = list(
#'             "HTTP"|"HTTPS"|"TCP"|"UDP"
#'           )
#'         )
#'       ),
#'       publicEndpoint = list(
#'         containerName = "string",
#'         containerPort = 123,
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           unhealthyThreshold = 123,
#'           timeoutSeconds = 123,
#'           intervalSeconds = 123,
#'           path = "string",
#'           successCodes = "string"
#'         )
#'       ),
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     nextDeployment = list(
#'       version = 123,
#'       state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'       containers = list(
#'         list(
#'           image = "string",
#'           command = list(
#'             "string"
#'           ),
#'           environment = list(
#'             "string"
#'           ),
#'           ports = list(
#'             "HTTP"|"HTTPS"|"TCP"|"UDP"
#'           )
#'         )
#'       ),
#'       publicEndpoint = list(
#'         containerName = "string",
#'         containerPort = 123,
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           unhealthyThreshold = 123,
#'           timeoutSeconds = 123,
#'           intervalSeconds = 123,
#'           path = "string",
#'           successCodes = "string"
#'         )
#'       ),
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     isDisabled = TRUE|FALSE,
#'     principalArn = "string",
#'     privateDomainName = "string",
#'     publicDomainNames = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     url = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_container_service_deployment(
#'   serviceName = "string",
#'   containers = list(
#'     list(
#'       image = "string",
#'       command = list(
#'         "string"
#'       ),
#'       environment = list(
#'         "string"
#'       ),
#'       ports = list(
#'         "HTTP"|"HTTPS"|"TCP"|"UDP"
#'       )
#'     )
#'   ),
#'   publicEndpoint = list(
#'     containerName = "string",
#'     containerPort = 123,
#'     healthCheck = list(
#'       healthyThreshold = 123,
#'       unhealthyThreshold = 123,
#'       timeoutSeconds = 123,
#'       intervalSeconds = 123,
#'       path = "string",
#'       successCodes = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_container_service_deployment
lightsail_create_container_service_deployment <- function(serviceName, containers = NULL, publicEndpoint = NULL) {
  op <- new_operation(
    name = "CreateContainerServiceDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_container_service_deployment_input(serviceName = serviceName, containers = containers, publicEndpoint = publicEndpoint)
  output <- .lightsail$create_container_service_deployment_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_container_service_deployment <- lightsail_create_container_service_deployment

#' Creates a temporary set of log in credentials that you can use to log in
#' to the Docker process on your local machine
#'
#' @description
#' Creates a temporary set of log in credentials that you can use to log in
#' to the Docker process on your local machine. After you're logged in, you
#' can use the native Docker commands to push your local container images
#' to the container image registry of your Amazon Lightsail account so that
#' you can use them with your Lightsail container service. The log in
#' credentials expire 12 hours after they are created, at which point you
#' will need to create a new set of log in credentials.
#' 
#' You can only push container images to the container service registry of
#' your Lightsail account. You cannot pull container images perform any
#' other container image management actions on the container service
#' registry of your Lightsail account.
#' 
#' After you push your container images to the container image registry of
#' your Lightsail account, use the
#' [`register_container_image`][lightsail_register_container_image] action
#' to register the pushed images to a specific Lightsail container service.
#' 
#' This action is not required if you install and use the Lightsail Control
#' (lightsailctl) plugin to push container images to your Lightsail
#' container service. For more information, see Pushing and managing
#' container images on your Amazon Lightsail container services in the
#' *Lightsail Dev Guide*.
#'
#' @usage
#' lightsail_create_container_service_registry_login()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   registryLogin = list(
#'     username = "string",
#'     password = "string",
#'     expiresAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     registry = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_container_service_registry_login()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_container_service_registry_login
lightsail_create_container_service_registry_login <- function() {
  op <- new_operation(
    name = "CreateContainerServiceRegistryLogin",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_container_service_registry_login_input()
  output <- .lightsail$create_container_service_registry_login_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_container_service_registry_login <- lightsail_create_container_service_registry_login

#' Creates a block storage disk that can be attached to an Amazon Lightsail
#' instance in the same Availability Zone (e
#'
#' @description
#' Creates a block storage disk that can be attached to an Amazon Lightsail
#' instance in the same Availability Zone (e.g., `us-east-2a`).
#' 
#' The `create disk` operation supports tag-based access control via
#' request tags. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_disk(diskName, availabilityZone, sizeInGb, tags,
#'   addOns)
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (e.g., `my-disk`).
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create the disk (e.g.,
#' `us-east-2a`). Use the same Availability Zone as the Lightsail instance
#' to which you want to attach the disk.
#' 
#' Use the `get regions` operation to list the Availability Zones where
#' Lightsail is currently available.
#' @param sizeInGb &#91;required&#93; The size of the disk in GB (e.g., `32`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects that represent the add-ons to enable for the new
#' disk.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_disk(
#'   diskName = "string",
#'   availabilityZone = "string",
#'   sizeInGb = 123,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   addOns = list(
#'     list(
#'       addOnType = "AutoSnapshot",
#'       autoSnapshotAddOnRequest = list(
#'         snapshotTimeOfDay = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk
lightsail_create_disk <- function(diskName, availabilityZone, sizeInGb, tags = NULL, addOns = NULL) {
  op <- new_operation(
    name = "CreateDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_disk_input(diskName = diskName, availabilityZone = availabilityZone, sizeInGb = sizeInGb, tags = tags, addOns = addOns)
  output <- .lightsail$create_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk <- lightsail_create_disk

#' Creates a block storage disk from a manual or automatic snapshot of a
#' disk
#'
#' @description
#' Creates a block storage disk from a manual or automatic snapshot of a
#' disk. The resulting disk can be attached to an Amazon Lightsail instance
#' in the same Availability Zone (e.g., `us-east-2a`).
#' 
#' The `create disk from snapshot` operation supports tag-based access
#' control via request tags and resource tags applied to the resource
#' identified by `disk snapshot name`. For more information, see the
#' Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_disk_from_snapshot(diskName, diskSnapshotName,
#'   availabilityZone, sizeInGb, tags, addOns, sourceDiskName, restoreDate,
#'   useLatestRestorableAutoSnapshot)
#'
#' @param diskName &#91;required&#93; The unique Lightsail disk name (e.g., `my-disk`).
#' @param diskSnapshotName The name of the disk snapshot (e.g., `my-snapshot`) from which to create
#' the new storage disk.
#' 
#' Constraint:
#' 
#' -   This parameter cannot be defined together with the
#'     `source disk name` parameter. The `disk snapshot name` and
#'     `source disk name` parameters are mutually exclusive.
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create the disk (e.g.,
#' `us-east-2a`). Choose the same Availability Zone as the Lightsail
#' instance where you want to create the disk.
#' 
#' Use the GetRegions operation to list the Availability Zones where
#' Lightsail is currently available.
#' @param sizeInGb &#91;required&#93; The size of the disk in GB (e.g., `32`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects that represent the add-ons to enable for the new
#' disk.
#' @param sourceDiskName The name of the source disk from which the source automatic snapshot was
#' created.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the
#'     `disk snapshot name` parameter. The `source disk name` and
#'     `disk snapshot name` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new disk from an
#'     automatic snapshot. For more information, see the Lightsail Dev
#'     Guide.
#' @param restoreDate The date of the automatic snapshot to use for the new disk. Use the
#' `get auto snapshots` operation to identify the dates of the available
#' automatic snapshots.
#' 
#' Constraints:
#' 
#' -   Must be specified in `YYYY-MM-DD` format.
#' 
#' -   This parameter cannot be defined together with the
#'     `use latest restorable auto snapshot` parameter. The `restore date`
#'     and `use latest restorable auto snapshot` parameters are mutually
#'     exclusive.
#' 
#' -   Define this parameter only when creating a new disk from an
#'     automatic snapshot. For more information, see the Lightsail Dev
#'     Guide.
#' @param useLatestRestorableAutoSnapshot A Boolean value to indicate whether to use the latest available
#' automatic snapshot.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the `restore date`
#'     parameter. The `use latest restorable auto snapshot` and
#'     `restore date` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new disk from an
#'     automatic snapshot. For more information, see the Lightsail Dev
#'     Guide.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_disk_from_snapshot(
#'   diskName = "string",
#'   diskSnapshotName = "string",
#'   availabilityZone = "string",
#'   sizeInGb = 123,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   addOns = list(
#'     list(
#'       addOnType = "AutoSnapshot",
#'       autoSnapshotAddOnRequest = list(
#'         snapshotTimeOfDay = "string"
#'       )
#'     )
#'   ),
#'   sourceDiskName = "string",
#'   restoreDate = "string",
#'   useLatestRestorableAutoSnapshot = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk_from_snapshot
lightsail_create_disk_from_snapshot <- function(diskName, diskSnapshotName = NULL, availabilityZone, sizeInGb, tags = NULL, addOns = NULL, sourceDiskName = NULL, restoreDate = NULL, useLatestRestorableAutoSnapshot = NULL) {
  op <- new_operation(
    name = "CreateDiskFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_disk_from_snapshot_input(diskName = diskName, diskSnapshotName = diskSnapshotName, availabilityZone = availabilityZone, sizeInGb = sizeInGb, tags = tags, addOns = addOns, sourceDiskName = sourceDiskName, restoreDate = restoreDate, useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot)
  output <- .lightsail$create_disk_from_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk_from_snapshot <- lightsail_create_disk_from_snapshot

#' Creates a snapshot of a block storage disk
#'
#' @description
#' Creates a snapshot of a block storage disk. You can use snapshots for
#' backups, to make copies of disks, and to save data before shutting down
#' a Lightsail instance.
#' 
#' You can take a snapshot of an attached disk that is in use; however,
#' snapshots only capture data that has been written to your disk at the
#' time the snapshot command is issued. This may exclude any data that has
#' been cached by any applications or the operating system. If you can
#' pause any file systems on the disk long enough to take a snapshot, your
#' snapshot should be complete. Nevertheless, if you cannot pause all file
#' writes to the disk, you should unmount the disk from within the
#' Lightsail instance, issue the create disk snapshot command, and then
#' remount the disk to ensure a consistent and complete snapshot. You may
#' remount and use your disk while the snapshot status is pending.
#' 
#' You can also use this operation to create a snapshot of an instance's
#' system volume. You might want to do this, for example, to recover data
#' from the system volume of a botched instance or to create a backup of
#' the system volume like you would for a block storage disk. To create a
#' snapshot of a system volume, just define the `instance name` parameter
#' when issuing the snapshot command, and a snapshot of the defined
#' instance's system volume will be created. After the snapshot is
#' available, you can create a block storage disk from the snapshot and
#' attach it to a running instance to access the data on the disk.
#' 
#' The `create disk snapshot` operation supports tag-based access control
#' via request tags. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_disk_snapshot(diskName, diskSnapshotName, instanceName,
#'   tags)
#'
#' @param diskName The unique name of the source disk (e.g., `Disk-Virginia-1`).
#' 
#' This parameter cannot be defined together with the `instance name`
#' parameter. The `disk name` and `instance name` parameters are mutually
#' exclusive.
#' @param diskSnapshotName &#91;required&#93; The name of the destination disk snapshot (e.g., `my-disk-snapshot`)
#' based on the source disk.
#' @param instanceName The unique name of the source instance (e.g.,
#' `Amazon_Linux-512MB-Virginia-1`). When this is defined, a snapshot of
#' the instance's system volume is created.
#' 
#' This parameter cannot be defined together with the `disk name`
#' parameter. The `instance name` and `disk name` parameters are mutually
#' exclusive.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_disk_snapshot(
#'   diskName = "string",
#'   diskSnapshotName = "string",
#'   instanceName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_disk_snapshot
lightsail_create_disk_snapshot <- function(diskName = NULL, diskSnapshotName, instanceName = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_disk_snapshot_input(diskName = diskName, diskSnapshotName = diskSnapshotName, instanceName = instanceName, tags = tags)
  output <- .lightsail$create_disk_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_disk_snapshot <- lightsail_create_disk_snapshot

#' Creates an Amazon Lightsail content delivery network (CDN) distribution
#'
#' @description
#' Creates an Amazon Lightsail content delivery network (CDN) distribution.
#' 
#' A distribution is a globally distributed network of caching servers that
#' improve the performance of your website or web application hosted on a
#' Lightsail instance. For more information, see Content delivery networks
#' in Amazon Lightsail.
#'
#' @usage
#' lightsail_create_distribution(distributionName, origin,
#'   defaultCacheBehavior, cacheBehaviorSettings, cacheBehaviors, bundleId,
#'   tags)
#'
#' @param distributionName &#91;required&#93; The name for the distribution.
#' @param origin &#91;required&#93; An object that describes the origin resource for the distribution, such
#' as a Lightsail instance or load balancer.
#' 
#' The distribution pulls, caches, and serves content from the origin.
#' @param defaultCacheBehavior &#91;required&#93; An object that describes the default cache behavior for the
#' distribution.
#' @param cacheBehaviorSettings An object that describes the cache behavior settings for the
#' distribution.
#' @param cacheBehaviors An array of objects that describe the per-path cache behavior for the
#' distribution.
#' @param bundleId &#91;required&#93; The bundle ID to use for the distribution.
#' 
#' A distribution bundle describes the specifications of your distribution,
#' such as the monthly cost and monthly network transfer quota.
#' 
#' Use the [`get_distribution_bundles`][lightsail_get_distribution_bundles]
#' action to get a list of distribution bundle IDs that you can specify.
#' @param tags The tag keys and optional values to add to the distribution during
#' create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   distribution = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     alternativeDomainNames = list(
#'       "string"
#'     ),
#'     status = "string",
#'     isEnabled = TRUE|FALSE,
#'     domainName = "string",
#'     bundleId = "string",
#'     certificateName = "string",
#'     origin = list(
#'       name = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2",
#'       protocolPolicy = "http-only"|"https-only"
#'     ),
#'     originPublicDNS = "string",
#'     defaultCacheBehavior = list(
#'       behavior = "dont-cache"|"cache"
#'     ),
#'     cacheBehaviorSettings = list(
#'       defaultTTL = 123,
#'       minimumTTL = 123,
#'       maximumTTL = 123,
#'       allowedHTTPMethods = "string",
#'       cachedHTTPMethods = "string",
#'       forwardedCookies = list(
#'         option = "none"|"allow-list"|"all",
#'         cookiesAllowList = list(
#'           "string"
#'         )
#'       ),
#'       forwardedHeaders = list(
#'         option = "none"|"allow-list"|"all",
#'         headersAllowList = list(
#'           "Accept"|"Accept-Charset"|"Accept-Datetime"|"Accept-Encoding"|"Accept-Language"|"Authorization"|"CloudFront-Forwarded-Proto"|"CloudFront-Is-Desktop-Viewer"|"CloudFront-Is-Mobile-Viewer"|"CloudFront-Is-SmartTV-Viewer"|"CloudFront-Is-Tablet-Viewer"|"CloudFront-Viewer-Country"|"Host"|"Origin"|"Referer"
#'         )
#'       ),
#'       forwardedQueryStrings = list(
#'         option = TRUE|FALSE,
#'         queryStringsAllowList = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     cacheBehaviors = list(
#'       list(
#'         path = "string",
#'         behavior = "dont-cache"|"cache"
#'       )
#'     ),
#'     ableToUpdateBundle = TRUE|FALSE,
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   ),
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_distribution(
#'   distributionName = "string",
#'   origin = list(
#'     name = "string",
#'     regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2",
#'     protocolPolicy = "http-only"|"https-only"
#'   ),
#'   defaultCacheBehavior = list(
#'     behavior = "dont-cache"|"cache"
#'   ),
#'   cacheBehaviorSettings = list(
#'     defaultTTL = 123,
#'     minimumTTL = 123,
#'     maximumTTL = 123,
#'     allowedHTTPMethods = "string",
#'     cachedHTTPMethods = "string",
#'     forwardedCookies = list(
#'       option = "none"|"allow-list"|"all",
#'       cookiesAllowList = list(
#'         "string"
#'       )
#'     ),
#'     forwardedHeaders = list(
#'       option = "none"|"allow-list"|"all",
#'       headersAllowList = list(
#'         "Accept"|"Accept-Charset"|"Accept-Datetime"|"Accept-Encoding"|"Accept-Language"|"Authorization"|"CloudFront-Forwarded-Proto"|"CloudFront-Is-Desktop-Viewer"|"CloudFront-Is-Mobile-Viewer"|"CloudFront-Is-SmartTV-Viewer"|"CloudFront-Is-Tablet-Viewer"|"CloudFront-Viewer-Country"|"Host"|"Origin"|"Referer"
#'       )
#'     ),
#'     forwardedQueryStrings = list(
#'       option = TRUE|FALSE,
#'       queryStringsAllowList = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   cacheBehaviors = list(
#'     list(
#'       path = "string",
#'       behavior = "dont-cache"|"cache"
#'     )
#'   ),
#'   bundleId = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_distribution
lightsail_create_distribution <- function(distributionName, origin, defaultCacheBehavior, cacheBehaviorSettings = NULL, cacheBehaviors = NULL, bundleId, tags = NULL) {
  op <- new_operation(
    name = "CreateDistribution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_distribution_input(distributionName = distributionName, origin = origin, defaultCacheBehavior = defaultCacheBehavior, cacheBehaviorSettings = cacheBehaviorSettings, cacheBehaviors = cacheBehaviors, bundleId = bundleId, tags = tags)
  output <- .lightsail$create_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_distribution <- lightsail_create_distribution

#' Creates a domain resource for the specified domain (e
#'
#' @description
#' Creates a domain resource for the specified domain (e.g., example.com).
#' 
#' The `create domain` operation supports tag-based access control via
#' request tags. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_domain(domainName, tags)
#'
#' @param domainName &#91;required&#93; The domain name to manage (e.g., `example.com`).
#' 
#' You cannot register a new domain name using Lightsail. You must register
#' a domain name using Amazon Route 53 or another domain name registrar. If
#' you have already registered your domain, you can enter its name in this
#' parameter to manage the DNS records for that domain.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_domain(
#'   domainName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_domain
lightsail_create_domain <- function(domainName, tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_domain_input(domainName = domainName, tags = tags)
  output <- .lightsail$create_domain_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_domain <- lightsail_create_domain

#' Creates one of the following domain name system (DNS) records in a
#' domain DNS zone: Address (A), canonical name (CNAME), mail exchanger
#' (MX), name server (NS), start of authority (SOA), service locator (SRV),
#' or text (TXT)
#'
#' @description
#' Creates one of the following domain name system (DNS) records in a
#' domain DNS zone: Address (A), canonical name (CNAME), mail exchanger
#' (MX), name server (NS), start of authority (SOA), service locator (SRV),
#' or text (TXT).
#' 
#' The `create domain entry` operation supports tag-based access control
#' via resource tags applied to the resource identified by `domain name`.
#' For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_domain_entry(domainName, domainEntry)
#'
#' @param domainName &#91;required&#93; The domain name (e.g., `example.com`) for which you want to create the
#' domain entry.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about the domain
#' entry request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_domain_entry(
#'   domainName = "string",
#'   domainEntry = list(
#'     id = "string",
#'     name = "string",
#'     target = "string",
#'     isAlias = TRUE|FALSE,
#'     type = "string",
#'     options = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_domain_entry
lightsail_create_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "CreateDomainEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$create_domain_entry_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_domain_entry <- lightsail_create_domain_entry

#' Creates a snapshot of a specific virtual private server, or instance
#'
#' @description
#' Creates a snapshot of a specific virtual private server, or *instance*.
#' You can use a snapshot to create a new instance that is based on that
#' snapshot.
#' 
#' The `create instance snapshot` operation supports tag-based access
#' control via request tags. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_create_instance_snapshot(instanceSnapshotName, instanceName,
#'   tags)
#'
#' @param instanceSnapshotName &#91;required&#93; The name for your new snapshot.
#' @param instanceName &#91;required&#93; The Lightsail instance on which to base your snapshot.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_instance_snapshot(
#'   instanceSnapshotName = "string",
#'   instanceName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instance_snapshot
lightsail_create_instance_snapshot <- function(instanceSnapshotName, instanceName, tags = NULL) {
  op <- new_operation(
    name = "CreateInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName, instanceName = instanceName, tags = tags)
  output <- .lightsail$create_instance_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instance_snapshot <- lightsail_create_instance_snapshot

#' Creates one or more Amazon Lightsail instances
#'
#' @description
#' Creates one or more Amazon Lightsail instances.
#' 
#' The `create instances` operation supports tag-based access control via
#' request tags. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_instances(instanceNames, availabilityZone,
#'   customImageName, blueprintId, bundleId, userData, keyPairName, tags,
#'   addOns)
#'
#' @param instanceNames &#91;required&#93; The names to use for your new Lightsail instances. Separate multiple
#' values using quotation marks and commas, for example:
#' `["MyFirstInstance","MySecondInstance"]`
#' @param availabilityZone &#91;required&#93; The Availability Zone in which to create your instance. Use the
#' following format: `us-east-2a` (case sensitive). You can get a list of
#' Availability Zones by using the [get
#' regions](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
#' operation. Be sure to add the `include Availability Zones` parameter to
#' your request.
#' @param customImageName (Deprecated) The name for your custom image.
#' 
#' In releases prior to June 12, 2017, this parameter was ignored by the
#' API. It is now deprecated.
#' @param blueprintId &#91;required&#93; The ID for a virtual private server image (e.g., `app_wordpress_4_4` or
#' `app_lamp_7_0`). Use the `get blueprints` operation to return a list of
#' available images (or *blueprints*).
#' 
#' Use active blueprints when creating new instances. Inactive blueprints
#' are listed to support customers with existing instances and are not
#' necessarily available to create new instances. Blueprints are marked
#' inactive when they become outdated due to operating system updates or
#' new application releases.
#' @param bundleId &#91;required&#93; The bundle of specification information for your virtual private server
#' (or *instance*), including the pricing plan (e.g., `micro_1_0`).
#' @param userData A launch script you can create that configures a server with additional
#' user data. For example, you might want to run `apt-get -y update`.
#' 
#' Depending on the machine image you choose, the command to get software
#' on your instance varies. Amazon Linux and CentOS use `yum`, Debian and
#' Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see
#' the Dev Guide.
#' @param keyPairName The name of your key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects representing the add-ons to enable for the new
#' instance.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_instances(
#'   instanceNames = list(
#'     "string"
#'   ),
#'   availabilityZone = "string",
#'   customImageName = "string",
#'   blueprintId = "string",
#'   bundleId = "string",
#'   userData = "string",
#'   keyPairName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   addOns = list(
#'     list(
#'       addOnType = "AutoSnapshot",
#'       autoSnapshotAddOnRequest = list(
#'         snapshotTimeOfDay = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instances
lightsail_create_instances <- function(instanceNames, availabilityZone, customImageName = NULL, blueprintId, bundleId, userData = NULL, keyPairName = NULL, tags = NULL, addOns = NULL) {
  op <- new_operation(
    name = "CreateInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_instances_input(instanceNames = instanceNames, availabilityZone = availabilityZone, customImageName = customImageName, blueprintId = blueprintId, bundleId = bundleId, userData = userData, keyPairName = keyPairName, tags = tags, addOns = addOns)
  output <- .lightsail$create_instances_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instances <- lightsail_create_instances

#' Creates one or more new instances from a manual or automatic snapshot of
#' an instance
#'
#' @description
#' Creates one or more new instances from a manual or automatic snapshot of
#' an instance.
#' 
#' The `create instances from snapshot` operation supports tag-based access
#' control via request tags and resource tags applied to the resource
#' identified by `instance snapshot name`. For more information, see the
#' Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_instances_from_snapshot(instanceNames,
#'   attachedDiskMapping, availabilityZone, instanceSnapshotName, bundleId,
#'   userData, keyPairName, tags, addOns, sourceInstanceName, restoreDate,
#'   useLatestRestorableAutoSnapshot)
#'
#' @param instanceNames &#91;required&#93; The names for your new instances.
#' @param attachedDiskMapping An object containing information about one or more disk mappings.
#' @param availabilityZone &#91;required&#93; The Availability Zone where you want to create your instances. Use the
#' following formatting: `us-east-2a` (case sensitive). You can get a list
#' of Availability Zones by using the [get
#' regions](https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_GetRegions.html)
#' operation. Be sure to add the `include Availability Zones` parameter to
#' your request.
#' @param instanceSnapshotName The name of the instance snapshot on which you are basing your new
#' instances. Use the get instance snapshots operation to return
#' information about your existing snapshots.
#' 
#' Constraint:
#' 
#' -   This parameter cannot be defined together with the
#'     `source instance name` parameter. The `instance snapshot name` and
#'     `source instance name` parameters are mutually exclusive.
#' @param bundleId &#91;required&#93; The bundle of specification information for your virtual private server
#' (or *instance*), including the pricing plan (e.g., `micro_1_0`).
#' @param userData You can create a launch script that configures a server with additional
#' user data. For example, `apt-get -y update`.
#' 
#' Depending on the machine image you choose, the command to get software
#' on your instance varies. Amazon Linux and CentOS use `yum`, Debian and
#' Ubuntu use `apt-get`, and FreeBSD uses `pkg`. For a complete list, see
#' the Dev Guide.
#' @param keyPairName The name for your key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#' @param addOns An array of objects representing the add-ons to enable for the new
#' instance.
#' @param sourceInstanceName The name of the source instance from which the source automatic snapshot
#' was created.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the
#'     `instance snapshot name` parameter. The `source instance name` and
#'     `instance snapshot name` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new instance from an
#'     automatic snapshot. For more information, see the Lightsail Dev
#'     Guide.
#' @param restoreDate The date of the automatic snapshot to use for the new instance. Use the
#' `get auto snapshots` operation to identify the dates of the available
#' automatic snapshots.
#' 
#' Constraints:
#' 
#' -   Must be specified in `YYYY-MM-DD` format.
#' 
#' -   This parameter cannot be defined together with the
#'     `use latest restorable auto snapshot` parameter. The `restore date`
#'     and `use latest restorable auto snapshot` parameters are mutually
#'     exclusive.
#' 
#' -   Define this parameter only when creating a new instance from an
#'     automatic snapshot. For more information, see the Lightsail Dev
#'     Guide.
#' @param useLatestRestorableAutoSnapshot A Boolean value to indicate whether to use the latest available
#' automatic snapshot.
#' 
#' Constraints:
#' 
#' -   This parameter cannot be defined together with the `restore date`
#'     parameter. The `use latest restorable auto snapshot` and
#'     `restore date` parameters are mutually exclusive.
#' 
#' -   Define this parameter only when creating a new instance from an
#'     automatic snapshot. For more information, see the Lightsail Dev
#'     Guide.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_instances_from_snapshot(
#'   instanceNames = list(
#'     "string"
#'   ),
#'   attachedDiskMapping = list(
#'     list(
#'       list(
#'         originalDiskPath = "string",
#'         newDiskName = "string"
#'       )
#'     )
#'   ),
#'   availabilityZone = "string",
#'   instanceSnapshotName = "string",
#'   bundleId = "string",
#'   userData = "string",
#'   keyPairName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   addOns = list(
#'     list(
#'       addOnType = "AutoSnapshot",
#'       autoSnapshotAddOnRequest = list(
#'         snapshotTimeOfDay = "string"
#'       )
#'     )
#'   ),
#'   sourceInstanceName = "string",
#'   restoreDate = "string",
#'   useLatestRestorableAutoSnapshot = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_instances_from_snapshot
lightsail_create_instances_from_snapshot <- function(instanceNames, attachedDiskMapping = NULL, availabilityZone, instanceSnapshotName = NULL, bundleId, userData = NULL, keyPairName = NULL, tags = NULL, addOns = NULL, sourceInstanceName = NULL, restoreDate = NULL, useLatestRestorableAutoSnapshot = NULL) {
  op <- new_operation(
    name = "CreateInstancesFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_instances_from_snapshot_input(instanceNames = instanceNames, attachedDiskMapping = attachedDiskMapping, availabilityZone = availabilityZone, instanceSnapshotName = instanceSnapshotName, bundleId = bundleId, userData = userData, keyPairName = keyPairName, tags = tags, addOns = addOns, sourceInstanceName = sourceInstanceName, restoreDate = restoreDate, useLatestRestorableAutoSnapshot = useLatestRestorableAutoSnapshot)
  output <- .lightsail$create_instances_from_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_instances_from_snapshot <- lightsail_create_instances_from_snapshot

#' Creates an SSH key pair
#'
#' @description
#' Creates an SSH key pair.
#' 
#' The `create key pair` operation supports tag-based access control via
#' request tags. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_key_pair(keyPairName, tags)
#'
#' @param keyPairName &#91;required&#93; The name for your new key pair.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   keyPair = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     fingerprint = "string"
#'   ),
#'   publicKeyBase64 = "string",
#'   privateKeyBase64 = "string",
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_key_pair(
#'   keyPairName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_key_pair
lightsail_create_key_pair <- function(keyPairName, tags = NULL) {
  op <- new_operation(
    name = "CreateKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_key_pair_input(keyPairName = keyPairName, tags = tags)
  output <- .lightsail$create_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_key_pair <- lightsail_create_key_pair

#' Creates a Lightsail load balancer
#'
#' @description
#' Creates a Lightsail load balancer. To learn more about deciding whether
#' to load balance your application, see Configure your Lightsail instances
#' for load balancing. You can create up to 5 load balancers per AWS Region
#' in your account.
#' 
#' When you create a load balancer, you can specify a unique name and port
#' settings. To change additional load balancer settings, use the
#' [`update_load_balancer_attribute`][lightsail_update_load_balancer_attribute]
#' operation.
#' 
#' The `create load balancer` operation supports tag-based access control
#' via request tags. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_load_balancer(loadBalancerName, instancePort,
#'   healthCheckPath, certificateName, certificateDomainName,
#'   certificateAlternativeNames, tags)
#'
#' @param loadBalancerName &#91;required&#93; The name of your load balancer.
#' @param instancePort &#91;required&#93; The instance port where you're creating your load balancer.
#' @param healthCheckPath The path you provided to perform the load balancer health check. If you
#' didn't specify a health check path, Lightsail uses the root path of your
#' website (e.g., `"/"`).
#' 
#' You may want to specify a custom health check path other than the root
#' of your application if your home page loads slowly or has a lot of media
#' or scripting on it.
#' @param certificateName The name of the SSL/TLS certificate.
#' 
#' If you specify `certificateName`, then `certificateDomainName` is
#' required (and vice-versa).
#' @param certificateDomainName The domain name with which your certificate is associated (e.g.,
#' `example.com`).
#' 
#' If you specify `certificateDomainName`, then `certificateName` is
#' required (and vice-versa).
#' @param certificateAlternativeNames The optional alternative domains and subdomains to use with your SSL/TLS
#' certificate (e.g., `www.example.com`, `example.com`, `m.example.com`,
#' `blog.example.com`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_load_balancer(
#'   loadBalancerName = "string",
#'   instancePort = 123,
#'   healthCheckPath = "string",
#'   certificateName = "string",
#'   certificateDomainName = "string",
#'   certificateAlternativeNames = list(
#'     "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_load_balancer
lightsail_create_load_balancer <- function(loadBalancerName, instancePort, healthCheckPath = NULL, certificateName = NULL, certificateDomainName = NULL, certificateAlternativeNames = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_load_balancer_input(loadBalancerName = loadBalancerName, instancePort = instancePort, healthCheckPath = healthCheckPath, certificateName = certificateName, certificateDomainName = certificateDomainName, certificateAlternativeNames = certificateAlternativeNames, tags = tags)
  output <- .lightsail$create_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_load_balancer <- lightsail_create_load_balancer

#' Creates a Lightsail load balancer TLS certificate
#'
#' @description
#' Creates a Lightsail load balancer TLS certificate.
#' 
#' TLS is just an updated, more secure version of Secure Socket Layer
#' (SSL).
#' 
#' The
#' [`create_load_balancer_tls_certificate`][lightsail_create_load_balancer_tls_certificate]
#' operation supports tag-based access control via resource tags applied to
#' the resource identified by `load balancer name`. For more information,
#' see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_load_balancer_tls_certificate(loadBalancerName,
#'   certificateName, certificateDomainName, certificateAlternativeNames,
#'   tags)
#'
#' @param loadBalancerName &#91;required&#93; The load balancer name where you want to create the SSL/TLS certificate.
#' @param certificateName &#91;required&#93; The SSL/TLS certificate name.
#' 
#' You can have up to 10 certificates in your account at one time. Each
#' Lightsail load balancer can have up to 2 certificates associated with it
#' at one time. There is also an overall limit to the number of
#' certificates that can be issue in a 365-day period. For more
#' information, see
#' [Limits](https://docs.aws.amazon.com/acm/latest/userguide/acm-limits.html).
#' @param certificateDomainName &#91;required&#93; The domain name (e.g., `example.com`) for your SSL/TLS certificate.
#' @param certificateAlternativeNames An array of strings listing alternative domains and subdomains for your
#' SSL/TLS certificate. Lightsail will de-dupe the names for you. You can
#' have a maximum of 9 alternative names (in addition to the 1 primary
#' domain). We do not support wildcards (e.g., `*.example.com`).
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_load_balancer_tls_certificate(
#'   loadBalancerName = "string",
#'   certificateName = "string",
#'   certificateDomainName = "string",
#'   certificateAlternativeNames = list(
#'     "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_load_balancer_tls_certificate
lightsail_create_load_balancer_tls_certificate <- function(loadBalancerName, certificateName, certificateDomainName, certificateAlternativeNames = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName, certificateDomainName = certificateDomainName, certificateAlternativeNames = certificateAlternativeNames, tags = tags)
  output <- .lightsail$create_load_balancer_tls_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_load_balancer_tls_certificate <- lightsail_create_load_balancer_tls_certificate

#' Creates a new database in Amazon Lightsail
#'
#' @description
#' Creates a new database in Amazon Lightsail.
#' 
#' The `create relational database` operation supports tag-based access
#' control via request tags. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_create_relational_database(relationalDatabaseName,
#'   availabilityZone, relationalDatabaseBlueprintId,
#'   relationalDatabaseBundleId, masterDatabaseName, masterUsername,
#'   masterUserPassword, preferredBackupWindow, preferredMaintenanceWindow,
#'   publiclyAccessible, tags)
#'
#' @param relationalDatabaseName &#91;required&#93; The name to use for your new database.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param availabilityZone The Availability Zone in which to create your new database. Use the
#' `us-east-2a` case-sensitive format.
#' 
#' You can get a list of Availability Zones by using the `get regions`
#' operation. Be sure to add the
#' `include relational database Availability Zones` parameter to your
#' request.
#' @param relationalDatabaseBlueprintId &#91;required&#93; The blueprint ID for your new database. A blueprint describes the major
#' engine version of a database.
#' 
#' You can get a list of database blueprints IDs by using the
#' `get relational database blueprints` operation.
#' @param relationalDatabaseBundleId &#91;required&#93; The bundle ID for your new database. A bundle describes the performance
#' specifications for your database.
#' 
#' You can get a list of database bundle IDs by using the
#' `get relational database bundles` operation.
#' @param masterDatabaseName &#91;required&#93; The name of the master database created when the Lightsail database
#' resource is created.
#' 
#' Constraints:
#' 
#' -   Must contain from 1 to 64 alphanumeric characters.
#' 
#' -   Cannot be a word reserved by the specified database engine
#' @param masterUsername &#91;required&#93; The master user name for your new database.
#' 
#' Constraints:
#' 
#' -   Master user name is required.
#' 
#' -   Must contain from 1 to 16 alphanumeric characters.
#' 
#' -   The first character must be a letter.
#' 
#' -   Cannot be a reserved word for the database engine you choose.
#' 
#'     For more information about reserved words in MySQL 5.6 or 5.7, see
#'     the Keywords and Reserved Words articles for [MySQL
#'     5.6](https://dev.mysql.com/doc/refman/5.6/en/keywords.html) or
#'     [MySQL 5.7](https://dev.mysql.com/doc/refman/5.7/en/keywords.html)
#'     respectively.
#' @param masterUserPassword The password for the master user of your new database. The password can
#' include any printable ASCII character except "/", """, or "@@".
#' 
#' Constraints: Must contain 8 to 41 characters.
#' @param preferredBackupWindow The daily time range during which automated backups are created for your
#' new database if automated backups are enabled.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region. For more information about the
#' preferred backup window time blocks for each region, see the [Working
#' With
#' Backups](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow)
#' guide in the Amazon Relational Database Service (Amazon RDS)
#' documentation.
#' 
#' Constraints:
#' 
#' -   Must be in the `hh24:mi-hh24:mi` format.
#' 
#'     Example: `16:00-16:30`
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your
#' new database.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Constraints:
#' 
#' -   Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
#' 
#' -   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be at least 30 minutes.
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Example: `Tue:17:00-Tue:17:30`
#' @param publiclyAccessible Specifies the accessibility options for your new database. A value of
#' `true` specifies a database that is available to resources outside of
#' your Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_relational_database(
#'   relationalDatabaseName = "string",
#'   availabilityZone = "string",
#'   relationalDatabaseBlueprintId = "string",
#'   relationalDatabaseBundleId = "string",
#'   masterDatabaseName = "string",
#'   masterUsername = "string",
#'   masterUserPassword = "string",
#'   preferredBackupWindow = "string",
#'   preferredMaintenanceWindow = "string",
#'   publiclyAccessible = TRUE|FALSE,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database
lightsail_create_relational_database <- function(relationalDatabaseName, availabilityZone = NULL, relationalDatabaseBlueprintId, relationalDatabaseBundleId, masterDatabaseName, masterUsername, masterUserPassword = NULL, preferredBackupWindow = NULL, preferredMaintenanceWindow = NULL, publiclyAccessible = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_relational_database_input(relationalDatabaseName = relationalDatabaseName, availabilityZone = availabilityZone, relationalDatabaseBlueprintId = relationalDatabaseBlueprintId, relationalDatabaseBundleId = relationalDatabaseBundleId, masterDatabaseName = masterDatabaseName, masterUsername = masterUsername, masterUserPassword = masterUserPassword, preferredBackupWindow = preferredBackupWindow, preferredMaintenanceWindow = preferredMaintenanceWindow, publiclyAccessible = publiclyAccessible, tags = tags)
  output <- .lightsail$create_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database <- lightsail_create_relational_database

#' Creates a new database from an existing database snapshot in Amazon
#' Lightsail
#'
#' @description
#' Creates a new database from an existing database snapshot in Amazon
#' Lightsail.
#' 
#' You can create a new database from a snapshot in if something goes wrong
#' with your original database, or to change it to a different plan, such
#' as a high availability or standard plan.
#' 
#' The `create relational database from snapshot` operation supports
#' tag-based access control via request tags and resource tags applied to
#' the resource identified by relationalDatabaseSnapshotName. For more
#' information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_create_relational_database_from_snapshot(
#'   relationalDatabaseName, availabilityZone, publiclyAccessible,
#'   relationalDatabaseSnapshotName, relationalDatabaseBundleId,
#'   sourceRelationalDatabaseName, restoreTime, useLatestRestorableTime,
#'   tags)
#'
#' @param relationalDatabaseName &#91;required&#93; The name to use for your new database.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param availabilityZone The Availability Zone in which to create your new database. Use the
#' `us-east-2a` case-sensitive format.
#' 
#' You can get a list of Availability Zones by using the `get regions`
#' operation. Be sure to add the
#' `include relational database Availability Zones` parameter to your
#' request.
#' @param publiclyAccessible Specifies the accessibility options for your new database. A value of
#' `true` specifies a database that is available to resources outside of
#' your Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param relationalDatabaseSnapshotName The name of the database snapshot from which to create your new
#' database.
#' @param relationalDatabaseBundleId The bundle ID for your new database. A bundle describes the performance
#' specifications for your database.
#' 
#' You can get a list of database bundle IDs by using the
#' `get relational database bundles` operation.
#' 
#' When creating a new database from a snapshot, you cannot choose a bundle
#' that is smaller than the bundle of the source database.
#' @param sourceRelationalDatabaseName The name of the source database.
#' @param restoreTime The date and time to restore your database from.
#' 
#' Constraints:
#' 
#' -   Must be before the latest restorable time for the database.
#' 
#' -   Cannot be specified if the `use latest restorable time` parameter is
#'     `true`.
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a restore time of October 1, 2018,
#'     at 8 PM UTC, then you input `1538424000` as the restore time.
#' @param useLatestRestorableTime Specifies whether your database is restored from the latest backup time.
#' A value of `true` restores from the latest backup time.
#' 
#' Default: `false`
#' 
#' Constraints: Cannot be specified if the `restore time` parameter is
#' provided.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_relational_database_from_snapshot(
#'   relationalDatabaseName = "string",
#'   availabilityZone = "string",
#'   publiclyAccessible = TRUE|FALSE,
#'   relationalDatabaseSnapshotName = "string",
#'   relationalDatabaseBundleId = "string",
#'   sourceRelationalDatabaseName = "string",
#'   restoreTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   useLatestRestorableTime = TRUE|FALSE,
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database_from_snapshot
lightsail_create_relational_database_from_snapshot <- function(relationalDatabaseName, availabilityZone = NULL, publiclyAccessible = NULL, relationalDatabaseSnapshotName = NULL, relationalDatabaseBundleId = NULL, sourceRelationalDatabaseName = NULL, restoreTime = NULL, useLatestRestorableTime = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabaseFromSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_relational_database_from_snapshot_input(relationalDatabaseName = relationalDatabaseName, availabilityZone = availabilityZone, publiclyAccessible = publiclyAccessible, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName, relationalDatabaseBundleId = relationalDatabaseBundleId, sourceRelationalDatabaseName = sourceRelationalDatabaseName, restoreTime = restoreTime, useLatestRestorableTime = useLatestRestorableTime, tags = tags)
  output <- .lightsail$create_relational_database_from_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database_from_snapshot <- lightsail_create_relational_database_from_snapshot

#' Creates a snapshot of your database in Amazon Lightsail
#'
#' @description
#' Creates a snapshot of your database in Amazon Lightsail. You can use
#' snapshots for backups, to make copies of a database, and to save data
#' before deleting a database.
#' 
#' The `create relational database snapshot` operation supports tag-based
#' access control via request tags. For more information, see the Lightsail
#' Dev Guide.
#'
#' @usage
#' lightsail_create_relational_database_snapshot(relationalDatabaseName,
#'   relationalDatabaseSnapshotName, tags)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database on which to base your new snapshot.
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name for your new database snapshot.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#' @param tags The tag keys and optional values to add to the resource during create.
#' 
#' Use the [`tag_resource`][lightsail_tag_resource] action to tag a
#' resource after it's created.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_relational_database_snapshot(
#'   relationalDatabaseName = "string",
#'   relationalDatabaseSnapshotName = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_create_relational_database_snapshot
lightsail_create_relational_database_snapshot <- function(relationalDatabaseName, relationalDatabaseSnapshotName, tags = NULL) {
  op <- new_operation(
    name = "CreateRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$create_relational_database_snapshot_input(relationalDatabaseName = relationalDatabaseName, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName, tags = tags)
  output <- .lightsail$create_relational_database_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$create_relational_database_snapshot <- lightsail_create_relational_database_snapshot

#' Deletes an alarm
#'
#' @description
#' Deletes an alarm.
#' 
#' An alarm is used to monitor a single metric for one of your resources.
#' When a metric condition is met, the alarm can notify you by email, SMS
#' text message, and a banner displayed on the Amazon Lightsail console.
#' For more information, see Alarms in Amazon Lightsail.
#'
#' @usage
#' lightsail_delete_alarm(alarmName)
#'
#' @param alarmName &#91;required&#93; The name of the alarm to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_alarm(
#'   alarmName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_alarm
lightsail_delete_alarm <- function(alarmName) {
  op <- new_operation(
    name = "DeleteAlarm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_alarm_input(alarmName = alarmName)
  output <- .lightsail$delete_alarm_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_alarm <- lightsail_delete_alarm

#' Deletes an automatic snapshot of an instance or disk
#'
#' @description
#' Deletes an automatic snapshot of an instance or disk. For more
#' information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_auto_snapshot(resourceName, date)
#'
#' @param resourceName &#91;required&#93; The name of the source instance or disk from which to delete the
#' automatic snapshot.
#' @param date &#91;required&#93; The date of the automatic snapshot to delete in `YYYY-MM-DD` format. Use
#' the `get auto snapshots` operation to get the available automatic
#' snapshots for a resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_auto_snapshot(
#'   resourceName = "string",
#'   date = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_auto_snapshot
lightsail_delete_auto_snapshot <- function(resourceName, date) {
  op <- new_operation(
    name = "DeleteAutoSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_auto_snapshot_input(resourceName = resourceName, date = date)
  output <- .lightsail$delete_auto_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_auto_snapshot <- lightsail_delete_auto_snapshot

#' Deletes an SSL/TLS certificate for your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Deletes an SSL/TLS certificate for your Amazon Lightsail content
#' delivery network (CDN) distribution.
#' 
#' Certificates that are currently attached to a distribution cannot be
#' deleted. Use the
#' [`detach_certificate_from_distribution`][lightsail_detach_certificate_from_distribution]
#' action to detach a certificate from a distribution.
#'
#' @usage
#' lightsail_delete_certificate(certificateName)
#'
#' @param certificateName &#91;required&#93; The name of the certificate to delete.
#' 
#' Use the [`get_certificates`][lightsail_get_certificates] action to get a
#' list of certificate names that you can specify.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_certificate(
#'   certificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_certificate
lightsail_delete_certificate <- function(certificateName) {
  op <- new_operation(
    name = "DeleteCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_certificate_input(certificateName = certificateName)
  output <- .lightsail$delete_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_certificate <- lightsail_delete_certificate

#' Deletes a contact method
#'
#' @description
#' Deletes a contact method.
#' 
#' A contact method is used to send you notifications about your Amazon
#' Lightsail resources. You can add one email address and one mobile phone
#' number contact method in each AWS Region. However, SMS text messaging is
#' not supported in some AWS Regions, and SMS text messages cannot be sent
#' to some countries/regions. For more information, see Notifications in
#' Amazon Lightsail.
#'
#' @usage
#' lightsail_delete_contact_method(protocol)
#'
#' @param protocol &#91;required&#93; The protocol that will be deleted, such as `Email` or `SMS` (text
#' messaging).
#' 
#' To delete an `Email` and an `SMS` contact method if you added both, you
#' must run separate
#' [`delete_contact_method`][lightsail_delete_contact_method] actions to
#' delete each protocol.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_contact_method(
#'   protocol = "Email"|"SMS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_contact_method
lightsail_delete_contact_method <- function(protocol) {
  op <- new_operation(
    name = "DeleteContactMethod",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_contact_method_input(protocol = protocol)
  output <- .lightsail$delete_contact_method_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_contact_method <- lightsail_delete_contact_method

#' Deletes a container image that is registered to your Amazon Lightsail
#' container service
#'
#' @description
#' Deletes a container image that is registered to your Amazon Lightsail
#' container service.
#'
#' @usage
#' lightsail_delete_container_image(serviceName, image)
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to delete a registered
#' container image.
#' @param image &#91;required&#93; The name of the container image to delete from the container service.
#' 
#' Use the [`get_container_images`][lightsail_get_container_images] action
#' to get the name of the container images that are registered to a
#' container service.
#' 
#' Container images sourced from your Lightsail container service, that are
#' registered and stored on your service, start with a colon (`:`). For
#' example, `:container-service-1.mystaticwebsite.1`. Container images
#' sourced from a public registry like Docker Hub don't start with a colon.
#' For example, `nginx:latest` or `nginx`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_container_image(
#'   serviceName = "string",
#'   image = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_container_image
lightsail_delete_container_image <- function(serviceName, image) {
  op <- new_operation(
    name = "DeleteContainerImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_container_image_input(serviceName = serviceName, image = image)
  output <- .lightsail$delete_container_image_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_container_image <- lightsail_delete_container_image

#' Deletes your Amazon Lightsail container service
#'
#' @description
#' Deletes your Amazon Lightsail container service.
#'
#' @usage
#' lightsail_delete_container_service(serviceName)
#'
#' @param serviceName &#91;required&#93; The name of the container service to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_container_service(
#'   serviceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_container_service
lightsail_delete_container_service <- function(serviceName) {
  op <- new_operation(
    name = "DeleteContainerService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_container_service_input(serviceName = serviceName)
  output <- .lightsail$delete_container_service_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_container_service <- lightsail_delete_container_service

#' Deletes the specified block storage disk
#'
#' @description
#' Deletes the specified block storage disk. The disk must be in the
#' `available` state (not attached to a Lightsail instance).
#' 
#' The disk may remain in the `deleting` state for several minutes.
#' 
#' The `delete disk` operation supports tag-based access control via
#' resource tags applied to the resource identified by `disk name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_disk(diskName, forceDeleteAddOns)
#'
#' @param diskName &#91;required&#93; The unique name of the disk you want to delete (e.g., `my-disk`).
#' @param forceDeleteAddOns A Boolean value to indicate whether to delete the enabled add-ons for
#' the disk.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_disk(
#'   diskName = "string",
#'   forceDeleteAddOns = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_disk
lightsail_delete_disk <- function(diskName, forceDeleteAddOns = NULL) {
  op <- new_operation(
    name = "DeleteDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_disk_input(diskName = diskName, forceDeleteAddOns = forceDeleteAddOns)
  output <- .lightsail$delete_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_disk <- lightsail_delete_disk

#' Deletes the specified disk snapshot
#'
#' @description
#' Deletes the specified disk snapshot.
#' 
#' When you make periodic snapshots of a disk, the snapshots are
#' incremental, and only the blocks on the device that have changed since
#' your last snapshot are saved in the new snapshot. When you delete a
#' snapshot, only the data not needed for any other snapshot is removed. So
#' regardless of which prior snapshots have been deleted, all active
#' snapshots will have access to all the information needed to restore the
#' disk.
#' 
#' The `delete disk snapshot` operation supports tag-based access control
#' via resource tags applied to the resource identified by
#' `disk snapshot name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_disk_snapshot(diskSnapshotName)
#'
#' @param diskSnapshotName &#91;required&#93; The name of the disk snapshot you want to delete (e.g.,
#' `my-disk-snapshot`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_disk_snapshot(
#'   diskSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_disk_snapshot
lightsail_delete_disk_snapshot <- function(diskSnapshotName) {
  op <- new_operation(
    name = "DeleteDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_disk_snapshot_input(diskSnapshotName = diskSnapshotName)
  output <- .lightsail$delete_disk_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_disk_snapshot <- lightsail_delete_disk_snapshot

#' Deletes your Amazon Lightsail content delivery network (CDN)
#' distribution
#'
#' @description
#' Deletes your Amazon Lightsail content delivery network (CDN)
#' distribution.
#'
#' @usage
#' lightsail_delete_distribution(distributionName)
#'
#' @param distributionName The name of the distribution to delete.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_distribution(
#'   distributionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_distribution
lightsail_delete_distribution <- function(distributionName = NULL) {
  op <- new_operation(
    name = "DeleteDistribution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_distribution_input(distributionName = distributionName)
  output <- .lightsail$delete_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_distribution <- lightsail_delete_distribution

#' Deletes the specified domain recordset and all of its domain records
#'
#' @description
#' Deletes the specified domain recordset and all of its domain records.
#' 
#' The `delete domain` operation supports tag-based access control via
#' resource tags applied to the resource identified by `domain name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_domain(domainName)
#'
#' @param domainName &#91;required&#93; The specific domain name to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_domain(
#'   domainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_domain
lightsail_delete_domain <- function(domainName) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_domain_input(domainName = domainName)
  output <- .lightsail$delete_domain_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_domain <- lightsail_delete_domain

#' Deletes a specific domain entry
#'
#' @description
#' Deletes a specific domain entry.
#' 
#' The `delete domain entry` operation supports tag-based access control
#' via resource tags applied to the resource identified by `domain name`.
#' For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_domain_entry(domainName, domainEntry)
#'
#' @param domainName &#91;required&#93; The name of the domain entry to delete.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about your domain
#' entries.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_domain_entry(
#'   domainName = "string",
#'   domainEntry = list(
#'     id = "string",
#'     name = "string",
#'     target = "string",
#'     isAlias = TRUE|FALSE,
#'     type = "string",
#'     options = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_domain_entry
lightsail_delete_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "DeleteDomainEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$delete_domain_entry_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_domain_entry <- lightsail_delete_domain_entry

#' Deletes an Amazon Lightsail instance
#'
#' @description
#' Deletes an Amazon Lightsail instance.
#' 
#' The `delete instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by `instance name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_instance(instanceName, forceDeleteAddOns)
#'
#' @param instanceName &#91;required&#93; The name of the instance to delete.
#' @param forceDeleteAddOns A Boolean value to indicate whether to delete the enabled add-ons for
#' the disk.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_instance(
#'   instanceName = "string",
#'   forceDeleteAddOns = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_instance
lightsail_delete_instance <- function(instanceName, forceDeleteAddOns = NULL) {
  op <- new_operation(
    name = "DeleteInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_instance_input(instanceName = instanceName, forceDeleteAddOns = forceDeleteAddOns)
  output <- .lightsail$delete_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_instance <- lightsail_delete_instance

#' Deletes a specific snapshot of a virtual private server (or instance)
#'
#' @description
#' Deletes a specific snapshot of a virtual private server (or *instance*).
#' 
#' The `delete instance snapshot` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' `instance snapshot name`. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_delete_instance_snapshot(instanceSnapshotName)
#'
#' @param instanceSnapshotName &#91;required&#93; The name of the snapshot to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_instance_snapshot(
#'   instanceSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_instance_snapshot
lightsail_delete_instance_snapshot <- function(instanceSnapshotName) {
  op <- new_operation(
    name = "DeleteInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName)
  output <- .lightsail$delete_instance_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_instance_snapshot <- lightsail_delete_instance_snapshot

#' Deletes a specific SSH key pair
#'
#' @description
#' Deletes a specific SSH key pair.
#' 
#' The `delete key pair` operation supports tag-based access control via
#' resource tags applied to the resource identified by `key pair name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_key_pair(keyPairName)
#'
#' @param keyPairName &#91;required&#93; The name of the key pair to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_key_pair(
#'   keyPairName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_key_pair
lightsail_delete_key_pair <- function(keyPairName) {
  op <- new_operation(
    name = "DeleteKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_key_pair_input(keyPairName = keyPairName)
  output <- .lightsail$delete_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_key_pair <- lightsail_delete_key_pair

#' Deletes the known host key or certificate used by the Amazon Lightsail
#' browser-based SSH or RDP clients to authenticate an instance
#'
#' @description
#' Deletes the known host key or certificate used by the Amazon Lightsail
#' browser-based SSH or RDP clients to authenticate an instance. This
#' operation enables the Lightsail browser-based SSH or RDP clients to
#' connect to the instance after a host key mismatch.
#' 
#' Perform this operation only if you were expecting the host key or
#' certificate mismatch or if you are familiar with the new host key or
#' certificate on the instance. For more information, see Troubleshooting
#' connection issues when using the Amazon Lightsail browser-based SSH or
#' RDP client.
#'
#' @usage
#' lightsail_delete_known_host_keys(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance for which you want to reset the host key or
#' certificate.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_known_host_keys(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_known_host_keys
lightsail_delete_known_host_keys <- function(instanceName) {
  op <- new_operation(
    name = "DeleteKnownHostKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_known_host_keys_input(instanceName = instanceName)
  output <- .lightsail$delete_known_host_keys_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_known_host_keys <- lightsail_delete_known_host_keys

#' Deletes a Lightsail load balancer and all its associated SSL/TLS
#' certificates
#'
#' @description
#' Deletes a Lightsail load balancer and all its associated SSL/TLS
#' certificates. Once the load balancer is deleted, you will need to create
#' a new load balancer, create a new certificate, and verify domain
#' ownership again.
#' 
#' The `delete load balancer` operation supports tag-based access control
#' via resource tags applied to the resource identified by
#' `load balancer name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_load_balancer(loadBalancerName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer you want to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_load_balancer(
#'   loadBalancerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_load_balancer
lightsail_delete_load_balancer <- function(loadBalancerName) {
  op <- new_operation(
    name = "DeleteLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_load_balancer_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$delete_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_load_balancer <- lightsail_delete_load_balancer

#' Deletes an SSL/TLS certificate associated with a Lightsail load balancer
#'
#' @description
#' Deletes an SSL/TLS certificate associated with a Lightsail load
#' balancer.
#' 
#' The
#' [`delete_load_balancer_tls_certificate`][lightsail_delete_load_balancer_tls_certificate]
#' operation supports tag-based access control via resource tags applied to
#' the resource identified by `load balancer name`. For more information,
#' see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_delete_load_balancer_tls_certificate(loadBalancerName,
#'   certificateName, force)
#'
#' @param loadBalancerName &#91;required&#93; The load balancer name.
#' @param certificateName &#91;required&#93; The SSL/TLS certificate name.
#' @param force When `true`, forces the deletion of an SSL/TLS certificate.
#' 
#' There can be two certificates associated with a Lightsail load balancer:
#' the primary and the backup. The `force` parameter is required when the
#' primary SSL/TLS certificate is in use by an instance attached to the
#' load balancer.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_load_balancer_tls_certificate(
#'   loadBalancerName = "string",
#'   certificateName = "string",
#'   force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_load_balancer_tls_certificate
lightsail_delete_load_balancer_tls_certificate <- function(loadBalancerName, certificateName, force = NULL) {
  op <- new_operation(
    name = "DeleteLoadBalancerTlsCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_load_balancer_tls_certificate_input(loadBalancerName = loadBalancerName, certificateName = certificateName, force = force)
  output <- .lightsail$delete_load_balancer_tls_certificate_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_load_balancer_tls_certificate <- lightsail_delete_load_balancer_tls_certificate

#' Deletes a database in Amazon Lightsail
#'
#' @description
#' Deletes a database in Amazon Lightsail.
#' 
#' The `delete relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_delete_relational_database(relationalDatabaseName,
#'   skipFinalSnapshot, finalRelationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database that you are deleting.
#' @param skipFinalSnapshot Determines whether a final database snapshot is created before your
#' database is deleted. If `true` is specified, no database snapshot is
#' created. If `false` is specified, a database snapshot is created before
#' your database is deleted.
#' 
#' You must specify the `final relational database snapshot name` parameter
#' if the `skip final snapshot` parameter is `false`.
#' 
#' Default: `false`
#' @param finalRelationalDatabaseSnapshotName The name of the database snapshot created if `skip final snapshot` is
#' `false`, which is the default value for that parameter.
#' 
#' Specifying this parameter and also specifying the `skip final snapshot`
#' parameter to `true` results in an error.
#' 
#' Constraints:
#' 
#' -   Must contain from 2 to 255 alphanumeric characters, or hyphens.
#' 
#' -   The first and last character must be a letter or number.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_relational_database(
#'   relationalDatabaseName = "string",
#'   skipFinalSnapshot = TRUE|FALSE,
#'   finalRelationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_relational_database
lightsail_delete_relational_database <- function(relationalDatabaseName, skipFinalSnapshot = NULL, finalRelationalDatabaseSnapshotName = NULL) {
  op <- new_operation(
    name = "DeleteRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_relational_database_input(relationalDatabaseName = relationalDatabaseName, skipFinalSnapshot = skipFinalSnapshot, finalRelationalDatabaseSnapshotName = finalRelationalDatabaseSnapshotName)
  output <- .lightsail$delete_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_relational_database <- lightsail_delete_relational_database

#' Deletes a database snapshot in Amazon Lightsail
#'
#' @description
#' Deletes a database snapshot in Amazon Lightsail.
#' 
#' The `delete relational database snapshot` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_delete_relational_database_snapshot(
#'   relationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name of the database snapshot that you are deleting.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_relational_database_snapshot(
#'   relationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_delete_relational_database_snapshot
lightsail_delete_relational_database_snapshot <- function(relationalDatabaseSnapshotName) {
  op <- new_operation(
    name = "DeleteRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$delete_relational_database_snapshot_input(relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$delete_relational_database_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$delete_relational_database_snapshot <- lightsail_delete_relational_database_snapshot

#' Detaches an SSL/TLS certificate from your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Detaches an SSL/TLS certificate from your Amazon Lightsail content
#' delivery network (CDN) distribution.
#' 
#' After the certificate is detached, your distribution stops accepting
#' traffic for all of the domains that are associated with the certificate.
#'
#' @usage
#' lightsail_detach_certificate_from_distribution(distributionName)
#'
#' @param distributionName &#91;required&#93; The name of the distribution from which to detach the certificate.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$detach_certificate_from_distribution(
#'   distributionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_certificate_from_distribution
lightsail_detach_certificate_from_distribution <- function(distributionName) {
  op <- new_operation(
    name = "DetachCertificateFromDistribution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$detach_certificate_from_distribution_input(distributionName = distributionName)
  output <- .lightsail$detach_certificate_from_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_certificate_from_distribution <- lightsail_detach_certificate_from_distribution

#' Detaches a stopped block storage disk from a Lightsail instance
#'
#' @description
#' Detaches a stopped block storage disk from a Lightsail instance. Make
#' sure to unmount any file systems on the device within your operating
#' system before stopping the instance and detaching the disk.
#' 
#' The `detach disk` operation supports tag-based access control via
#' resource tags applied to the resource identified by `disk name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_detach_disk(diskName)
#'
#' @param diskName &#91;required&#93; The unique name of the disk you want to detach from your instance (e.g.,
#' `my-disk`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$detach_disk(
#'   diskName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_disk
lightsail_detach_disk <- function(diskName) {
  op <- new_operation(
    name = "DetachDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$detach_disk_input(diskName = diskName)
  output <- .lightsail$detach_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_disk <- lightsail_detach_disk

#' Detaches the specified instances from a Lightsail load balancer
#'
#' @description
#' Detaches the specified instances from a Lightsail load balancer.
#' 
#' This operation waits until the instances are no longer needed before
#' they are detached from the load balancer.
#' 
#' The `detach instances from load balancer` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' `load balancer name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_detach_instances_from_load_balancer(loadBalancerName,
#'   instanceNames)
#'
#' @param loadBalancerName &#91;required&#93; The name of the Lightsail load balancer.
#' @param instanceNames &#91;required&#93; An array of strings containing the names of the instances you want to
#' detach from the load balancer.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$detach_instances_from_load_balancer(
#'   loadBalancerName = "string",
#'   instanceNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_instances_from_load_balancer
lightsail_detach_instances_from_load_balancer <- function(loadBalancerName, instanceNames) {
  op <- new_operation(
    name = "DetachInstancesFromLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$detach_instances_from_load_balancer_input(loadBalancerName = loadBalancerName, instanceNames = instanceNames)
  output <- .lightsail$detach_instances_from_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_instances_from_load_balancer <- lightsail_detach_instances_from_load_balancer

#' Detaches a static IP from the Amazon Lightsail instance to which it is
#' attached
#'
#' @description
#' Detaches a static IP from the Amazon Lightsail instance to which it is
#' attached.
#'
#' @usage
#' lightsail_detach_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP to detach from the instance.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$detach_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_detach_static_ip
lightsail_detach_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "DetachStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$detach_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$detach_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$detach_static_ip <- lightsail_detach_static_ip

#' Disables an add-on for an Amazon Lightsail resource
#'
#' @description
#' Disables an add-on for an Amazon Lightsail resource. For more
#' information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_disable_add_on(addOnType, resourceName)
#'
#' @param addOnType &#91;required&#93; The add-on type to disable.
#' @param resourceName &#91;required&#93; The name of the source resource for which to disable the add-on.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$disable_add_on(
#'   addOnType = "AutoSnapshot",
#'   resourceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_disable_add_on
lightsail_disable_add_on <- function(addOnType, resourceName) {
  op <- new_operation(
    name = "DisableAddOn",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$disable_add_on_input(addOnType = addOnType, resourceName = resourceName)
  output <- .lightsail$disable_add_on_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$disable_add_on <- lightsail_disable_add_on

#' Downloads the default SSH key pair from the user's account
#'
#' @description
#' Downloads the default SSH key pair from the user's account.
#'
#' @usage
#' lightsail_download_default_key_pair()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   publicKeyBase64 = "string",
#'   privateKeyBase64 = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$download_default_key_pair()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_download_default_key_pair
lightsail_download_default_key_pair <- function() {
  op <- new_operation(
    name = "DownloadDefaultKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$download_default_key_pair_input()
  output <- .lightsail$download_default_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$download_default_key_pair <- lightsail_download_default_key_pair

#' Enables or modifies an add-on for an Amazon Lightsail resource
#'
#' @description
#' Enables or modifies an add-on for an Amazon Lightsail resource. For more
#' information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_enable_add_on(resourceName, addOnRequest)
#'
#' @param resourceName &#91;required&#93; The name of the source resource for which to enable or modify the
#' add-on.
#' @param addOnRequest &#91;required&#93; An array of strings representing the add-on to enable or modify.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$enable_add_on(
#'   resourceName = "string",
#'   addOnRequest = list(
#'     addOnType = "AutoSnapshot",
#'     autoSnapshotAddOnRequest = list(
#'       snapshotTimeOfDay = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_enable_add_on
lightsail_enable_add_on <- function(resourceName, addOnRequest) {
  op <- new_operation(
    name = "EnableAddOn",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$enable_add_on_input(resourceName = resourceName, addOnRequest = addOnRequest)
  output <- .lightsail$enable_add_on_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$enable_add_on <- lightsail_enable_add_on

#' Exports an Amazon Lightsail instance or block storage disk snapshot to
#' Amazon Elastic Compute Cloud (Amazon EC2)
#'
#' @description
#' Exports an Amazon Lightsail instance or block storage disk snapshot to
#' Amazon Elastic Compute Cloud (Amazon EC2). This operation results in an
#' export snapshot record that can be used with the
#' `create cloud formation stack` operation to create new Amazon EC2
#' instances.
#' 
#' Exported instance snapshots appear in Amazon EC2 as Amazon Machine
#' Images (AMIs), and the instance system disk appears as an Amazon Elastic
#' Block Store (Amazon EBS) volume. Exported disk snapshots appear in
#' Amazon EC2 as Amazon EBS volumes. Snapshots are exported to the same
#' Amazon Web Services Region in Amazon EC2 as the source Lightsail
#' snapshot.
#' 
#' The `export snapshot` operation supports tag-based access control via
#' resource tags applied to the resource identified by
#' `source snapshot name`. For more information, see the Lightsail Dev
#' Guide.
#' 
#' Use the `get instance snapshots` or `get disk snapshots` operations to
#' get a list of snapshots that you can export to Amazon EC2.
#'
#' @usage
#' lightsail_export_snapshot(sourceSnapshotName)
#'
#' @param sourceSnapshotName &#91;required&#93; The name of the instance or disk snapshot to be exported to Amazon EC2.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$export_snapshot(
#'   sourceSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_export_snapshot
lightsail_export_snapshot <- function(sourceSnapshotName) {
  op <- new_operation(
    name = "ExportSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$export_snapshot_input(sourceSnapshotName = sourceSnapshotName)
  output <- .lightsail$export_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$export_snapshot <- lightsail_export_snapshot

#' Returns the names of all active (not deleted) resources
#'
#' @description
#' Returns the names of all active (not deleted) resources.
#'
#' @usage
#' lightsail_get_active_names(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_active_names`][lightsail_get_active_names] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   activeNames = list(
#'     "string"
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_active_names(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_active_names
lightsail_get_active_names <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetActiveNames",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_active_names_input(pageToken = pageToken)
  output <- .lightsail$get_active_names_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_active_names <- lightsail_get_active_names

#' Returns information about the configured alarms
#'
#' @description
#' Returns information about the configured alarms. Specify an alarm name
#' in your request to return information about a specific alarm, or specify
#' a monitored resource name to return information about all alarms for a
#' specific resource.
#' 
#' An alarm is used to monitor a single metric for one of your resources.
#' When a metric condition is met, the alarm can notify you by email, SMS
#' text message, and a banner displayed on the Amazon Lightsail console.
#' For more information, see Alarms in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_alarms(alarmName, pageToken, monitoredResourceName)
#'
#' @param alarmName The name of the alarm.
#' 
#' Specify an alarm name to return information about a specific alarm.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_alarms`][lightsail_get_alarms] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#' @param monitoredResourceName The name of the Lightsail resource being monitored by the alarm.
#' 
#' Specify a monitored resource name to return information about all alarms
#' for a specific resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   alarms = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       supportCode = "string",
#'       monitoredResourceInfo = list(
#'         arn = "string",
#'         name = "string",
#'         resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate"
#'       ),
#'       comparisonOperator = "GreaterThanOrEqualToThreshold"|"GreaterThanThreshold"|"LessThanThreshold"|"LessThanOrEqualToThreshold",
#'       evaluationPeriods = 123,
#'       period = 123,
#'       threshold = 123.0,
#'       datapointsToAlarm = 123,
#'       treatMissingData = "breaching"|"notBreaching"|"ignore"|"missing",
#'       statistic = "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount",
#'       metricName = "CPUUtilization"|"NetworkIn"|"NetworkOut"|"StatusCheckFailed"|"StatusCheckFailed_Instance"|"StatusCheckFailed_System"|"ClientTLSNegotiationErrorCount"|"HealthyHostCount"|"UnhealthyHostCount"|"HTTPCode_LB_4XX_Count"|"HTTPCode_LB_5XX_Count"|"HTTPCode_Instance_2XX_Count"|"HTTPCode_Instance_3XX_Count"|"HTTPCode_Instance_4XX_Count"|"HTTPCode_Instance_5XX_Count"|"InstanceResponseTime"|"RejectedConnectionCount"|"RequestCount"|"DatabaseConnections"|"DiskQueueDepth"|"FreeStorageSpace"|"NetworkReceiveThroughput"|"NetworkTransmitThroughput"|"BurstCapacityTime"|"BurstCapacityPercentage",
#'       state = "OK"|"ALARM"|"INSUFFICIENT_DATA",
#'       unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'       contactProtocols = list(
#'         "Email"|"SMS"
#'       ),
#'       notificationTriggers = list(
#'         "OK"|"ALARM"|"INSUFFICIENT_DATA"
#'       ),
#'       notificationEnabled = TRUE|FALSE
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_alarms(
#'   alarmName = "string",
#'   pageToken = "string",
#'   monitoredResourceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_alarms
lightsail_get_alarms <- function(alarmName = NULL, pageToken = NULL, monitoredResourceName = NULL) {
  op <- new_operation(
    name = "GetAlarms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_alarms_input(alarmName = alarmName, pageToken = pageToken, monitoredResourceName = monitoredResourceName)
  output <- .lightsail$get_alarms_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_alarms <- lightsail_get_alarms

#' Returns the available automatic snapshots for an instance or disk
#'
#' @description
#' Returns the available automatic snapshots for an instance or disk. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_get_auto_snapshots(resourceName)
#'
#' @param resourceName &#91;required&#93; The name of the source instance or disk from which to get automatic
#' snapshot information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   resourceName = "string",
#'   resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'   autoSnapshots = list(
#'     list(
#'       date = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       status = "Success"|"Failed"|"InProgress"|"NotFound",
#'       fromAttachedDisks = list(
#'         list(
#'           path = "string",
#'           sizeInGb = 123
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_auto_snapshots(
#'   resourceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_auto_snapshots
lightsail_get_auto_snapshots <- function(resourceName) {
  op <- new_operation(
    name = "GetAutoSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_auto_snapshots_input(resourceName = resourceName)
  output <- .lightsail$get_auto_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_auto_snapshots <- lightsail_get_auto_snapshots

#' Returns the list of available instance images, or blueprints
#'
#' @description
#' Returns the list of available instance images, or *blueprints*. You can
#' use a blueprint to create a new instance already running a specific
#' operating system, as well as a preinstalled app or development stack.
#' The software each instance is running depends on the blueprint image you
#' choose.
#' 
#' Use active blueprints when creating new instances. Inactive blueprints
#' are listed to support customers with existing instances and are not
#' necessarily available to create new instances. Blueprints are marked
#' inactive when they become outdated due to operating system updates or
#' new application releases.
#'
#' @usage
#' lightsail_get_blueprints(includeInactive, pageToken)
#'
#' @param includeInactive A Boolean value indicating whether to include inactive results in your
#' request.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_blueprints`][lightsail_get_blueprints] request. If your results
#' are paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   blueprints = list(
#'     list(
#'       blueprintId = "string",
#'       name = "string",
#'       group = "string",
#'       type = "os"|"app",
#'       description = "string",
#'       isActive = TRUE|FALSE,
#'       minPower = 123,
#'       version = "string",
#'       versionCode = "string",
#'       productUrl = "string",
#'       licenseUrl = "string",
#'       platform = "LINUX_UNIX"|"WINDOWS"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_blueprints(
#'   includeInactive = TRUE|FALSE,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_blueprints
lightsail_get_blueprints <- function(includeInactive = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetBlueprints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_blueprints_input(includeInactive = includeInactive, pageToken = pageToken)
  output <- .lightsail$get_blueprints_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_blueprints <- lightsail_get_blueprints

#' Returns the list of bundles that are available for purchase
#'
#' @description
#' Returns the list of bundles that are available for purchase. A bundle
#' describes the specs for your virtual private server (or *instance*).
#'
#' @usage
#' lightsail_get_bundles(includeInactive, pageToken)
#'
#' @param includeInactive A Boolean value that indicates whether to include inactive bundle
#' results in your request.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_bundles`][lightsail_get_bundles] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   bundles = list(
#'     list(
#'       price = 123.0,
#'       cpuCount = 123,
#'       diskSizeInGb = 123,
#'       bundleId = "string",
#'       instanceType = "string",
#'       isActive = TRUE|FALSE,
#'       name = "string",
#'       power = 123,
#'       ramSizeInGb = 123.0,
#'       transferPerMonthInGb = 123,
#'       supportedPlatforms = list(
#'         "LINUX_UNIX"|"WINDOWS"
#'       )
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_bundles(
#'   includeInactive = TRUE|FALSE,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_bundles
lightsail_get_bundles <- function(includeInactive = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetBundles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_bundles_input(includeInactive = includeInactive, pageToken = pageToken)
  output <- .lightsail$get_bundles_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_bundles <- lightsail_get_bundles

#' Returns information about one or more Amazon Lightsail SSL/TLS
#' certificates
#'
#' @description
#' Returns information about one or more Amazon Lightsail SSL/TLS
#' certificates.
#' 
#' To get a summary of a certificate, ommit `includeCertificateDetails`
#' from your request. The response will include only the certificate Amazon
#' Resource Name (ARN), certificate name, domain name, and tags.
#'
#' @usage
#' lightsail_get_certificates(certificateStatuses,
#'   includeCertificateDetails, certificateName)
#'
#' @param certificateStatuses The status of the certificates for which to return information.
#' 
#' For example, specify `ISSUED` to return only certificates with an
#' `ISSUED` status.
#' 
#' When omitted, the response includes all of your certificates in the AWS
#' Region where the request is made, regardless of their current status.
#' @param includeCertificateDetails Indicates whether to include detailed information about the certificates
#' in the response.
#' 
#' When omitted, the response includes only the certificate names, Amazon
#' Resource Names (ARNs), domain names, and tags.
#' @param certificateName The name for the certificate for which to return information.
#' 
#' When omitted, the response includes all of your certificates in the AWS
#' Region where the request is made.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   certificates = list(
#'     list(
#'       certificateArn = "string",
#'       certificateName = "string",
#'       domainName = "string",
#'       certificateDetail = list(
#'         arn = "string",
#'         name = "string",
#'         domainName = "string",
#'         status = "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED",
#'         serialNumber = "string",
#'         subjectAlternativeNames = list(
#'           "string"
#'         ),
#'         domainValidationRecords = list(
#'           list(
#'             domainName = "string",
#'             resourceRecord = list(
#'               name = "string",
#'               type = "string",
#'               value = "string"
#'             )
#'           )
#'         ),
#'         requestFailureReason = "string",
#'         inUseResourceCount = 123,
#'         keyAlgorithm = "string",
#'         createdAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         issuedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         issuerCA = "string",
#'         notBefore = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         notAfter = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         eligibleToRenew = "string",
#'         renewalSummary = list(
#'           domainValidationRecords = list(
#'             list(
#'               domainName = "string",
#'               resourceRecord = list(
#'                 name = "string",
#'                 type = "string",
#'                 value = "string"
#'               )
#'             )
#'           ),
#'           renewalStatus = "PendingAutoRenewal"|"PendingValidation"|"Success"|"Failed",
#'           renewalStatusReason = "string",
#'           updatedAt = as.POSIXct(
#'             "2015-01-01"
#'           )
#'         ),
#'         revokedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         revocationReason = "string",
#'         tags = list(
#'           list(
#'             key = "string",
#'             value = "string"
#'           )
#'         ),
#'         supportCode = "string"
#'       ),
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_certificates(
#'   certificateStatuses = list(
#'     "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED"
#'   ),
#'   includeCertificateDetails = TRUE|FALSE,
#'   certificateName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_certificates
lightsail_get_certificates <- function(certificateStatuses = NULL, includeCertificateDetails = NULL, certificateName = NULL) {
  op <- new_operation(
    name = "GetCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_certificates_input(certificateStatuses = certificateStatuses, includeCertificateDetails = includeCertificateDetails, certificateName = certificateName)
  output <- .lightsail$get_certificates_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_certificates <- lightsail_get_certificates

#' Returns the CloudFormation stack record created as a result of the
#' create cloud formation stack operation
#'
#' @description
#' Returns the CloudFormation stack record created as a result of the
#' `create cloud formation stack` operation.
#' 
#' An AWS CloudFormation stack is used to create a new Amazon EC2 instance
#' from an exported Lightsail snapshot.
#'
#' @usage
#' lightsail_get_cloud_formation_stack_records(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial `GetClouFormationStackRecords`
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   cloudFormationStackRecords = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       state = "Started"|"Succeeded"|"Failed",
#'       sourceInfo = list(
#'         list(
#'           resourceType = "ExportSnapshotRecord",
#'           name = "string",
#'           arn = "string"
#'         )
#'       ),
#'       destinationInfo = list(
#'         id = "string",
#'         service = "string"
#'       )
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_cloud_formation_stack_records(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_cloud_formation_stack_records
lightsail_get_cloud_formation_stack_records <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetCloudFormationStackRecords",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_cloud_formation_stack_records_input(pageToken = pageToken)
  output <- .lightsail$get_cloud_formation_stack_records_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_cloud_formation_stack_records <- lightsail_get_cloud_formation_stack_records

#' Returns information about the configured contact methods
#'
#' @description
#' Returns information about the configured contact methods. Specify a
#' protocol in your request to return information about a specific contact
#' method.
#' 
#' A contact method is used to send you notifications about your Amazon
#' Lightsail resources. You can add one email address and one mobile phone
#' number contact method in each AWS Region. However, SMS text messaging is
#' not supported in some AWS Regions, and SMS text messages cannot be sent
#' to some countries/regions. For more information, see Notifications in
#' Amazon Lightsail.
#'
#' @usage
#' lightsail_get_contact_methods(protocols)
#'
#' @param protocols The protocols used to send notifications, such as `Email`, or `SMS`
#' (text messaging).
#' 
#' Specify a protocol in your request to return information about a
#' specific contact method protocol.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   contactMethods = list(
#'     list(
#'       contactEndpoint = "string",
#'       status = "PendingVerification"|"Valid"|"Invalid",
#'       protocol = "Email"|"SMS",
#'       name = "string",
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       supportCode = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_contact_methods(
#'   protocols = list(
#'     "Email"|"SMS"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_contact_methods
lightsail_get_contact_methods <- function(protocols = NULL) {
  op <- new_operation(
    name = "GetContactMethods",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_contact_methods_input(protocols = protocols)
  output <- .lightsail$get_contact_methods_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_contact_methods <- lightsail_get_contact_methods

#' Returns information about Amazon Lightsail containers, such as the
#' current version of the Lightsail Control (lightsailctl) plugin
#'
#' @description
#' Returns information about Amazon Lightsail containers, such as the
#' current version of the Lightsail Control (lightsailctl) plugin.
#'
#' @usage
#' lightsail_get_container_api_metadata()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   metadata = list(
#'     list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_container_api_metadata()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_api_metadata
lightsail_get_container_api_metadata <- function() {
  op <- new_operation(
    name = "GetContainerAPIMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_container_api_metadata_input()
  output <- .lightsail$get_container_api_metadata_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_api_metadata <- lightsail_get_container_api_metadata

#' Returns the container images that are registered to your Amazon
#' Lightsail container service
#'
#' @description
#' Returns the container images that are registered to your Amazon
#' Lightsail container service.
#' 
#' If you created a deployment on your Lightsail container service that
#' uses container images from a public registry like Docker Hub, those
#' images are not returned as part of this action. Those images are not
#' registered to your Lightsail container service.
#'
#' @usage
#' lightsail_get_container_images(serviceName)
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to return registered
#' container images.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   containerImages = list(
#'     list(
#'       image = "string",
#'       digest = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_container_images(
#'   serviceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_images
lightsail_get_container_images <- function(serviceName) {
  op <- new_operation(
    name = "GetContainerImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_container_images_input(serviceName = serviceName)
  output <- .lightsail$get_container_images_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_images <- lightsail_get_container_images

#' Returns the log events of a container of your Amazon Lightsail container
#' service
#'
#' @description
#' Returns the log events of a container of your Amazon Lightsail container
#' service.
#' 
#' If your container service has more than one node (i.e., a scale greater
#' than 1), then the log events that are returned for the specified
#' container are merged from all nodes on your container service.
#' 
#' Container logs are retained for a certain amount of time. For more
#' information, see [Amazon Lightsail endpoints and
#' quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in
#' the *AWS General Reference*.
#'
#' @usage
#' lightsail_get_container_log(serviceName, containerName, startTime,
#'   endTime, filterPattern, pageToken)
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to get a container log.
#' @param containerName &#91;required&#93; The name of the container that is either running or previously ran on
#' the container service for which to return a log.
#' @param startTime The start of the time interval for which to get log data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, specify `1538424000` as the start time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param endTime The end of the time interval for which to get log data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 9
#'     PM UTC, specify `1538427600` as the end time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param filterPattern The pattern to use to filter the returned log events to a specific term.
#' 
#' The following are a few examples of filter patterns that you can
#' specify:
#' 
#' -   To return all log events, specify a filter pattern of `""`.
#' 
#' -   To exclude log events that contain the `ERROR` term, and return all
#'     other log events, specify a filter pattern of `"-ERROR"`.
#' 
#' -   To return log events that contain the `ERROR` term, specify a filter
#'     pattern of `"ERROR"`.
#' 
#' -   To return log events that contain both the `ERROR` and `Exception`
#'     terms, specify a filter pattern of `"ERROR Exception"`.
#' 
#' -   To return log events that contain the `ERROR` *or* the `Exception`
#'     term, specify a filter pattern of `"?ERROR ?Exception"`.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_container_log`][lightsail_get_container_log] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   logEvents = list(
#'     list(
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       message = "string"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_container_log(
#'   serviceName = "string",
#'   containerName = "string",
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   filterPattern = "string",
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_log
lightsail_get_container_log <- function(serviceName, containerName, startTime = NULL, endTime = NULL, filterPattern = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetContainerLog",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_container_log_input(serviceName = serviceName, containerName = containerName, startTime = startTime, endTime = endTime, filterPattern = filterPattern, pageToken = pageToken)
  output <- .lightsail$get_container_log_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_log <- lightsail_get_container_log

#' Returns the deployments for your Amazon Lightsail container service
#'
#' @description
#' Returns the deployments for your Amazon Lightsail container service
#' 
#' A deployment specifies the settings, such as the ports and launch
#' command, of containers that are deployed to your container service.
#' 
#' The deployments are ordered by version in ascending order. The newest
#' version is listed at the top of the response.
#' 
#' A set number of deployments are kept before the oldest one is replaced
#' with the newest one. For more information, see [Amazon Lightsail
#' endpoints and
#' quotas](https://docs.aws.amazon.com/general/latest/gr/lightsail.html) in
#' the *AWS General Reference*.
#'
#' @usage
#' lightsail_get_container_service_deployments(serviceName)
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to return deployments.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deployments = list(
#'     list(
#'       version = 123,
#'       state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'       containers = list(
#'         list(
#'           image = "string",
#'           command = list(
#'             "string"
#'           ),
#'           environment = list(
#'             "string"
#'           ),
#'           ports = list(
#'             "HTTP"|"HTTPS"|"TCP"|"UDP"
#'           )
#'         )
#'       ),
#'       publicEndpoint = list(
#'         containerName = "string",
#'         containerPort = 123,
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           unhealthyThreshold = 123,
#'           timeoutSeconds = 123,
#'           intervalSeconds = 123,
#'           path = "string",
#'           successCodes = "string"
#'         )
#'       ),
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_container_service_deployments(
#'   serviceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_service_deployments
lightsail_get_container_service_deployments <- function(serviceName) {
  op <- new_operation(
    name = "GetContainerServiceDeployments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_container_service_deployments_input(serviceName = serviceName)
  output <- .lightsail$get_container_service_deployments_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_service_deployments <- lightsail_get_container_service_deployments

#' Returns the data points of a specific metric of your Amazon Lightsail
#' container service
#'
#' @description
#' Returns the data points of a specific metric of your Amazon Lightsail
#' container service.
#' 
#' Metrics report the utilization of your resources. Monitor and collect
#' metric data regularly to maintain the reliability, availability, and
#' performance of your resources.
#'
#' @usage
#' lightsail_get_container_service_metric_data(serviceName, metricName,
#'   startTime, endTime, period, statistics)
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to get metric data.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid container service metric names are listed below, along with the
#' most useful statistics to include in your request, and the published
#' unit value.
#' 
#' -   `CPUUtilization` - The average percentage of compute units that are
#'     currently in use across all nodes of the container service. This
#'     metric identifies the processing power required to run containers on
#'     each node of the container service.
#' 
#'     Statistics: The most useful statistics are `Maximum` and `Average`.
#' 
#'     Unit: The published unit is `Percent`.
#' 
#' -   `MemoryUtilization` - The average percentage of available memory
#'     that is currently in use across all nodes of the container service.
#'     This metric identifies the memory required to run containers on each
#'     node of the container service.
#' 
#'     Statistics: The most useful statistics are `Maximum` and `Average`.
#' 
#'     Unit: The published unit is `Percent`.
#' @param startTime &#91;required&#93; The start time of the time period.
#' @param endTime &#91;required&#93; The end time of the time period.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' 
#' All container service metric data is available in 5-minute (300 seconds)
#' granularity.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of `Sum` / `SampleCount` during the specified
#'     period. By comparing this statistic with the `Minimum` and `Maximum`
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the `Minimum` and `Maximum` values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   metricName = "CPUUtilization"|"MemoryUtilization",
#'   metricData = list(
#'     list(
#'       average = 123.0,
#'       maximum = 123.0,
#'       minimum = 123.0,
#'       sampleCount = 123.0,
#'       sum = 123.0,
#'       timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_container_service_metric_data(
#'   serviceName = "string",
#'   metricName = "CPUUtilization"|"MemoryUtilization",
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   period = 123,
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_service_metric_data
lightsail_get_container_service_metric_data <- function(serviceName, metricName, startTime, endTime, period, statistics) {
  op <- new_operation(
    name = "GetContainerServiceMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_container_service_metric_data_input(serviceName = serviceName, metricName = metricName, startTime = startTime, endTime = endTime, period = period, statistics = statistics)
  output <- .lightsail$get_container_service_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_service_metric_data <- lightsail_get_container_service_metric_data

#' Returns the list of powers that can be specified for your Amazon
#' Lightsail container services
#'
#' @description
#' Returns the list of powers that can be specified for your Amazon
#' Lightsail container services.
#' 
#' The power specifies the amount of memory, the number of vCPUs, and the
#' base price of the container service.
#'
#' @usage
#' lightsail_get_container_service_powers()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   powers = list(
#'     list(
#'       powerId = "string",
#'       price = 123.0,
#'       cpuCount = 123.0,
#'       ramSizeInGb = 123.0,
#'       name = "string",
#'       isActive = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_container_service_powers()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_service_powers
lightsail_get_container_service_powers <- function() {
  op <- new_operation(
    name = "GetContainerServicePowers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_container_service_powers_input()
  output <- .lightsail$get_container_service_powers_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_service_powers <- lightsail_get_container_service_powers

#' Returns information about one or more of your Amazon Lightsail container
#' services
#'
#' @description
#' Returns information about one or more of your Amazon Lightsail container
#' services.
#'
#' @usage
#' lightsail_get_container_services(serviceName)
#'
#' @param serviceName The name of the container service for which to return information.
#' 
#' When omitted, the response includes all of your container services in
#' the AWS Region where the request is made.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   containerServices = list(
#'     list(
#'       containerServiceName = "string",
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
#'       powerId = "string",
#'       state = "PENDING"|"READY"|"RUNNING"|"UPDATING"|"DELETING"|"DISABLED",
#'       scale = 123,
#'       currentDeployment = list(
#'         version = 123,
#'         state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'         containers = list(
#'           list(
#'             image = "string",
#'             command = list(
#'               "string"
#'             ),
#'             environment = list(
#'               "string"
#'             ),
#'             ports = list(
#'               "HTTP"|"HTTPS"|"TCP"|"UDP"
#'             )
#'           )
#'         ),
#'         publicEndpoint = list(
#'           containerName = "string",
#'           containerPort = 123,
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             unhealthyThreshold = 123,
#'             timeoutSeconds = 123,
#'             intervalSeconds = 123,
#'             path = "string",
#'             successCodes = "string"
#'           )
#'         ),
#'         createdAt = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       nextDeployment = list(
#'         version = 123,
#'         state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'         containers = list(
#'           list(
#'             image = "string",
#'             command = list(
#'               "string"
#'             ),
#'             environment = list(
#'               "string"
#'             ),
#'             ports = list(
#'               "HTTP"|"HTTPS"|"TCP"|"UDP"
#'             )
#'           )
#'         ),
#'         publicEndpoint = list(
#'           containerName = "string",
#'           containerPort = 123,
#'           healthCheck = list(
#'             healthyThreshold = 123,
#'             unhealthyThreshold = 123,
#'             timeoutSeconds = 123,
#'             intervalSeconds = 123,
#'             path = "string",
#'             successCodes = "string"
#'           )
#'         ),
#'         createdAt = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       isDisabled = TRUE|FALSE,
#'       principalArn = "string",
#'       privateDomainName = "string",
#'       publicDomainNames = list(
#'         list(
#'           "string"
#'         )
#'       ),
#'       url = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_container_services(
#'   serviceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_container_services
lightsail_get_container_services <- function(serviceName = NULL) {
  op <- new_operation(
    name = "GetContainerServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_container_services_input(serviceName = serviceName)
  output <- .lightsail$get_container_services_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_container_services <- lightsail_get_container_services

#' Returns information about a specific block storage disk
#'
#' @description
#' Returns information about a specific block storage disk.
#'
#' @usage
#' lightsail_get_disk(diskName)
#'
#' @param diskName &#91;required&#93; The name of the disk (e.g., `my-disk`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   disk = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     addOns = list(
#'       list(
#'         name = "string",
#'         status = "string",
#'         snapshotTimeOfDay = "string",
#'         nextSnapshotTimeOfDay = "string"
#'       )
#'     ),
#'     sizeInGb = 123,
#'     isSystemDisk = TRUE|FALSE,
#'     iops = 123,
#'     path = "string",
#'     state = "pending"|"error"|"available"|"in-use"|"unknown",
#'     attachedTo = "string",
#'     isAttached = TRUE|FALSE,
#'     attachmentState = "string",
#'     gbInUse = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_disk(
#'   diskName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk
lightsail_get_disk <- function(diskName) {
  op <- new_operation(
    name = "GetDisk",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disk_input(diskName = diskName)
  output <- .lightsail$get_disk_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk <- lightsail_get_disk

#' Returns information about a specific block storage disk snapshot
#'
#' @description
#' Returns information about a specific block storage disk snapshot.
#'
#' @usage
#' lightsail_get_disk_snapshot(diskSnapshotName)
#'
#' @param diskSnapshotName &#91;required&#93; The name of the disk snapshot (e.g., `my-disk-snapshot`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   diskSnapshot = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     sizeInGb = 123,
#'     state = "pending"|"completed"|"error"|"unknown",
#'     progress = "string",
#'     fromDiskName = "string",
#'     fromDiskArn = "string",
#'     fromInstanceName = "string",
#'     fromInstanceArn = "string",
#'     isFromAutoSnapshot = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_disk_snapshot(
#'   diskSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk_snapshot
lightsail_get_disk_snapshot <- function(diskSnapshotName) {
  op <- new_operation(
    name = "GetDiskSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disk_snapshot_input(diskSnapshotName = diskSnapshotName)
  output <- .lightsail$get_disk_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk_snapshot <- lightsail_get_disk_snapshot

#' Returns information about all block storage disk snapshots in your AWS
#' account and region
#'
#' @description
#' Returns information about all block storage disk snapshots in your AWS
#' account and region.
#'
#' @usage
#' lightsail_get_disk_snapshots(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_disk_snapshots`][lightsail_get_disk_snapshots] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   diskSnapshots = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       sizeInGb = 123,
#'       state = "pending"|"completed"|"error"|"unknown",
#'       progress = "string",
#'       fromDiskName = "string",
#'       fromDiskArn = "string",
#'       fromInstanceName = "string",
#'       fromInstanceArn = "string",
#'       isFromAutoSnapshot = TRUE|FALSE
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_disk_snapshots(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disk_snapshots
lightsail_get_disk_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDiskSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disk_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_disk_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disk_snapshots <- lightsail_get_disk_snapshots

#' Returns information about all block storage disks in your AWS account
#' and region
#'
#' @description
#' Returns information about all block storage disks in your AWS account
#' and region.
#'
#' @usage
#' lightsail_get_disks(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_disks`][lightsail_get_disks] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   disks = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       addOns = list(
#'         list(
#'           name = "string",
#'           status = "string",
#'           snapshotTimeOfDay = "string",
#'           nextSnapshotTimeOfDay = "string"
#'         )
#'       ),
#'       sizeInGb = 123,
#'       isSystemDisk = TRUE|FALSE,
#'       iops = 123,
#'       path = "string",
#'       state = "pending"|"error"|"available"|"in-use"|"unknown",
#'       attachedTo = "string",
#'       isAttached = TRUE|FALSE,
#'       attachmentState = "string",
#'       gbInUse = 123
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_disks(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_disks
lightsail_get_disks <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDisks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_disks_input(pageToken = pageToken)
  output <- .lightsail$get_disks_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_disks <- lightsail_get_disks

#' Returns the list bundles that can be applied to you Amazon Lightsail
#' content delivery network (CDN) distributions
#'
#' @description
#' Returns the list bundles that can be applied to you Amazon Lightsail
#' content delivery network (CDN) distributions.
#' 
#' A distribution bundle specifies the monthly network transfer quota and
#' monthly cost of your dsitribution.
#'
#' @usage
#' lightsail_get_distribution_bundles()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   bundles = list(
#'     list(
#'       bundleId = "string",
#'       name = "string",
#'       price = 123.0,
#'       transferPerMonthInGb = 123,
#'       isActive = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_distribution_bundles()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_distribution_bundles
lightsail_get_distribution_bundles <- function() {
  op <- new_operation(
    name = "GetDistributionBundles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_distribution_bundles_input()
  output <- .lightsail$get_distribution_bundles_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distribution_bundles <- lightsail_get_distribution_bundles

#' Returns the timestamp and status of the last cache reset of a specific
#' Amazon Lightsail content delivery network (CDN) distribution
#'
#' @description
#' Returns the timestamp and status of the last cache reset of a specific
#' Amazon Lightsail content delivery network (CDN) distribution.
#'
#' @usage
#' lightsail_get_distribution_latest_cache_reset(distributionName)
#'
#' @param distributionName The name of the distribution for which to return the timestamp of the
#' last cache reset.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' 
#' When omitted, the response includes the latest cache reset timestamp of
#' all your distributions.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   status = "string",
#'   createTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_distribution_latest_cache_reset(
#'   distributionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_distribution_latest_cache_reset
lightsail_get_distribution_latest_cache_reset <- function(distributionName = NULL) {
  op <- new_operation(
    name = "GetDistributionLatestCacheReset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_distribution_latest_cache_reset_input(distributionName = distributionName)
  output <- .lightsail$get_distribution_latest_cache_reset_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distribution_latest_cache_reset <- lightsail_get_distribution_latest_cache_reset

#' Returns the data points of a specific metric for an Amazon Lightsail
#' content delivery network (CDN) distribution
#'
#' @description
#' Returns the data points of a specific metric for an Amazon Lightsail
#' content delivery network (CDN) distribution.
#' 
#' Metrics report the utilization of your resources, and the error counts
#' generated by them. Monitor and collect metric data regularly to maintain
#' the reliability, availability, and performance of your resources.
#'
#' @usage
#' lightsail_get_distribution_metric_data(distributionName, metricName,
#'   startTime, endTime, period, unit, statistics)
#'
#' @param distributionName &#91;required&#93; The name of the distribution for which to get metric data.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid distribution metric names are listed below, along with the most
#' useful `statistics` to include in your request, and the published `unit`
#' value.
#' 
#' -   **`Requests`** - The total number of viewer requests received by
#'     your Lightsail distribution, for all HTTP methods, and for both HTTP
#'     and HTTPS requests.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `None`.
#' 
#' -   **`BytesDownloaded`** - The number of bytes downloaded by viewers
#'     for GET, HEAD, and OPTIONS requests.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `None`.
#' 
#' -   **`BytesUploaded `** - The number of bytes uploaded to your origin
#'     by your Lightsail distribution, using POST and PUT requests.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `None`.
#' 
#' -   **`TotalErrorRate`** - The percentage of all viewer requests for
#'     which the response's HTTP status code was 4xx or 5xx.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`4xxErrorRate`** - The percentage of all viewer requests for which
#'     the response's HTTP status cod was 4xx. In these cases, the client
#'     or client viewer may have made an error. For example, a status code
#'     of 404 (Not Found) means that the client requested an object that
#'     could not be found.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`5xxErrorRate`** - The percentage of all viewer requests for which
#'     the response's HTTP status code was 5xx. In these cases, the origin
#'     server did not satisfy the requests. For example, a status code of
#'     503 (Service Unavailable) means that the origin server is currently
#'     unavailable.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' @param startTime &#91;required&#93; The start of the time interval for which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, specify `1538424000` as the start time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param endTime &#91;required&#93; The end of the time interval for which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 9
#'     PM UTC, specify `1538427600` as the end time.
#' 
#' You can convert a human-friendly time to Unix time format using a
#' converter like [Epoch converter](https://www.epochconverter.com/).
#' @param period &#91;required&#93; The granularity, in seconds, for the metric data points that will be
#' returned.
#' @param unit &#91;required&#93; The unit for the metric data request.
#' 
#' Valid units depend on the metric data being requested. For the valid
#' units with each available metric, see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   metricName = "Requests"|"BytesDownloaded"|"BytesUploaded"|"TotalErrorRate"|"Http4xxErrorRate"|"Http5xxErrorRate",
#'   metricData = list(
#'     list(
#'       average = 123.0,
#'       maximum = 123.0,
#'       minimum = 123.0,
#'       sampleCount = 123.0,
#'       sum = 123.0,
#'       timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_distribution_metric_data(
#'   distributionName = "string",
#'   metricName = "Requests"|"BytesDownloaded"|"BytesUploaded"|"TotalErrorRate"|"Http4xxErrorRate"|"Http5xxErrorRate",
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   period = 123,
#'   unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_distribution_metric_data
lightsail_get_distribution_metric_data <- function(distributionName, metricName, startTime, endTime, period, unit, statistics) {
  op <- new_operation(
    name = "GetDistributionMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_distribution_metric_data_input(distributionName = distributionName, metricName = metricName, startTime = startTime, endTime = endTime, period = period, unit = unit, statistics = statistics)
  output <- .lightsail$get_distribution_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distribution_metric_data <- lightsail_get_distribution_metric_data

#' Returns information about one or more of your Amazon Lightsail content
#' delivery network (CDN) distributions
#'
#' @description
#' Returns information about one or more of your Amazon Lightsail content
#' delivery network (CDN) distributions.
#'
#' @usage
#' lightsail_get_distributions(distributionName, pageToken)
#'
#' @param distributionName The name of the distribution for which to return information.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' 
#' When omitted, the response includes all of your distributions in the AWS
#' Region where the request is made.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_distributions`][lightsail_get_distributions] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   distributions = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       alternativeDomainNames = list(
#'         "string"
#'       ),
#'       status = "string",
#'       isEnabled = TRUE|FALSE,
#'       domainName = "string",
#'       bundleId = "string",
#'       certificateName = "string",
#'       origin = list(
#'         name = "string",
#'         resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2",
#'         protocolPolicy = "http-only"|"https-only"
#'       ),
#'       originPublicDNS = "string",
#'       defaultCacheBehavior = list(
#'         behavior = "dont-cache"|"cache"
#'       ),
#'       cacheBehaviorSettings = list(
#'         defaultTTL = 123,
#'         minimumTTL = 123,
#'         maximumTTL = 123,
#'         allowedHTTPMethods = "string",
#'         cachedHTTPMethods = "string",
#'         forwardedCookies = list(
#'           option = "none"|"allow-list"|"all",
#'           cookiesAllowList = list(
#'             "string"
#'           )
#'         ),
#'         forwardedHeaders = list(
#'           option = "none"|"allow-list"|"all",
#'           headersAllowList = list(
#'             "Accept"|"Accept-Charset"|"Accept-Datetime"|"Accept-Encoding"|"Accept-Language"|"Authorization"|"CloudFront-Forwarded-Proto"|"CloudFront-Is-Desktop-Viewer"|"CloudFront-Is-Mobile-Viewer"|"CloudFront-Is-SmartTV-Viewer"|"CloudFront-Is-Tablet-Viewer"|"CloudFront-Viewer-Country"|"Host"|"Origin"|"Referer"
#'           )
#'         ),
#'         forwardedQueryStrings = list(
#'           option = TRUE|FALSE,
#'           queryStringsAllowList = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       cacheBehaviors = list(
#'         list(
#'           path = "string",
#'           behavior = "dont-cache"|"cache"
#'         )
#'       ),
#'       ableToUpdateBundle = TRUE|FALSE,
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_distributions(
#'   distributionName = "string",
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_distributions
lightsail_get_distributions <- function(distributionName = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetDistributions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_distributions_input(distributionName = distributionName, pageToken = pageToken)
  output <- .lightsail$get_distributions_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_distributions <- lightsail_get_distributions

#' Returns information about a specific domain recordset
#'
#' @description
#' Returns information about a specific domain recordset.
#'
#' @usage
#' lightsail_get_domain(domainName)
#'
#' @param domainName &#91;required&#93; The domain name for which your want to return information about.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   domain = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     domainEntries = list(
#'       list(
#'         id = "string",
#'         name = "string",
#'         target = "string",
#'         isAlias = TRUE|FALSE,
#'         type = "string",
#'         options = list(
#'           "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_domain(
#'   domainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_domain
lightsail_get_domain <- function(domainName) {
  op <- new_operation(
    name = "GetDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_domain_input(domainName = domainName)
  output <- .lightsail$get_domain_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_domain <- lightsail_get_domain

#' Returns a list of all domains in the user's account
#'
#' @description
#' Returns a list of all domains in the user's account.
#'
#' @usage
#' lightsail_get_domains(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_domains`][lightsail_get_domains] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   domains = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       domainEntries = list(
#'         list(
#'           id = "string",
#'           name = "string",
#'           target = "string",
#'           isAlias = TRUE|FALSE,
#'           type = "string",
#'           options = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_domains(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_domains
lightsail_get_domains <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_domains_input(pageToken = pageToken)
  output <- .lightsail$get_domains_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_domains <- lightsail_get_domains

#' Returns the export snapshot record created as a result of the export
#' snapshot operation
#'
#' @description
#' Returns the export snapshot record created as a result of the
#' `export snapshot` operation.
#' 
#' An export snapshot record can be used to create a new Amazon EC2
#' instance and its related resources with the
#' `create cloud formation stack` operation.
#'
#' @usage
#' lightsail_get_export_snapshot_records(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_export_snapshot_records`][lightsail_get_export_snapshot_records]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   exportSnapshotRecords = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       state = "Started"|"Succeeded"|"Failed",
#'       sourceInfo = list(
#'         resourceType = "InstanceSnapshot"|"DiskSnapshot",
#'         createdAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         name = "string",
#'         arn = "string",
#'         fromResourceName = "string",
#'         fromResourceArn = "string",
#'         instanceSnapshotInfo = list(
#'           fromBundleId = "string",
#'           fromBlueprintId = "string",
#'           fromDiskInfo = list(
#'             list(
#'               name = "string",
#'               path = "string",
#'               sizeInGb = 123,
#'               isSystemDisk = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         diskSnapshotInfo = list(
#'           sizeInGb = 123
#'         )
#'       ),
#'       destinationInfo = list(
#'         id = "string",
#'         service = "string"
#'       )
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_export_snapshot_records(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_export_snapshot_records
lightsail_get_export_snapshot_records <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetExportSnapshotRecords",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_export_snapshot_records_input(pageToken = pageToken)
  output <- .lightsail$get_export_snapshot_records_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_export_snapshot_records <- lightsail_get_export_snapshot_records

#' Returns information about a specific Amazon Lightsail instance, which is
#' a virtual private server
#'
#' @description
#' Returns information about a specific Amazon Lightsail instance, which is
#' a virtual private server.
#'
#' @usage
#' lightsail_get_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instance = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     blueprintId = "string",
#'     blueprintName = "string",
#'     bundleId = "string",
#'     addOns = list(
#'       list(
#'         name = "string",
#'         status = "string",
#'         snapshotTimeOfDay = "string",
#'         nextSnapshotTimeOfDay = "string"
#'       )
#'     ),
#'     isStaticIp = TRUE|FALSE,
#'     privateIpAddress = "string",
#'     publicIpAddress = "string",
#'     ipv6Address = "string",
#'     hardware = list(
#'       cpuCount = 123,
#'       disks = list(
#'         list(
#'           name = "string",
#'           arn = "string",
#'           supportCode = "string",
#'           createdAt = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           location = list(
#'             availabilityZone = "string",
#'             regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'           ),
#'           resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'           tags = list(
#'             list(
#'               key = "string",
#'               value = "string"
#'             )
#'           ),
#'           addOns = list(
#'             list(
#'               name = "string",
#'               status = "string",
#'               snapshotTimeOfDay = "string",
#'               nextSnapshotTimeOfDay = "string"
#'             )
#'           ),
#'           sizeInGb = 123,
#'           isSystemDisk = TRUE|FALSE,
#'           iops = 123,
#'           path = "string",
#'           state = "pending"|"error"|"available"|"in-use"|"unknown",
#'           attachedTo = "string",
#'           isAttached = TRUE|FALSE,
#'           attachmentState = "string",
#'           gbInUse = 123
#'         )
#'       ),
#'       ramSizeInGb = 123.0
#'     ),
#'     networking = list(
#'       monthlyTransfer = list(
#'         gbPerMonthAllocated = 123
#'       ),
#'       ports = list(
#'         list(
#'           fromPort = 123,
#'           toPort = 123,
#'           protocol = "tcp"|"all"|"udp"|"icmp",
#'           accessFrom = "string",
#'           accessType = "Public"|"Private",
#'           commonName = "string",
#'           accessDirection = "inbound"|"outbound",
#'           cidrs = list(
#'             "string"
#'           ),
#'           cidrListAliases = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     state = list(
#'       code = 123,
#'       name = "string"
#'     ),
#'     username = "string",
#'     sshKeyName = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance
lightsail_get_instance <- function(instanceName) {
  op <- new_operation(
    name = "GetInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_input(instanceName = instanceName)
  output <- .lightsail$get_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance <- lightsail_get_instance

#' Returns temporary SSH keys you can use to connect to a specific virtual
#' private server, or instance
#'
#' @description
#' Returns temporary SSH keys you can use to connect to a specific virtual
#' private server, or *instance*.
#' 
#' The `get instance access details` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' `instance name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_get_instance_access_details(instanceName, protocol)
#'
#' @param instanceName &#91;required&#93; The name of the instance to access.
#' @param protocol The protocol to use to connect to your instance. Defaults to `ssh`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   accessDetails = list(
#'     certKey = "string",
#'     expiresAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ipAddress = "string",
#'     password = "string",
#'     passwordData = list(
#'       ciphertext = "string",
#'       keyPairName = "string"
#'     ),
#'     privateKey = "string",
#'     protocol = "ssh"|"rdp",
#'     instanceName = "string",
#'     username = "string",
#'     hostKeys = list(
#'       list(
#'         algorithm = "string",
#'         publicKey = "string",
#'         witnessedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         fingerprintSHA1 = "string",
#'         fingerprintSHA256 = "string",
#'         notValidBefore = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         notValidAfter = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_access_details(
#'   instanceName = "string",
#'   protocol = "ssh"|"rdp"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_access_details
lightsail_get_instance_access_details <- function(instanceName, protocol = NULL) {
  op <- new_operation(
    name = "GetInstanceAccessDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_access_details_input(instanceName = instanceName, protocol = protocol)
  output <- .lightsail$get_instance_access_details_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_access_details <- lightsail_get_instance_access_details

#' Returns the data points for the specified Amazon Lightsail instance
#' metric, given an instance name
#'
#' @description
#' Returns the data points for the specified Amazon Lightsail instance
#' metric, given an instance name.
#' 
#' Metrics report the utilization of your resources, and the error counts
#' generated by them. Monitor and collect metric data regularly to maintain
#' the reliability, availability, and performance of your resources.
#'
#' @usage
#' lightsail_get_instance_metric_data(instanceName, metricName, period,
#'   startTime, endTime, unit, statistics)
#'
#' @param instanceName &#91;required&#93; The name of the instance for which you want to get metrics data.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid instance metric names are listed below, along with the most useful
#' `statistics` to include in your request, and the published `unit` value.
#' 
#' -   **`BurstCapacityPercentage`** - The percentage of CPU performance
#'     available for your instance to burst above its baseline. Your
#'     instance continuously accrues and consumes burst capacity. Burst
#'     capacity stops accruing when your instance's
#'     `BurstCapacityPercentage` reaches 100%. For more information, see
#'     Viewing instance burst capacity in Amazon Lightsail.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`BurstCapacityTime`** - The available amount of time for your
#'     instance to burst at 100% CPU utilization. Your instance
#'     continuously accrues and consumes burst capacity. Burst capacity
#'     time stops accruing when your instance's `BurstCapacityPercentage`
#'     metric reaches 100%.
#' 
#'     Burst capacity time is consumed at the full rate only when your
#'     instance operates at 100% CPU utilization. For example, if your
#'     instance operates at 50% CPU utilization in the burstable zone for a
#'     5-minute period, then it consumes CPU burst capacity minutes at a
#'     50% rate in that period. Your instance consumed 2 minutes and 30
#'     seconds of CPU burst capacity minutes in the 5-minute period. For
#'     more information, see Viewing instance burst capacity in Amazon
#'     Lightsail.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Seconds`.
#' 
#' -   **`CPUUtilization`** - The percentage of allocated compute units
#'     that are currently in use on the instance. This metric identifies
#'     the processing power to run the applications on the instance. Tools
#'     in your operating system can show a lower percentage than Lightsail
#'     when the instance is not allocated a full processor core.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`NetworkIn`** - The number of bytes received on all network
#'     interfaces by the instance. This metric identifies the volume of
#'     incoming network traffic to the instance. The number reported is the
#'     number of bytes received during the period. Because this metric is
#'     reported in 5-minute intervals, divide the reported number by 300 to
#'     find Bytes/second.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Bytes`.
#' 
#' -   **`NetworkOut`** - The number of bytes sent out on all network
#'     interfaces by the instance. This metric identifies the volume of
#'     outgoing network traffic from the instance. The number reported is
#'     the number of bytes sent during the period. Because this metric is
#'     reported in 5-minute intervals, divide the reported number by 300 to
#'     find Bytes/second.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Bytes`.
#' 
#' -   **`StatusCheckFailed`** - Reports whether the instance passed or
#'     failed both the instance status check and the system status check.
#'     This metric can be either 0 (passed) or 1 (failed). This metric data
#'     is available in 1-minute (60 seconds) granularity.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`StatusCheckFailed_Instance`** - Reports whether the instance
#'     passed or failed the instance status check. This metric can be
#'     either 0 (passed) or 1 (failed). This metric data is available in
#'     1-minute (60 seconds) granularity.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`StatusCheckFailed_System`** - Reports whether the instance passed
#'     or failed the system status check. This metric can be either 0
#'     (passed) or 1 (failed). This metric data is available in 1-minute
#'     (60 seconds) granularity.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' 
#' The `StatusCheckFailed`, `StatusCheckFailed_Instance`, and
#' `StatusCheckFailed_System` instance metric data is available in 1-minute
#' (60 seconds) granularity. All other instance metric data is available in
#' 5-minute (300 seconds) granularity.
#' @param startTime &#91;required&#93; The start time of the time period.
#' @param endTime &#91;required&#93; The end time of the time period.
#' @param unit &#91;required&#93; The unit for the metric data request. Valid units depend on the metric
#' data being requested. For the valid units to specify with each available
#' metric, see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   metricName = "CPUUtilization"|"NetworkIn"|"NetworkOut"|"StatusCheckFailed"|"StatusCheckFailed_Instance"|"StatusCheckFailed_System"|"BurstCapacityTime"|"BurstCapacityPercentage",
#'   metricData = list(
#'     list(
#'       average = 123.0,
#'       maximum = 123.0,
#'       minimum = 123.0,
#'       sampleCount = 123.0,
#'       sum = 123.0,
#'       timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_metric_data(
#'   instanceName = "string",
#'   metricName = "CPUUtilization"|"NetworkIn"|"NetworkOut"|"StatusCheckFailed"|"StatusCheckFailed_Instance"|"StatusCheckFailed_System"|"BurstCapacityTime"|"BurstCapacityPercentage",
#'   period = 123,
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_metric_data
lightsail_get_instance_metric_data <- function(instanceName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetInstanceMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_metric_data_input(instanceName = instanceName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_instance_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_metric_data <- lightsail_get_instance_metric_data

#' Returns the firewall port states for a specific Amazon Lightsail
#' instance, the IP addresses allowed to connect to the instance through
#' the ports, and the protocol
#'
#' @description
#' Returns the firewall port states for a specific Amazon Lightsail
#' instance, the IP addresses allowed to connect to the instance through
#' the ports, and the protocol.
#'
#' @usage
#' lightsail_get_instance_port_states(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance for which to return firewall port states.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   portStates = list(
#'     list(
#'       fromPort = 123,
#'       toPort = 123,
#'       protocol = "tcp"|"all"|"udp"|"icmp",
#'       state = "open"|"closed",
#'       cidrs = list(
#'         "string"
#'       ),
#'       cidrListAliases = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_port_states(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_port_states
lightsail_get_instance_port_states <- function(instanceName) {
  op <- new_operation(
    name = "GetInstancePortStates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_port_states_input(instanceName = instanceName)
  output <- .lightsail$get_instance_port_states_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_port_states <- lightsail_get_instance_port_states

#' Returns information about a specific instance snapshot
#'
#' @description
#' Returns information about a specific instance snapshot.
#'
#' @usage
#' lightsail_get_instance_snapshot(instanceSnapshotName)
#'
#' @param instanceSnapshotName &#91;required&#93; The name of the snapshot for which you are requesting information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instanceSnapshot = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     state = "pending"|"error"|"available",
#'     progress = "string",
#'     fromAttachedDisks = list(
#'       list(
#'         name = "string",
#'         arn = "string",
#'         supportCode = "string",
#'         createdAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         location = list(
#'           availabilityZone = "string",
#'           regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'         ),
#'         resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'         tags = list(
#'           list(
#'             key = "string",
#'             value = "string"
#'           )
#'         ),
#'         addOns = list(
#'           list(
#'             name = "string",
#'             status = "string",
#'             snapshotTimeOfDay = "string",
#'             nextSnapshotTimeOfDay = "string"
#'           )
#'         ),
#'         sizeInGb = 123,
#'         isSystemDisk = TRUE|FALSE,
#'         iops = 123,
#'         path = "string",
#'         state = "pending"|"error"|"available"|"in-use"|"unknown",
#'         attachedTo = "string",
#'         isAttached = TRUE|FALSE,
#'         attachmentState = "string",
#'         gbInUse = 123
#'       )
#'     ),
#'     fromInstanceName = "string",
#'     fromInstanceArn = "string",
#'     fromBlueprintId = "string",
#'     fromBundleId = "string",
#'     isFromAutoSnapshot = TRUE|FALSE,
#'     sizeInGb = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_snapshot(
#'   instanceSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_snapshot
lightsail_get_instance_snapshot <- function(instanceSnapshotName) {
  op <- new_operation(
    name = "GetInstanceSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_snapshot_input(instanceSnapshotName = instanceSnapshotName)
  output <- .lightsail$get_instance_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_snapshot <- lightsail_get_instance_snapshot

#' Returns all instance snapshots for the user's account
#'
#' @description
#' Returns all instance snapshots for the user's account.
#'
#' @usage
#' lightsail_get_instance_snapshots(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_instance_snapshots`][lightsail_get_instance_snapshots] request. If
#' your results are paginated, the response will return a next page token
#' that you can specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instanceSnapshots = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       state = "pending"|"error"|"available",
#'       progress = "string",
#'       fromAttachedDisks = list(
#'         list(
#'           name = "string",
#'           arn = "string",
#'           supportCode = "string",
#'           createdAt = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           location = list(
#'             availabilityZone = "string",
#'             regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'           ),
#'           resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'           tags = list(
#'             list(
#'               key = "string",
#'               value = "string"
#'             )
#'           ),
#'           addOns = list(
#'             list(
#'               name = "string",
#'               status = "string",
#'               snapshotTimeOfDay = "string",
#'               nextSnapshotTimeOfDay = "string"
#'             )
#'           ),
#'           sizeInGb = 123,
#'           isSystemDisk = TRUE|FALSE,
#'           iops = 123,
#'           path = "string",
#'           state = "pending"|"error"|"available"|"in-use"|"unknown",
#'           attachedTo = "string",
#'           isAttached = TRUE|FALSE,
#'           attachmentState = "string",
#'           gbInUse = 123
#'         )
#'       ),
#'       fromInstanceName = "string",
#'       fromInstanceArn = "string",
#'       fromBlueprintId = "string",
#'       fromBundleId = "string",
#'       isFromAutoSnapshot = TRUE|FALSE,
#'       sizeInGb = 123
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_snapshots(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_snapshots
lightsail_get_instance_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetInstanceSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_instance_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_snapshots <- lightsail_get_instance_snapshots

#' Returns the state of a specific instance
#'
#' @description
#' Returns the state of a specific instance. Works on one instance at a
#' time.
#'
#' @usage
#' lightsail_get_instance_state(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance to get state information about.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   state = list(
#'     code = 123,
#'     name = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instance_state(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instance_state
lightsail_get_instance_state <- function(instanceName) {
  op <- new_operation(
    name = "GetInstanceState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instance_state_input(instanceName = instanceName)
  output <- .lightsail$get_instance_state_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instance_state <- lightsail_get_instance_state

#' Returns information about all Amazon Lightsail virtual private servers,
#' or instances
#'
#' @description
#' Returns information about all Amazon Lightsail virtual private servers,
#' or *instances*.
#'
#' @usage
#' lightsail_get_instances(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_instances`][lightsail_get_instances] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instances = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       blueprintId = "string",
#'       blueprintName = "string",
#'       bundleId = "string",
#'       addOns = list(
#'         list(
#'           name = "string",
#'           status = "string",
#'           snapshotTimeOfDay = "string",
#'           nextSnapshotTimeOfDay = "string"
#'         )
#'       ),
#'       isStaticIp = TRUE|FALSE,
#'       privateIpAddress = "string",
#'       publicIpAddress = "string",
#'       ipv6Address = "string",
#'       hardware = list(
#'         cpuCount = 123,
#'         disks = list(
#'           list(
#'             name = "string",
#'             arn = "string",
#'             supportCode = "string",
#'             createdAt = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             location = list(
#'               availabilityZone = "string",
#'               regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'             ),
#'             resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'             tags = list(
#'               list(
#'                 key = "string",
#'                 value = "string"
#'               )
#'             ),
#'             addOns = list(
#'               list(
#'                 name = "string",
#'                 status = "string",
#'                 snapshotTimeOfDay = "string",
#'                 nextSnapshotTimeOfDay = "string"
#'               )
#'             ),
#'             sizeInGb = 123,
#'             isSystemDisk = TRUE|FALSE,
#'             iops = 123,
#'             path = "string",
#'             state = "pending"|"error"|"available"|"in-use"|"unknown",
#'             attachedTo = "string",
#'             isAttached = TRUE|FALSE,
#'             attachmentState = "string",
#'             gbInUse = 123
#'           )
#'         ),
#'         ramSizeInGb = 123.0
#'       ),
#'       networking = list(
#'         monthlyTransfer = list(
#'           gbPerMonthAllocated = 123
#'         ),
#'         ports = list(
#'           list(
#'             fromPort = 123,
#'             toPort = 123,
#'             protocol = "tcp"|"all"|"udp"|"icmp",
#'             accessFrom = "string",
#'             accessType = "Public"|"Private",
#'             commonName = "string",
#'             accessDirection = "inbound"|"outbound",
#'             cidrs = list(
#'               "string"
#'             ),
#'             cidrListAliases = list(
#'               "string"
#'             )
#'           )
#'         )
#'       ),
#'       state = list(
#'         code = 123,
#'         name = "string"
#'       ),
#'       username = "string",
#'       sshKeyName = "string"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_instances(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_instances
lightsail_get_instances <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_instances_input(pageToken = pageToken)
  output <- .lightsail$get_instances_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_instances <- lightsail_get_instances

#' Returns information about a specific key pair
#'
#' @description
#' Returns information about a specific key pair.
#'
#' @usage
#' lightsail_get_key_pair(keyPairName)
#'
#' @param keyPairName &#91;required&#93; The name of the key pair for which you are requesting information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   keyPair = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     fingerprint = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_key_pair(
#'   keyPairName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_key_pair
lightsail_get_key_pair <- function(keyPairName) {
  op <- new_operation(
    name = "GetKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_key_pair_input(keyPairName = keyPairName)
  output <- .lightsail$get_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_key_pair <- lightsail_get_key_pair

#' Returns information about all key pairs in the user's account
#'
#' @description
#' Returns information about all key pairs in the user's account.
#'
#' @usage
#' lightsail_get_key_pairs(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_key_pairs`][lightsail_get_key_pairs] request. If your results are
#' paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   keyPairs = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       fingerprint = "string"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_key_pairs(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_key_pairs
lightsail_get_key_pairs <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetKeyPairs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_key_pairs_input(pageToken = pageToken)
  output <- .lightsail$get_key_pairs_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_key_pairs <- lightsail_get_key_pairs

#' Returns information about the specified Lightsail load balancer
#'
#' @description
#' Returns information about the specified Lightsail load balancer.
#'
#' @usage
#' lightsail_get_load_balancer(loadBalancerName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   loadBalancer = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     dnsName = "string",
#'     state = "active"|"provisioning"|"active_impaired"|"failed"|"unknown",
#'     protocol = "HTTP_HTTPS"|"HTTP",
#'     publicPorts = list(
#'       123
#'     ),
#'     healthCheckPath = "string",
#'     instancePort = 123,
#'     instanceHealthSummary = list(
#'       list(
#'         instanceName = "string",
#'         instanceHealth = "initial"|"healthy"|"unhealthy"|"unused"|"draining"|"unavailable",
#'         instanceHealthReason = "Lb.RegistrationInProgress"|"Lb.InitialHealthChecking"|"Lb.InternalError"|"Instance.ResponseCodeMismatch"|"Instance.Timeout"|"Instance.FailedHealthChecks"|"Instance.NotRegistered"|"Instance.NotInUse"|"Instance.DeregistrationInProgress"|"Instance.InvalidState"|"Instance.IpUnusable"
#'       )
#'     ),
#'     tlsCertificateSummaries = list(
#'       list(
#'         name = "string",
#'         isAttached = TRUE|FALSE
#'       )
#'     ),
#'     configurationOptions = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancer(
#'   loadBalancerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer
lightsail_get_load_balancer <- function(loadBalancerName) {
  op <- new_operation(
    name = "GetLoadBalancer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancer_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$get_load_balancer_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer <- lightsail_get_load_balancer

#' Returns information about health metrics for your Lightsail load
#' balancer
#'
#' @description
#' Returns information about health metrics for your Lightsail load
#' balancer.
#' 
#' Metrics report the utilization of your resources, and the error counts
#' generated by them. Monitor and collect metric data regularly to maintain
#' the reliability, availability, and performance of your resources.
#'
#' @usage
#' lightsail_get_load_balancer_metric_data(loadBalancerName, metricName,
#'   period, startTime, endTime, unit, statistics)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid load balancer metric names are listed below, along with the most
#' useful `statistics` to include in your request, and the published `unit`
#' value.
#' 
#' -   **`ClientTLSNegotiationErrorCount`** - The number of TLS connections
#'     initiated by the client that did not establish a session with the
#'     load balancer due to a TLS error generated by the load balancer.
#'     Possible causes include a mismatch of ciphers or protocols.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HealthyHostCount`** - The number of target instances that are
#'     considered healthy.
#' 
#'     `Statistics`: The most useful statistic are `Average`, `Minimum`,
#'     and `Maximum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_2XX_Count`** - The number of HTTP 2XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_3XX_Count`** - The number of HTTP 3XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_4XX_Count`** - The number of HTTP 4XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_Instance_5XX_Count`** - The number of HTTP 5XX response
#'     codes generated by the target instances. This does not include any
#'     response codes generated by the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_LB_4XX_Count`** - The number of HTTP 4XX client error
#'     codes that originated from the load balancer. Client errors are
#'     generated when requests are malformed or incomplete. These requests
#'     were not received by the target instance. This count does not
#'     include response codes generated by the target instances.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`HTTPCode_LB_5XX_Count`** - The number of HTTP 5XX server error
#'     codes that originated from the load balancer. This does not include
#'     any response codes generated by the target instance. This metric is
#'     reported if there are no healthy instances attached to the load
#'     balancer, or if the request rate exceeds the capacity of the
#'     instances (spillover) or the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`InstanceResponseTime`** - The time elapsed, in seconds, after the
#'     request leaves the load balancer until a response from the target
#'     instance is received.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Seconds`.
#' 
#' -   **`RejectedConnectionCount`** - The number of connections that were
#'     rejected because the load balancer had reached its maximum number of
#'     connections.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`RequestCount`** - The number of requests processed over IPv4.
#'     This count includes only the requests with a response generated by a
#'     target instance of the load balancer.
#' 
#'     `Statistics`: The most useful statistic is `Sum`. Note that
#'     `Minimum`, `Maximum`, and `Average` all return `1`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`UnhealthyHostCount`** - The number of target instances that are
#'     considered unhealthy.
#' 
#'     `Statistics`: The most useful statistic are `Average`, `Minimum`,
#'     and `Maximum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' @param startTime &#91;required&#93; The start time of the period.
#' @param endTime &#91;required&#93; The end time of the period.
#' @param unit &#91;required&#93; The unit for the metric data request. Valid units depend on the metric
#' data being requested. For the valid units with each available metric,
#' see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   metricName = "ClientTLSNegotiationErrorCount"|"HealthyHostCount"|"UnhealthyHostCount"|"HTTPCode_LB_4XX_Count"|"HTTPCode_LB_5XX_Count"|"HTTPCode_Instance_2XX_Count"|"HTTPCode_Instance_3XX_Count"|"HTTPCode_Instance_4XX_Count"|"HTTPCode_Instance_5XX_Count"|"InstanceResponseTime"|"RejectedConnectionCount"|"RequestCount",
#'   metricData = list(
#'     list(
#'       average = 123.0,
#'       maximum = 123.0,
#'       minimum = 123.0,
#'       sampleCount = 123.0,
#'       sum = 123.0,
#'       timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancer_metric_data(
#'   loadBalancerName = "string",
#'   metricName = "ClientTLSNegotiationErrorCount"|"HealthyHostCount"|"UnhealthyHostCount"|"HTTPCode_LB_4XX_Count"|"HTTPCode_LB_5XX_Count"|"HTTPCode_Instance_2XX_Count"|"HTTPCode_Instance_3XX_Count"|"HTTPCode_Instance_4XX_Count"|"HTTPCode_Instance_5XX_Count"|"InstanceResponseTime"|"RejectedConnectionCount"|"RequestCount",
#'   period = 123,
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer_metric_data
lightsail_get_load_balancer_metric_data <- function(loadBalancerName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetLoadBalancerMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancer_metric_data_input(loadBalancerName = loadBalancerName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_load_balancer_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer_metric_data <- lightsail_get_load_balancer_metric_data

#' Returns information about the TLS certificates that are associated with
#' the specified Lightsail load balancer
#'
#' @description
#' Returns information about the TLS certificates that are associated with
#' the specified Lightsail load balancer.
#' 
#' TLS is just an updated, more secure version of Secure Socket Layer
#' (SSL).
#' 
#' You can have a maximum of 2 certificates associated with a Lightsail
#' load balancer. One is active and the other is inactive.
#'
#' @usage
#' lightsail_get_load_balancer_tls_certificates(loadBalancerName)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer you associated with your SSL/TLS
#' certificate.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tlsCertificates = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       loadBalancerName = "string",
#'       isAttached = TRUE|FALSE,
#'       status = "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED"|"UNKNOWN",
#'       domainName = "string",
#'       domainValidationRecords = list(
#'         list(
#'           name = "string",
#'           type = "string",
#'           value = "string",
#'           validationStatus = "PENDING_VALIDATION"|"FAILED"|"SUCCESS",
#'           domainName = "string"
#'         )
#'       ),
#'       failureReason = "NO_AVAILABLE_CONTACTS"|"ADDITIONAL_VERIFICATION_REQUIRED"|"DOMAIN_NOT_ALLOWED"|"INVALID_PUBLIC_DOMAIN"|"OTHER",
#'       issuedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       issuer = "string",
#'       keyAlgorithm = "string",
#'       notAfter = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       notBefore = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       renewalSummary = list(
#'         renewalStatus = "PENDING_AUTO_RENEWAL"|"PENDING_VALIDATION"|"SUCCESS"|"FAILED",
#'         domainValidationOptions = list(
#'           list(
#'             domainName = "string",
#'             validationStatus = "PENDING_VALIDATION"|"FAILED"|"SUCCESS"
#'           )
#'         )
#'       ),
#'       revocationReason = "UNSPECIFIED"|"KEY_COMPROMISE"|"CA_COMPROMISE"|"AFFILIATION_CHANGED"|"SUPERCEDED"|"CESSATION_OF_OPERATION"|"CERTIFICATE_HOLD"|"REMOVE_FROM_CRL"|"PRIVILEGE_WITHDRAWN"|"A_A_COMPROMISE",
#'       revokedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       serial = "string",
#'       signatureAlgorithm = "string",
#'       subject = "string",
#'       subjectAlternativeNames = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancer_tls_certificates(
#'   loadBalancerName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancer_tls_certificates
lightsail_get_load_balancer_tls_certificates <- function(loadBalancerName) {
  op <- new_operation(
    name = "GetLoadBalancerTlsCertificates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancer_tls_certificates_input(loadBalancerName = loadBalancerName)
  output <- .lightsail$get_load_balancer_tls_certificates_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancer_tls_certificates <- lightsail_get_load_balancer_tls_certificates

#' Returns information about all load balancers in an account
#'
#' @description
#' Returns information about all load balancers in an account.
#'
#' @usage
#' lightsail_get_load_balancers(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_load_balancers`][lightsail_get_load_balancers] request. If your
#' results are paginated, the response will return a next page token that
#' you can specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   loadBalancers = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       dnsName = "string",
#'       state = "active"|"provisioning"|"active_impaired"|"failed"|"unknown",
#'       protocol = "HTTP_HTTPS"|"HTTP",
#'       publicPorts = list(
#'         123
#'       ),
#'       healthCheckPath = "string",
#'       instancePort = 123,
#'       instanceHealthSummary = list(
#'         list(
#'           instanceName = "string",
#'           instanceHealth = "initial"|"healthy"|"unhealthy"|"unused"|"draining"|"unavailable",
#'           instanceHealthReason = "Lb.RegistrationInProgress"|"Lb.InitialHealthChecking"|"Lb.InternalError"|"Instance.ResponseCodeMismatch"|"Instance.Timeout"|"Instance.FailedHealthChecks"|"Instance.NotRegistered"|"Instance.NotInUse"|"Instance.DeregistrationInProgress"|"Instance.InvalidState"|"Instance.IpUnusable"
#'         )
#'       ),
#'       tlsCertificateSummaries = list(
#'         list(
#'           name = "string",
#'           isAttached = TRUE|FALSE
#'         )
#'       ),
#'       configurationOptions = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_load_balancers(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_load_balancers
lightsail_get_load_balancers <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetLoadBalancers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_load_balancers_input(pageToken = pageToken)
  output <- .lightsail$get_load_balancers_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_load_balancers <- lightsail_get_load_balancers

#' Returns information about a specific operation
#'
#' @description
#' Returns information about a specific operation. Operations include
#' events such as when you create an instance, allocate a static IP, attach
#' a static IP, and so on.
#'
#' @usage
#' lightsail_get_operation(operationId)
#'
#' @param operationId &#91;required&#93; A GUID used to identify the operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_operation(
#'   operationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operation
lightsail_get_operation <- function(operationId) {
  op <- new_operation(
    name = "GetOperation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_operation_input(operationId = operationId)
  output <- .lightsail$get_operation_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operation <- lightsail_get_operation

#' Returns information about all operations
#'
#' @description
#' Returns information about all operations.
#' 
#' Results are returned from oldest to newest, up to a maximum of 200.
#' Results can be paged by making each subsequent call to
#' [`get_operations`][lightsail_get_operations] use the maximum (last)
#' `statusChangedAt` value from the previous request.
#'
#' @usage
#' lightsail_get_operations(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_operations`][lightsail_get_operations] request. If your results
#' are paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_operations(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operations
lightsail_get_operations <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetOperations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_operations_input(pageToken = pageToken)
  output <- .lightsail$get_operations_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operations <- lightsail_get_operations

#' Gets operations for a specific resource (e
#'
#' @description
#' Gets operations for a specific resource (e.g., an instance or a static
#' IP).
#'
#' @usage
#' lightsail_get_operations_for_resource(resourceName, pageToken)
#'
#' @param resourceName &#91;required&#93; The name of the resource for which you are requesting information.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_operations_for_resource`][lightsail_get_operations_for_resource]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   ),
#'   nextPageCount = "string",
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_operations_for_resource(
#'   resourceName = "string",
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_operations_for_resource
lightsail_get_operations_for_resource <- function(resourceName, pageToken = NULL) {
  op <- new_operation(
    name = "GetOperationsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_operations_for_resource_input(resourceName = resourceName, pageToken = pageToken)
  output <- .lightsail$get_operations_for_resource_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_operations_for_resource <- lightsail_get_operations_for_resource

#' Returns a list of all valid regions for Amazon Lightsail
#'
#' @description
#' Returns a list of all valid regions for Amazon Lightsail. Use the
#' `include availability zones` parameter to also return the Availability
#' Zones in a region.
#'
#' @usage
#' lightsail_get_regions(includeAvailabilityZones,
#'   includeRelationalDatabaseAvailabilityZones)
#'
#' @param includeAvailabilityZones A Boolean value indicating whether to also include Availability Zones in
#' your get regions request. Availability Zones are indicated with a
#' letter: e.g., `us-east-2a`.
#' @param includeRelationalDatabaseAvailabilityZones A Boolean value indicating whether to also include Availability Zones
#' for databases in your get regions request. Availability Zones are
#' indicated with a letter (e.g., `us-east-2a`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   regions = list(
#'     list(
#'       continentCode = "string",
#'       description = "string",
#'       displayName = "string",
#'       name = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2",
#'       availabilityZones = list(
#'         list(
#'           zoneName = "string",
#'           state = "string"
#'         )
#'       ),
#'       relationalDatabaseAvailabilityZones = list(
#'         list(
#'           zoneName = "string",
#'           state = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_regions(
#'   includeAvailabilityZones = TRUE|FALSE,
#'   includeRelationalDatabaseAvailabilityZones = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_regions
lightsail_get_regions <- function(includeAvailabilityZones = NULL, includeRelationalDatabaseAvailabilityZones = NULL) {
  op <- new_operation(
    name = "GetRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_regions_input(includeAvailabilityZones = includeAvailabilityZones, includeRelationalDatabaseAvailabilityZones = includeRelationalDatabaseAvailabilityZones)
  output <- .lightsail$get_regions_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_regions <- lightsail_get_regions

#' Returns information about a specific database in Amazon Lightsail
#'
#' @description
#' Returns information about a specific database in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database that you are looking up.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   relationalDatabase = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     relationalDatabaseBlueprintId = "string",
#'     relationalDatabaseBundleId = "string",
#'     masterDatabaseName = "string",
#'     hardware = list(
#'       cpuCount = 123,
#'       diskSizeInGb = 123,
#'       ramSizeInGb = 123.0
#'     ),
#'     state = "string",
#'     secondaryAvailabilityZone = "string",
#'     backupRetentionEnabled = TRUE|FALSE,
#'     pendingModifiedValues = list(
#'       masterUserPassword = "string",
#'       engineVersion = "string",
#'       backupRetentionEnabled = TRUE|FALSE
#'     ),
#'     engine = "string",
#'     engineVersion = "string",
#'     latestRestorableTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     masterUsername = "string",
#'     parameterApplyStatus = "string",
#'     preferredBackupWindow = "string",
#'     preferredMaintenanceWindow = "string",
#'     publiclyAccessible = TRUE|FALSE,
#'     masterEndpoint = list(
#'       port = 123,
#'       address = "string"
#'     ),
#'     pendingMaintenanceActions = list(
#'       list(
#'         action = "string",
#'         description = "string",
#'         currentApplyDate = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     ),
#'     caCertificateIdentifier = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database
lightsail_get_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "GetRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$get_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database <- lightsail_get_relational_database

#' Returns a list of available database blueprints in Amazon Lightsail
#'
#' @description
#' Returns a list of available database blueprints in Amazon Lightsail. A
#' blueprint describes the major engine version of a database.
#' 
#' You can use a blueprint ID to create a new database that runs a specific
#' database engine.
#'
#' @usage
#' lightsail_get_relational_database_blueprints(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_blueprints`][lightsail_get_relational_database_blueprints]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   blueprints = list(
#'     list(
#'       blueprintId = "string",
#'       engine = "mysql",
#'       engineVersion = "string",
#'       engineDescription = "string",
#'       engineVersionDescription = "string",
#'       isEngineDefault = TRUE|FALSE
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_blueprints(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_blueprints
lightsail_get_relational_database_blueprints <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseBlueprints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_blueprints_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_blueprints_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_blueprints <- lightsail_get_relational_database_blueprints

#' Returns the list of bundles that are available in Amazon Lightsail
#'
#' @description
#' Returns the list of bundles that are available in Amazon Lightsail. A
#' bundle describes the performance specifications for a database.
#' 
#' You can use a bundle ID to create a new database with explicit
#' performance specifications.
#'
#' @usage
#' lightsail_get_relational_database_bundles(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_bundles`][lightsail_get_relational_database_bundles]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   bundles = list(
#'     list(
#'       bundleId = "string",
#'       name = "string",
#'       price = 123.0,
#'       ramSizeInGb = 123.0,
#'       diskSizeInGb = 123,
#'       transferPerMonthInGb = 123,
#'       cpuCount = 123,
#'       isEncrypted = TRUE|FALSE,
#'       isActive = TRUE|FALSE
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_bundles(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_bundles
lightsail_get_relational_database_bundles <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseBundles",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_bundles_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_bundles_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_bundles <- lightsail_get_relational_database_bundles

#' Returns a list of events for a specific database in Amazon Lightsail
#'
#' @description
#' Returns a list of events for a specific database in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_events(relationalDatabaseName,
#'   durationInMinutes, pageToken)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of the database from which to get events.
#' @param durationInMinutes The number of minutes in the past from which to retrieve events. For
#' example, to get all events from the past 2 hours, enter 120.
#' 
#' Default: `60`
#' 
#' The minimum is 1 and the maximum is 14 days (20160 minutes).
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_events`][lightsail_get_relational_database_events]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   relationalDatabaseEvents = list(
#'     list(
#'       resource = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       message = "string",
#'       eventCategories = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_events(
#'   relationalDatabaseName = "string",
#'   durationInMinutes = 123,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_events
lightsail_get_relational_database_events <- function(relationalDatabaseName, durationInMinutes = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_events_input(relationalDatabaseName = relationalDatabaseName, durationInMinutes = durationInMinutes, pageToken = pageToken)
  output <- .lightsail$get_relational_database_events_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_events <- lightsail_get_relational_database_events

#' Returns a list of log events for a database in Amazon Lightsail
#'
#' @description
#' Returns a list of log events for a database in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_log_events(relationalDatabaseName,
#'   logStreamName, startTime, endTime, startFromHead, pageToken)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get log events.
#' @param logStreamName &#91;required&#93; The name of the log stream.
#' 
#' Use the `get relational database log streams` operation to get a list of
#' available log streams.
#' @param startTime The start of the time interval from which to get log events.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, then you input `1538424000` as the start time.
#' @param endTime The end of the time interval from which to get log events.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 8
#'     PM UTC, then you input `1538424000` as the end time.
#' @param startFromHead Parameter to specify if the log should start from head or tail. If
#' `true` is specified, the log event starts from the head of the log. If
#' `false` is specified, the log event starts from the tail of the log.
#' 
#' For PostgreSQL, the default value of `false` is the only option
#' available.
#' @param pageToken The token to advance to the next or previous page of results from your
#' request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_log_events`][lightsail_get_relational_database_log_events]
#' request. If your results are paginated, the response will return a next
#' forward token and/or next backward token that you can specify as the
#' page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   resourceLogEvents = list(
#'     list(
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       message = "string"
#'     )
#'   ),
#'   nextBackwardToken = "string",
#'   nextForwardToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_log_events(
#'   relationalDatabaseName = "string",
#'   logStreamName = "string",
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   startFromHead = TRUE|FALSE,
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_log_events
lightsail_get_relational_database_log_events <- function(relationalDatabaseName, logStreamName, startTime = NULL, endTime = NULL, startFromHead = NULL, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseLogEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_log_events_input(relationalDatabaseName = relationalDatabaseName, logStreamName = logStreamName, startTime = startTime, endTime = endTime, startFromHead = startFromHead, pageToken = pageToken)
  output <- .lightsail$get_relational_database_log_events_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_log_events <- lightsail_get_relational_database_log_events

#' Returns a list of available log streams for a specific database in
#' Amazon Lightsail
#'
#' @description
#' Returns a list of available log streams for a specific database in
#' Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_log_streams(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get log streams.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   logStreams = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_log_streams(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_log_streams
lightsail_get_relational_database_log_streams <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "GetRelationalDatabaseLogStreams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_log_streams_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$get_relational_database_log_streams_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_log_streams <- lightsail_get_relational_database_log_streams

#' Returns the current, previous, or pending versions of the master user
#' password for a Lightsail database
#'
#' @description
#' Returns the current, previous, or pending versions of the master user
#' password for a Lightsail database.
#' 
#' The
#' [`get_relational_database_master_user_password`][lightsail_get_relational_database_master_user_password]
#' operation supports tag-based access control via resource tags applied to
#' the resource identified by relationalDatabaseName.
#'
#' @usage
#' lightsail_get_relational_database_master_user_password(
#'   relationalDatabaseName, passwordVersion)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get the master user password.
#' @param passwordVersion The password version to return.
#' 
#' Specifying `CURRENT` or `PREVIOUS` returns the current or previous
#' passwords respectively. Specifying `PENDING` returns the newest version
#' of the password that will rotate to `CURRENT`. After the `PENDING`
#' password rotates to `CURRENT`, the `PENDING` password is no longer
#' available.
#' 
#' Default: `CURRENT`
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   masterUserPassword = "string",
#'   createdAt = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_master_user_password(
#'   relationalDatabaseName = "string",
#'   passwordVersion = "CURRENT"|"PREVIOUS"|"PENDING"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_master_user_password
lightsail_get_relational_database_master_user_password <- function(relationalDatabaseName, passwordVersion = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseMasterUserPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_master_user_password_input(relationalDatabaseName = relationalDatabaseName, passwordVersion = passwordVersion)
  output <- .lightsail$get_relational_database_master_user_password_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_master_user_password <- lightsail_get_relational_database_master_user_password

#' Returns the data points of the specified metric for a database in Amazon
#' Lightsail
#'
#' @description
#' Returns the data points of the specified metric for a database in Amazon
#' Lightsail.
#' 
#' Metrics report the utilization of your resources, and the error counts
#' generated by them. Monitor and collect metric data regularly to maintain
#' the reliability, availability, and performance of your resources.
#'
#' @usage
#' lightsail_get_relational_database_metric_data(relationalDatabaseName,
#'   metricName, period, startTime, endTime, unit, statistics)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database from which to get metric data.
#' @param metricName &#91;required&#93; The metric for which you want to return information.
#' 
#' Valid relational database metric names are listed below, along with the
#' most useful `statistics` to include in your request, and the published
#' `unit` value. All relational database metric data is available in
#' 1-minute (60 seconds) granularity.
#' 
#' -   **`CPUUtilization`** - The percentage of CPU utilization currently
#'     in use on the database.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and
#'     `Average`.
#' 
#'     `Unit`: The published unit is `Percent`.
#' 
#' -   **`DatabaseConnections`** - The number of database connections in
#'     use.
#' 
#'     `Statistics`: The most useful statistics are `Maximum` and `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`DiskQueueDepth`** - The number of outstanding IOs (read/write
#'     requests) that are waiting to access the disk.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Count`.
#' 
#' -   **`FreeStorageSpace`** - The amount of available storage space.
#' 
#'     `Statistics`: The most useful statistic is `Sum`.
#' 
#'     `Unit`: The published unit is `Bytes`.
#' 
#' -   **`NetworkReceiveThroughput`** - The incoming (Receive) network
#'     traffic on the database, including both customer database traffic
#'     and AWS traffic used for monitoring and replication.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Bytes/Second`.
#' 
#' -   **`NetworkTransmitThroughput`** - The outgoing (Transmit) network
#'     traffic on the database, including both customer database traffic
#'     and AWS traffic used for monitoring and replication.
#' 
#'     `Statistics`: The most useful statistic is `Average`.
#' 
#'     `Unit`: The published unit is `Bytes/Second`.
#' @param period &#91;required&#93; The granularity, in seconds, of the returned data points.
#' 
#' All relational database metric data is available in 1-minute (60
#' seconds) granularity.
#' @param startTime &#91;required&#93; The start of the time interval from which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use a start time of October 1, 2018, at
#'     8 PM UTC, then you input `1538424000` as the start time.
#' @param endTime &#91;required&#93; The end of the time interval from which to get metric data.
#' 
#' Constraints:
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Specified in the Unix time format.
#' 
#'     For example, if you wish to use an end time of October 1, 2018, at 8
#'     PM UTC, then you input `1538424000` as the end time.
#' @param unit &#91;required&#93; The unit for the metric data request. Valid units depend on the metric
#' data being requested. For the valid units with each available metric,
#' see the `metricName` parameter.
#' @param statistics &#91;required&#93; The statistic for the metric.
#' 
#' The following statistics are available:
#' 
#' -   `Minimum` - The lowest value observed during the specified period.
#'     Use this value to determine low volumes of activity for your
#'     application.
#' 
#' -   `Maximum` - The highest value observed during the specified period.
#'     Use this value to determine high volumes of activity for your
#'     application.
#' 
#' -   `Sum` - All values submitted for the matching metric added together.
#'     You can use this statistic to determine the total volume of a
#'     metric.
#' 
#' -   `Average` - The value of Sum / SampleCount during the specified
#'     period. By comparing this statistic with the Minimum and Maximum
#'     values, you can determine the full scope of a metric and how close
#'     the average use is to the Minimum and Maximum values. This
#'     comparison helps you to know when to increase or decrease your
#'     resources.
#' 
#' -   `SampleCount` - The count, or number, of data points used for the
#'     statistical calculation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   metricName = "CPUUtilization"|"DatabaseConnections"|"DiskQueueDepth"|"FreeStorageSpace"|"NetworkReceiveThroughput"|"NetworkTransmitThroughput",
#'   metricData = list(
#'     list(
#'       average = 123.0,
#'       maximum = 123.0,
#'       minimum = 123.0,
#'       sampleCount = 123.0,
#'       sum = 123.0,
#'       timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_metric_data(
#'   relationalDatabaseName = "string",
#'   metricName = "CPUUtilization"|"DatabaseConnections"|"DiskQueueDepth"|"FreeStorageSpace"|"NetworkReceiveThroughput"|"NetworkTransmitThroughput",
#'   period = 123,
#'   startTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   endTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
#'   statistics = list(
#'     "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_metric_data
lightsail_get_relational_database_metric_data <- function(relationalDatabaseName, metricName, period, startTime, endTime, unit, statistics) {
  op <- new_operation(
    name = "GetRelationalDatabaseMetricData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_metric_data_input(relationalDatabaseName = relationalDatabaseName, metricName = metricName, period = period, startTime = startTime, endTime = endTime, unit = unit, statistics = statistics)
  output <- .lightsail$get_relational_database_metric_data_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_metric_data <- lightsail_get_relational_database_metric_data

#' Returns all of the runtime parameters offered by the underlying database
#' software, or engine, for a specific database in Amazon Lightsail
#'
#' @description
#' Returns all of the runtime parameters offered by the underlying database
#' software, or engine, for a specific database in Amazon Lightsail.
#' 
#' In addition to the parameter names and values, this operation returns
#' other information about each parameter. This information includes
#' whether changes require a reboot, whether the parameter is modifiable,
#' the allowed values, and the data types.
#'
#' @usage
#' lightsail_get_relational_database_parameters(relationalDatabaseName,
#'   pageToken)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to get parameters.
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_parameters`][lightsail_get_relational_database_parameters]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   parameters = list(
#'     list(
#'       allowedValues = "string",
#'       applyMethod = "string",
#'       applyType = "string",
#'       dataType = "string",
#'       description = "string",
#'       isModifiable = TRUE|FALSE,
#'       parameterName = "string",
#'       parameterValue = "string"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_parameters(
#'   relationalDatabaseName = "string",
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_parameters
lightsail_get_relational_database_parameters <- function(relationalDatabaseName, pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_parameters_input(relationalDatabaseName = relationalDatabaseName, pageToken = pageToken)
  output <- .lightsail$get_relational_database_parameters_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_parameters <- lightsail_get_relational_database_parameters

#' Returns information about a specific database snapshot in Amazon
#' Lightsail
#'
#' @description
#' Returns information about a specific database snapshot in Amazon
#' Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_snapshot(
#'   relationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseSnapshotName &#91;required&#93; The name of the database snapshot for which to get information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   relationalDatabaseSnapshot = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     engine = "string",
#'     engineVersion = "string",
#'     sizeInGb = 123,
#'     state = "string",
#'     fromRelationalDatabaseName = "string",
#'     fromRelationalDatabaseArn = "string",
#'     fromRelationalDatabaseBundleId = "string",
#'     fromRelationalDatabaseBlueprintId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_snapshot(
#'   relationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_snapshot
lightsail_get_relational_database_snapshot <- function(relationalDatabaseSnapshotName) {
  op <- new_operation(
    name = "GetRelationalDatabaseSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_snapshot_input(relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$get_relational_database_snapshot_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_snapshot <- lightsail_get_relational_database_snapshot

#' Returns information about all of your database snapshots in Amazon
#' Lightsail
#'
#' @description
#' Returns information about all of your database snapshots in Amazon
#' Lightsail.
#'
#' @usage
#' lightsail_get_relational_database_snapshots(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_database_snapshots`][lightsail_get_relational_database_snapshots]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   relationalDatabaseSnapshots = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       engine = "string",
#'       engineVersion = "string",
#'       sizeInGb = 123,
#'       state = "string",
#'       fromRelationalDatabaseName = "string",
#'       fromRelationalDatabaseArn = "string",
#'       fromRelationalDatabaseBundleId = "string",
#'       fromRelationalDatabaseBlueprintId = "string"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_database_snapshots(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_database_snapshots
lightsail_get_relational_database_snapshots <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabaseSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_database_snapshots_input(pageToken = pageToken)
  output <- .lightsail$get_relational_database_snapshots_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_database_snapshots <- lightsail_get_relational_database_snapshots

#' Returns information about all of your databases in Amazon Lightsail
#'
#' @description
#' Returns information about all of your databases in Amazon Lightsail.
#'
#' @usage
#' lightsail_get_relational_databases(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_relational_databases`][lightsail_get_relational_databases]
#' request. If your results are paginated, the response will return a next
#' page token that you can specify as the page token in a subsequent
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   relationalDatabases = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       ),
#'       relationalDatabaseBlueprintId = "string",
#'       relationalDatabaseBundleId = "string",
#'       masterDatabaseName = "string",
#'       hardware = list(
#'         cpuCount = 123,
#'         diskSizeInGb = 123,
#'         ramSizeInGb = 123.0
#'       ),
#'       state = "string",
#'       secondaryAvailabilityZone = "string",
#'       backupRetentionEnabled = TRUE|FALSE,
#'       pendingModifiedValues = list(
#'         masterUserPassword = "string",
#'         engineVersion = "string",
#'         backupRetentionEnabled = TRUE|FALSE
#'       ),
#'       engine = "string",
#'       engineVersion = "string",
#'       latestRestorableTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       masterUsername = "string",
#'       parameterApplyStatus = "string",
#'       preferredBackupWindow = "string",
#'       preferredMaintenanceWindow = "string",
#'       publiclyAccessible = TRUE|FALSE,
#'       masterEndpoint = list(
#'         port = 123,
#'         address = "string"
#'       ),
#'       pendingMaintenanceActions = list(
#'         list(
#'           action = "string",
#'           description = "string",
#'           currentApplyDate = as.POSIXct(
#'             "2015-01-01"
#'           )
#'         )
#'       ),
#'       caCertificateIdentifier = "string"
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_relational_databases(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_relational_databases
lightsail_get_relational_databases <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetRelationalDatabases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_relational_databases_input(pageToken = pageToken)
  output <- .lightsail$get_relational_databases_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_relational_databases <- lightsail_get_relational_databases

#' Returns information about a specific static IP
#'
#' @description
#' Returns information about a specific static IP.
#'
#' @usage
#' lightsail_get_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP in Lightsail.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   staticIp = list(
#'     name = "string",
#'     arn = "string",
#'     supportCode = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     ipAddress = "string",
#'     attachedTo = "string",
#'     isAttached = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_static_ip
lightsail_get_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "GetStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$get_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_static_ip <- lightsail_get_static_ip

#' Returns information about all static IPs in the user's account
#'
#' @description
#' Returns information about all static IPs in the user's account.
#'
#' @usage
#' lightsail_get_static_ips(pageToken)
#'
#' @param pageToken The token to advance to the next page of results from your request.
#' 
#' To get a page token, perform an initial
#' [`get_static_ips`][lightsail_get_static_ips] request. If your results
#' are paginated, the response will return a next page token that you can
#' specify as the page token in a subsequent request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   staticIps = list(
#'     list(
#'       name = "string",
#'       arn = "string",
#'       supportCode = "string",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       ipAddress = "string",
#'       attachedTo = "string",
#'       isAttached = TRUE|FALSE
#'     )
#'   ),
#'   nextPageToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_static_ips(
#'   pageToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_get_static_ips
lightsail_get_static_ips <- function(pageToken = NULL) {
  op <- new_operation(
    name = "GetStaticIps",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$get_static_ips_input(pageToken = pageToken)
  output <- .lightsail$get_static_ips_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$get_static_ips <- lightsail_get_static_ips

#' Imports a public SSH key from a specific key pair
#'
#' @description
#' Imports a public SSH key from a specific key pair.
#'
#' @usage
#' lightsail_import_key_pair(keyPairName, publicKeyBase64)
#'
#' @param keyPairName &#91;required&#93; The name of the key pair for which you want to import the public key.
#' @param publicKeyBase64 &#91;required&#93; A base64-encoded public key of the `ssh-rsa` type.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$import_key_pair(
#'   keyPairName = "string",
#'   publicKeyBase64 = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_import_key_pair
lightsail_import_key_pair <- function(keyPairName, publicKeyBase64) {
  op <- new_operation(
    name = "ImportKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$import_key_pair_input(keyPairName = keyPairName, publicKeyBase64 = publicKeyBase64)
  output <- .lightsail$import_key_pair_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$import_key_pair <- lightsail_import_key_pair

#' Returns a Boolean value indicating whether your Lightsail VPC is peered
#'
#' @description
#' Returns a Boolean value indicating whether your Lightsail VPC is peered.
#'
#' @usage
#' lightsail_is_vpc_peered()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   isPeered = TRUE|FALSE
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$is_vpc_peered()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_is_vpc_peered
lightsail_is_vpc_peered <- function() {
  op <- new_operation(
    name = "IsVpcPeered",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$is_vpc_peered_input()
  output <- .lightsail$is_vpc_peered_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$is_vpc_peered <- lightsail_is_vpc_peered

#' Opens ports for a specific Amazon Lightsail instance, and specifies the
#' IP addresses allowed to connect to the instance through the ports, and
#' the protocol
#'
#' @description
#' Opens ports for a specific Amazon Lightsail instance, and specifies the
#' IP addresses allowed to connect to the instance through the ports, and
#' the protocol.
#' 
#' The [`open_instance_public_ports`][lightsail_open_instance_public_ports]
#' action supports tag-based access control via resource tags applied to
#' the resource identified by `instanceName`. For more information, see the
#' Lightsail Dev Guide.
#'
#' @usage
#' lightsail_open_instance_public_ports(portInfo, instanceName)
#'
#' @param portInfo &#91;required&#93; An object to describe the ports to open for the specified instance.
#' @param instanceName &#91;required&#93; The name of the instance for which to open ports.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$open_instance_public_ports(
#'   portInfo = list(
#'     fromPort = 123,
#'     toPort = 123,
#'     protocol = "tcp"|"all"|"udp"|"icmp",
#'     cidrs = list(
#'       "string"
#'     ),
#'     cidrListAliases = list(
#'       "string"
#'     )
#'   ),
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_open_instance_public_ports
lightsail_open_instance_public_ports <- function(portInfo, instanceName) {
  op <- new_operation(
    name = "OpenInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$open_instance_public_ports_input(portInfo = portInfo, instanceName = instanceName)
  output <- .lightsail$open_instance_public_ports_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$open_instance_public_ports <- lightsail_open_instance_public_ports

#' Tries to peer the Lightsail VPC with the user's default VPC
#'
#' @description
#' Tries to peer the Lightsail VPC with the user's default VPC.
#'
#' @usage
#' lightsail_peer_vpc()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$peer_vpc()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_peer_vpc
lightsail_peer_vpc <- function() {
  op <- new_operation(
    name = "PeerVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$peer_vpc_input()
  output <- .lightsail$peer_vpc_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$peer_vpc <- lightsail_peer_vpc

#' Creates or updates an alarm, and associates it with the specified metric
#'
#' @description
#' Creates or updates an alarm, and associates it with the specified
#' metric.
#' 
#' An alarm is used to monitor a single metric for one of your resources.
#' When a metric condition is met, the alarm can notify you by email, SMS
#' text message, and a banner displayed on the Amazon Lightsail console.
#' For more information, see Alarms in Amazon Lightsail.
#' 
#' When this action creates an alarm, the alarm state is immediately set to
#' `INSUFFICIENT_DATA`. The alarm is then evaluated and its state is set
#' appropriately. Any actions associated with the new state are then
#' executed.
#' 
#' When you update an existing alarm, its state is left unchanged, but the
#' update completely overwrites the previous configuration of the alarm.
#' The alarm is then evaluated with the updated configuration.
#'
#' @usage
#' lightsail_put_alarm(alarmName, metricName, monitoredResourceName,
#'   comparisonOperator, threshold, evaluationPeriods, datapointsToAlarm,
#'   treatMissingData, contactProtocols, notificationTriggers,
#'   notificationEnabled)
#'
#' @param alarmName &#91;required&#93; The name for the alarm. Specify the name of an existing alarm to update,
#' and overwrite the previous configuration of the alarm.
#' @param metricName &#91;required&#93; The name of the metric to associate with the alarm.
#' 
#' You can configure up to two alarms per metric.
#' 
#' The following metrics are available for each resource type:
#' 
#' -   **Instances**: `BurstCapacityPercentage`, `BurstCapacityTime`,
#'     `CPUUtilization`, `NetworkIn`, `NetworkOut`, `StatusCheckFailed`,
#'     `StatusCheckFailed_Instance`, and `StatusCheckFailed_System`.
#' 
#' -   **Load balancers**: `ClientTLSNegotiationErrorCount`,
#'     `HealthyHostCount`, `UnhealthyHostCount`, `HTTPCode_LB_4XX_Count`,
#'     `HTTPCode_LB_5XX_Count`, `HTTPCode_Instance_2XX_Count`,
#'     `HTTPCode_Instance_3XX_Count`, `HTTPCode_Instance_4XX_Count`,
#'     `HTTPCode_Instance_5XX_Count`, `InstanceResponseTime`,
#'     `RejectedConnectionCount`, and `RequestCount`.
#' 
#' -   **Relational databases**: `CPUUtilization`, `DatabaseConnections`,
#'     `DiskQueueDepth`, `FreeStorageSpace`, `NetworkReceiveThroughput`,
#'     and `NetworkTransmitThroughput`.
#' 
#' For more information about these metrics, see Metrics available in
#' Lightsail.
#' @param monitoredResourceName &#91;required&#93; The name of the Lightsail resource that will be monitored.
#' 
#' Instances, load balancers, and relational databases are the only
#' Lightsail resources that can currently be monitored by alarms.
#' @param comparisonOperator &#91;required&#93; The arithmetic operation to use when comparing the specified statistic
#' to the threshold. The specified statistic value is used as the first
#' operand.
#' @param threshold &#91;required&#93; The value against which the specified statistic is compared.
#' @param evaluationPeriods &#91;required&#93; The number of most recent periods over which data is compared to the
#' specified threshold. If you are setting an "M out of N" alarm, this
#' value (`evaluationPeriods`) is the N.
#' 
#' If you are setting an alarm that requires that a number of consecutive
#' data points be breaching to trigger the alarm, this value specifies the
#' rolling period of time in which data points are evaluated.
#' 
#' Each evaluation period is five minutes long. For example, specify an
#' evaluation period of 24 to evaluate a metric over a rolling period of
#' two hours.
#' 
#' You can specify a minimum valuation period of 1 (5 minutes), and a
#' maximum evaluation period of 288 (24 hours).
#' @param datapointsToAlarm The number of data points that must be not within the specified
#' threshold to trigger the alarm. If you are setting an "M out of N"
#' alarm, this value (`datapointsToAlarm`) is the M.
#' @param treatMissingData Sets how this alarm will handle missing data points.
#' 
#' An alarm can treat missing data in the following ways:
#' 
#' -   `breaching` - Assume the missing data is not within the threshold.
#'     Missing data counts towards the number of times the metric is not
#'     within the threshold.
#' 
#' -   `notBreaching` - Assume the missing data is within the threshold.
#'     Missing data does not count towards the number of times the metric
#'     is not within the threshold.
#' 
#' -   `ignore` - Ignore the missing data. Maintains the current alarm
#'     state.
#' 
#' -   `missing` - Missing data is treated as missing.
#' 
#' If `treatMissingData` is not specified, the default behavior of
#' `missing` is used.
#' @param contactProtocols The contact protocols to use for the alarm, such as `Email`, `SMS` (text
#' messaging), or both.
#' 
#' A notification is sent via the specified contact protocol if
#' notifications are enabled for the alarm, and when the alarm is
#' triggered.
#' 
#' A notification is not sent if a contact protocol is not specified, if
#' the specified contact protocol is not configured in the AWS Region, or
#' if notifications are not enabled for the alarm using the
#' `notificationEnabled` paramater.
#' 
#' Use the [`create_contact_method`][lightsail_create_contact_method]
#' action to configure a contact protocol in an AWS Region.
#' @param notificationTriggers The alarm states that trigger a notification.
#' 
#' An alarm has the following possible states:
#' 
#' -   `ALARM` - The metric is outside of the defined threshold.
#' 
#' -   `INSUFFICIENT_DATA` - The alarm has just started, the metric is not
#'     available, or not enough data is available for the metric to
#'     determine the alarm state.
#' 
#' -   `OK` - The metric is within the defined threshold.
#' 
#' When you specify a notification trigger, the `ALARM` state must be
#' specified. The `INSUFFICIENT_DATA` and `OK` states can be specified in
#' addition to the `ALARM` state.
#' 
#' -   If you specify `OK` as an alarm trigger, a notification is sent when
#'     the alarm switches from an `ALARM` or `INSUFFICIENT_DATA` alarm
#'     state to an `OK` state. This can be thought of as an *all clear*
#'     alarm notification.
#' 
#' -   If you specify `INSUFFICIENT_DATA` as the alarm trigger, a
#'     notification is sent when the alarm switches from an `OK` or `ALARM`
#'     alarm state to an `INSUFFICIENT_DATA` state.
#' 
#' The notification trigger defaults to `ALARM` if you don't specify this
#' parameter.
#' @param notificationEnabled Indicates whether the alarm is enabled.
#' 
#' Notifications are enabled by default if you don't specify this
#' parameter.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_alarm(
#'   alarmName = "string",
#'   metricName = "CPUUtilization"|"NetworkIn"|"NetworkOut"|"StatusCheckFailed"|"StatusCheckFailed_Instance"|"StatusCheckFailed_System"|"ClientTLSNegotiationErrorCount"|"HealthyHostCount"|"UnhealthyHostCount"|"HTTPCode_LB_4XX_Count"|"HTTPCode_LB_5XX_Count"|"HTTPCode_Instance_2XX_Count"|"HTTPCode_Instance_3XX_Count"|"HTTPCode_Instance_4XX_Count"|"HTTPCode_Instance_5XX_Count"|"InstanceResponseTime"|"RejectedConnectionCount"|"RequestCount"|"DatabaseConnections"|"DiskQueueDepth"|"FreeStorageSpace"|"NetworkReceiveThroughput"|"NetworkTransmitThroughput"|"BurstCapacityTime"|"BurstCapacityPercentage",
#'   monitoredResourceName = "string",
#'   comparisonOperator = "GreaterThanOrEqualToThreshold"|"GreaterThanThreshold"|"LessThanThreshold"|"LessThanOrEqualToThreshold",
#'   threshold = 123.0,
#'   evaluationPeriods = 123,
#'   datapointsToAlarm = 123,
#'   treatMissingData = "breaching"|"notBreaching"|"ignore"|"missing",
#'   contactProtocols = list(
#'     "Email"|"SMS"
#'   ),
#'   notificationTriggers = list(
#'     "OK"|"ALARM"|"INSUFFICIENT_DATA"
#'   ),
#'   notificationEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_put_alarm
lightsail_put_alarm <- function(alarmName, metricName, monitoredResourceName, comparisonOperator, threshold, evaluationPeriods, datapointsToAlarm = NULL, treatMissingData = NULL, contactProtocols = NULL, notificationTriggers = NULL, notificationEnabled = NULL) {
  op <- new_operation(
    name = "PutAlarm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$put_alarm_input(alarmName = alarmName, metricName = metricName, monitoredResourceName = monitoredResourceName, comparisonOperator = comparisonOperator, threshold = threshold, evaluationPeriods = evaluationPeriods, datapointsToAlarm = datapointsToAlarm, treatMissingData = treatMissingData, contactProtocols = contactProtocols, notificationTriggers = notificationTriggers, notificationEnabled = notificationEnabled)
  output <- .lightsail$put_alarm_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$put_alarm <- lightsail_put_alarm

#' Opens ports for a specific Amazon Lightsail instance, and specifies the
#' IP addresses allowed to connect to the instance through the ports, and
#' the protocol
#'
#' @description
#' Opens ports for a specific Amazon Lightsail instance, and specifies the
#' IP addresses allowed to connect to the instance through the ports, and
#' the protocol. This action also closes all currently open ports that are
#' not included in the request. Include all of the ports and the protocols
#' you want to open in your
#' [`put_instance_public_ports`][lightsail_put_instance_public_ports]request.
#' Or use the
#' [`open_instance_public_ports`][lightsail_open_instance_public_ports]
#' action to open ports without closing currently open ports.
#' 
#' The [`put_instance_public_ports`][lightsail_put_instance_public_ports]
#' action supports tag-based access control via resource tags applied to
#' the resource identified by `instanceName`. For more information, see the
#' Lightsail Dev Guide.
#'
#' @usage
#' lightsail_put_instance_public_ports(portInfos, instanceName)
#'
#' @param portInfos &#91;required&#93; An array of objects to describe the ports to open for the specified
#' instance.
#' @param instanceName &#91;required&#93; The name of the instance for which to open ports.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_instance_public_ports(
#'   portInfos = list(
#'     list(
#'       fromPort = 123,
#'       toPort = 123,
#'       protocol = "tcp"|"all"|"udp"|"icmp",
#'       cidrs = list(
#'         "string"
#'       ),
#'       cidrListAliases = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_put_instance_public_ports
lightsail_put_instance_public_ports <- function(portInfos, instanceName) {
  op <- new_operation(
    name = "PutInstancePublicPorts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$put_instance_public_ports_input(portInfos = portInfos, instanceName = instanceName)
  output <- .lightsail$put_instance_public_ports_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$put_instance_public_ports <- lightsail_put_instance_public_ports

#' Restarts a specific instance
#'
#' @description
#' Restarts a specific instance.
#' 
#' The `reboot instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by `instance name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_reboot_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance to reboot.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$reboot_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_reboot_instance
lightsail_reboot_instance <- function(instanceName) {
  op <- new_operation(
    name = "RebootInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$reboot_instance_input(instanceName = instanceName)
  output <- .lightsail$reboot_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reboot_instance <- lightsail_reboot_instance

#' Restarts a specific database in Amazon Lightsail
#'
#' @description
#' Restarts a specific database in Amazon Lightsail.
#' 
#' The `reboot relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_reboot_relational_database(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to reboot.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$reboot_relational_database(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_reboot_relational_database
lightsail_reboot_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "RebootRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$reboot_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$reboot_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reboot_relational_database <- lightsail_reboot_relational_database

#' Registers a container image to your Amazon Lightsail container service
#'
#' @description
#' Registers a container image to your Amazon Lightsail container service.
#' 
#' This action is not required if you install and use the Lightsail Control
#' (lightsailctl) plugin to push container images to your Lightsail
#' container service. For more information, see Pushing and managing
#' container images on your Amazon Lightsail container services in the
#' *Lightsail Dev Guide*.
#'
#' @usage
#' lightsail_register_container_image(serviceName, label, digest)
#'
#' @param serviceName &#91;required&#93; The name of the container service for which to register a container
#' image.
#' @param label &#91;required&#93; The label for the container image when it's registered to the container
#' service.
#' 
#' Use a descriptive label that you can use to track the different versions
#' of your registered container images.
#' 
#' Use the [`get_container_images`][lightsail_get_container_images] action
#' to return the container images registered to a Lightsail container
#' service. The label is the `<imagelabel>` portion of the following image
#' name example:
#' 
#' -   `:container-service-1.<imagelabel>.1`
#' 
#' If the name of your container service is `mycontainerservice`, and the
#' label that you specify is `mystaticwebsite`, then the name of the
#' registered container image will be
#' `:mycontainerservice.mystaticwebsite.1`.
#' 
#' The number at the end of these image name examples represents the
#' version of the registered container image. If you push and register
#' another container image to the same Lightsail container service, with
#' the same label, then the version number for the new registered container
#' image will be `2`. If you push and register another container image, the
#' version number will be `3`, and so on.
#' @param digest &#91;required&#93; The digest of the container image to be registered.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   containerImage = list(
#'     image = "string",
#'     digest = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$register_container_image(
#'   serviceName = "string",
#'   label = "string",
#'   digest = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_register_container_image
lightsail_register_container_image <- function(serviceName, label, digest) {
  op <- new_operation(
    name = "RegisterContainerImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$register_container_image_input(serviceName = serviceName, label = label, digest = digest)
  output <- .lightsail$register_container_image_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$register_container_image <- lightsail_register_container_image

#' Deletes a specific static IP from your account
#'
#' @description
#' Deletes a specific static IP from your account.
#'
#' @usage
#' lightsail_release_static_ip(staticIpName)
#'
#' @param staticIpName &#91;required&#93; The name of the static IP to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$release_static_ip(
#'   staticIpName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_release_static_ip
lightsail_release_static_ip <- function(staticIpName) {
  op <- new_operation(
    name = "ReleaseStaticIp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$release_static_ip_input(staticIpName = staticIpName)
  output <- .lightsail$release_static_ip_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$release_static_ip <- lightsail_release_static_ip

#' Deletes currently cached content from your Amazon Lightsail content
#' delivery network (CDN) distribution
#'
#' @description
#' Deletes currently cached content from your Amazon Lightsail content
#' delivery network (CDN) distribution.
#' 
#' After resetting the cache, the next time a content request is made, your
#' distribution pulls, serves, and caches it from the origin.
#'
#' @usage
#' lightsail_reset_distribution_cache(distributionName)
#'
#' @param distributionName The name of the distribution for which to reset cache.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   status = "string",
#'   createTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$reset_distribution_cache(
#'   distributionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_reset_distribution_cache
lightsail_reset_distribution_cache <- function(distributionName = NULL) {
  op <- new_operation(
    name = "ResetDistributionCache",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$reset_distribution_cache_input(distributionName = distributionName)
  output <- .lightsail$reset_distribution_cache_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$reset_distribution_cache <- lightsail_reset_distribution_cache

#' Sends a verification request to an email contact method to ensure it's
#' owned by the requester
#'
#' @description
#' Sends a verification request to an email contact method to ensure it's
#' owned by the requester. SMS contact methods don't need to be verified.
#' 
#' A contact method is used to send you notifications about your Amazon
#' Lightsail resources. You can add one email address and one mobile phone
#' number contact method in each AWS Region. However, SMS text messaging is
#' not supported in some AWS Regions, and SMS text messages cannot be sent
#' to some countries/regions. For more information, see Notifications in
#' Amazon Lightsail.
#' 
#' A verification request is sent to the contact method when you initially
#' create it. Use this action to send another verification request if a
#' previous verification request was deleted, or has expired.
#' 
#' Notifications are not sent to an email contact method until after it is
#' verified, and confirmed as valid.
#'
#' @usage
#' lightsail_send_contact_method_verification(protocol)
#'
#' @param protocol &#91;required&#93; The protocol to verify, such as `Email` or `SMS` (text messaging).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$send_contact_method_verification(
#'   protocol = "Email"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_send_contact_method_verification
lightsail_send_contact_method_verification <- function(protocol) {
  op <- new_operation(
    name = "SendContactMethodVerification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$send_contact_method_verification_input(protocol = protocol)
  output <- .lightsail$send_contact_method_verification_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$send_contact_method_verification <- lightsail_send_contact_method_verification

#' Starts a specific Amazon Lightsail instance from a stopped state
#'
#' @description
#' Starts a specific Amazon Lightsail instance from a stopped state. To
#' restart an instance, use the `reboot instance` operation.
#' 
#' When you start a stopped instance, Lightsail assigns a new public IP
#' address to the instance. To use the same IP address after stopping and
#' starting an instance, create a static IP address and attach it to the
#' instance. For more information, see the Lightsail Dev Guide.
#' 
#' The `start instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by `instance name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_start_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the instance (a virtual private server) to start.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_start_instance
lightsail_start_instance <- function(instanceName) {
  op <- new_operation(
    name = "StartInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$start_instance_input(instanceName = instanceName)
  output <- .lightsail$start_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$start_instance <- lightsail_start_instance

#' Starts a specific database from a stopped state in Amazon Lightsail
#'
#' @description
#' Starts a specific database from a stopped state in Amazon Lightsail. To
#' restart a database, use the `reboot relational database` operation.
#' 
#' The `start relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_start_relational_database(relationalDatabaseName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to start.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_relational_database(
#'   relationalDatabaseName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_start_relational_database
lightsail_start_relational_database <- function(relationalDatabaseName) {
  op <- new_operation(
    name = "StartRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$start_relational_database_input(relationalDatabaseName = relationalDatabaseName)
  output <- .lightsail$start_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$start_relational_database <- lightsail_start_relational_database

#' Stops a specific Amazon Lightsail instance that is currently running
#'
#' @description
#' Stops a specific Amazon Lightsail instance that is currently running.
#' 
#' When you start a stopped instance, Lightsail assigns a new public IP
#' address to the instance. To use the same IP address after stopping and
#' starting an instance, create a static IP address and attach it to the
#' instance. For more information, see the Lightsail Dev Guide.
#' 
#' The `stop instance` operation supports tag-based access control via
#' resource tags applied to the resource identified by `instance name`. For
#' more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_stop_instance(instanceName, force)
#'
#' @param instanceName &#91;required&#93; The name of the instance (a virtual private server) to stop.
#' @param force When set to `True`, forces a Lightsail instance that is stuck in a
#' `stopping` state to stop.
#' 
#' Only use the `force` parameter if your instance is stuck in the
#' `stopping` state. In any other state, your instance should stop normally
#' without adding this parameter to your API request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_instance(
#'   instanceName = "string",
#'   force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_stop_instance
lightsail_stop_instance <- function(instanceName, force = NULL) {
  op <- new_operation(
    name = "StopInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$stop_instance_input(instanceName = instanceName, force = force)
  output <- .lightsail$stop_instance_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$stop_instance <- lightsail_stop_instance

#' Stops a specific database that is currently running in Amazon Lightsail
#'
#' @description
#' Stops a specific database that is currently running in Amazon Lightsail.
#' 
#' The `stop relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_stop_relational_database(relationalDatabaseName,
#'   relationalDatabaseSnapshotName)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to stop.
#' @param relationalDatabaseSnapshotName The name of your new database snapshot to be created before stopping
#' your database.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_relational_database(
#'   relationalDatabaseName = "string",
#'   relationalDatabaseSnapshotName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_stop_relational_database
lightsail_stop_relational_database <- function(relationalDatabaseName, relationalDatabaseSnapshotName = NULL) {
  op <- new_operation(
    name = "StopRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$stop_relational_database_input(relationalDatabaseName = relationalDatabaseName, relationalDatabaseSnapshotName = relationalDatabaseSnapshotName)
  output <- .lightsail$stop_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$stop_relational_database <- lightsail_stop_relational_database

#' Adds one or more tags to the specified Amazon Lightsail resource
#'
#' @description
#' Adds one or more tags to the specified Amazon Lightsail resource. Each
#' resource can have a maximum of 50 tags. Each tag consists of a key and
#' an optional value. Tag keys must be unique per resource. For more
#' information about tags, see the Lightsail Dev Guide.
#' 
#' The `tag resource` operation supports tag-based access control via
#' request tags and resource tags applied to the resource identified by
#' `resource name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_tag_resource(resourceName, resourceArn, tags)
#'
#' @param resourceName &#91;required&#93; The name of the resource to which you are adding tags.
#' @param resourceArn The Amazon Resource Name (ARN) of the resource to which you want to add
#' a tag.
#' @param tags &#91;required&#93; The tag key and optional value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceName = "string",
#'   resourceArn = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_tag_resource
lightsail_tag_resource <- function(resourceName, resourceArn = NULL, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$tag_resource_input(resourceName = resourceName, resourceArn = resourceArn, tags = tags)
  output <- .lightsail$tag_resource_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$tag_resource <- lightsail_tag_resource

#' Tests an alarm by displaying a banner on the Amazon Lightsail console
#'
#' @description
#' Tests an alarm by displaying a banner on the Amazon Lightsail console.
#' If a notification trigger is configured for the specified alarm, the
#' test also sends a notification to the notification protocol (`Email`
#' and/or `SMS`) configured for the alarm.
#' 
#' An alarm is used to monitor a single metric for one of your resources.
#' When a metric condition is met, the alarm can notify you by email, SMS
#' text message, and a banner displayed on the Amazon Lightsail console.
#' For more information, see Alarms in Amazon Lightsail.
#'
#' @usage
#' lightsail_test_alarm(alarmName, state)
#'
#' @param alarmName &#91;required&#93; The name of the alarm to test.
#' @param state &#91;required&#93; The alarm state to test.
#' 
#' An alarm has the following possible states that can be tested:
#' 
#' -   `ALARM` - The metric is outside of the defined threshold.
#' 
#' -   `INSUFFICIENT_DATA` - The alarm has just started, the metric is not
#'     available, or not enough data is available for the metric to
#'     determine the alarm state.
#' 
#' -   `OK` - The metric is within the defined threshold.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$test_alarm(
#'   alarmName = "string",
#'   state = "OK"|"ALARM"|"INSUFFICIENT_DATA"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_test_alarm
lightsail_test_alarm <- function(alarmName, state) {
  op <- new_operation(
    name = "TestAlarm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$test_alarm_input(alarmName = alarmName, state = state)
  output <- .lightsail$test_alarm_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$test_alarm <- lightsail_test_alarm

#' Attempts to unpeer the Lightsail VPC from the user's default VPC
#'
#' @description
#' Attempts to unpeer the Lightsail VPC from the user's default VPC.
#'
#' @usage
#' lightsail_unpeer_vpc()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$unpeer_vpc()
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_unpeer_vpc
lightsail_unpeer_vpc <- function() {
  op <- new_operation(
    name = "UnpeerVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$unpeer_vpc_input()
  output <- .lightsail$unpeer_vpc_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$unpeer_vpc <- lightsail_unpeer_vpc

#' Deletes the specified set of tag keys and their values from the
#' specified Amazon Lightsail resource
#'
#' @description
#' Deletes the specified set of tag keys and their values from the
#' specified Amazon Lightsail resource.
#' 
#' The `untag resource` operation supports tag-based access control via
#' request tags and resource tags applied to the resource identified by
#' `resource name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_untag_resource(resourceName, resourceArn, tagKeys)
#'
#' @param resourceName &#91;required&#93; The name of the resource from which you are removing a tag.
#' @param resourceArn The Amazon Resource Name (ARN) of the resource from which you want to
#' remove a tag.
#' @param tagKeys &#91;required&#93; The tag keys to delete from the specified resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceName = "string",
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_untag_resource
lightsail_untag_resource <- function(resourceName, resourceArn = NULL, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$untag_resource_input(resourceName = resourceName, resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .lightsail$untag_resource_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$untag_resource <- lightsail_untag_resource

#' Updates the configuration of your Amazon Lightsail container service,
#' such as its power, scale, and public domain names
#'
#' @description
#' Updates the configuration of your Amazon Lightsail container service,
#' such as its power, scale, and public domain names.
#'
#' @usage
#' lightsail_update_container_service(serviceName, power, scale,
#'   isDisabled, publicDomainNames)
#'
#' @param serviceName &#91;required&#93; The name of the container service to update.
#' @param power The power for the container service.
#' 
#' The power specifies the amount of memory, vCPUs, and base monthly cost
#' of each node of the container service. The `power` and `scale` of a
#' container service makes up its configured capacity. To determine the
#' monthly price of your container service, multiply the base price of the
#' `power` with the `scale` (the number of nodes) of the service.
#' 
#' Use the
#' [`get_container_service_powers`][lightsail_get_container_service_powers]
#' action to view the specifications of each power option.
#' @param scale The scale for the container service.
#' 
#' The scale specifies the allocated compute nodes of the container
#' service. The `power` and `scale` of a container service makes up its
#' configured capacity. To determine the monthly price of your container
#' service, multiply the base price of the `power` with the `scale` (the
#' number of nodes) of the service.
#' @param isDisabled A Boolean value to indicate whether the container service is disabled.
#' @param publicDomainNames The public domain names to use with the container service, such as
#' `example.com` and `www.example.com`.
#' 
#' You can specify up to four public domain names for a container service.
#' The domain names that you specify are used when you create a deployment
#' with a container configured as the public endpoint of your container
#' service.
#' 
#' If you don't specify public domain names, then you can use the default
#' domain of the container service.
#' 
#' You must create and validate an SSL/TLS certificate before you can use
#' public domain names with your container service. Use the
#' [`create_certificate`][lightsail_create_certificate] action to create a
#' certificate for the public domain names you want to use with your
#' container service.
#' 
#' You can specify public domain names using a string to array map as shown
#' in the example later on this page.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   containerService = list(
#'     containerServiceName = "string",
#'     arn = "string",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
#'     powerId = "string",
#'     state = "PENDING"|"READY"|"RUNNING"|"UPDATING"|"DELETING"|"DISABLED",
#'     scale = 123,
#'     currentDeployment = list(
#'       version = 123,
#'       state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'       containers = list(
#'         list(
#'           image = "string",
#'           command = list(
#'             "string"
#'           ),
#'           environment = list(
#'             "string"
#'           ),
#'           ports = list(
#'             "HTTP"|"HTTPS"|"TCP"|"UDP"
#'           )
#'         )
#'       ),
#'       publicEndpoint = list(
#'         containerName = "string",
#'         containerPort = 123,
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           unhealthyThreshold = 123,
#'           timeoutSeconds = 123,
#'           intervalSeconds = 123,
#'           path = "string",
#'           successCodes = "string"
#'         )
#'       ),
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     nextDeployment = list(
#'       version = 123,
#'       state = "ACTIVATING"|"ACTIVE"|"INACTIVE"|"FAILED",
#'       containers = list(
#'         list(
#'           image = "string",
#'           command = list(
#'             "string"
#'           ),
#'           environment = list(
#'             "string"
#'           ),
#'           ports = list(
#'             "HTTP"|"HTTPS"|"TCP"|"UDP"
#'           )
#'         )
#'       ),
#'       publicEndpoint = list(
#'         containerName = "string",
#'         containerPort = 123,
#'         healthCheck = list(
#'           healthyThreshold = 123,
#'           unhealthyThreshold = 123,
#'           timeoutSeconds = 123,
#'           intervalSeconds = 123,
#'           path = "string",
#'           successCodes = "string"
#'         )
#'       ),
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     isDisabled = TRUE|FALSE,
#'     principalArn = "string",
#'     privateDomainName = "string",
#'     publicDomainNames = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     url = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_container_service(
#'   serviceName = "string",
#'   power = "nano"|"micro"|"small"|"medium"|"large"|"xlarge",
#'   scale = 123,
#'   isDisabled = TRUE|FALSE,
#'   publicDomainNames = list(
#'     list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_container_service
lightsail_update_container_service <- function(serviceName, power = NULL, scale = NULL, isDisabled = NULL, publicDomainNames = NULL) {
  op <- new_operation(
    name = "UpdateContainerService",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_container_service_input(serviceName = serviceName, power = power, scale = scale, isDisabled = isDisabled, publicDomainNames = publicDomainNames)
  output <- .lightsail$update_container_service_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_container_service <- lightsail_update_container_service

#' Updates an existing Amazon Lightsail content delivery network (CDN)
#' distribution
#'
#' @description
#' Updates an existing Amazon Lightsail content delivery network (CDN)
#' distribution.
#' 
#' Use this action to update the configuration of your existing
#' distribution
#'
#' @usage
#' lightsail_update_distribution(distributionName, origin,
#'   defaultCacheBehavior, cacheBehaviorSettings, cacheBehaviors, isEnabled)
#'
#' @param distributionName &#91;required&#93; The name of the distribution to update.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param origin An object that describes the origin resource for the distribution, such
#' as a Lightsail instance or load balancer.
#' 
#' The distribution pulls, caches, and serves content from the origin.
#' @param defaultCacheBehavior An object that describes the default cache behavior for the
#' distribution.
#' @param cacheBehaviorSettings An object that describes the cache behavior settings for the
#' distribution.
#' 
#' The `cacheBehaviorSettings` specified in your
#' `UpdateDistributionRequest` will replace your distribution's existing
#' settings.
#' @param cacheBehaviors An array of objects that describe the per-path cache behavior for the
#' distribution.
#' @param isEnabled Indicates whether to enable the distribution.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_distribution(
#'   distributionName = "string",
#'   origin = list(
#'     name = "string",
#'     regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2",
#'     protocolPolicy = "http-only"|"https-only"
#'   ),
#'   defaultCacheBehavior = list(
#'     behavior = "dont-cache"|"cache"
#'   ),
#'   cacheBehaviorSettings = list(
#'     defaultTTL = 123,
#'     minimumTTL = 123,
#'     maximumTTL = 123,
#'     allowedHTTPMethods = "string",
#'     cachedHTTPMethods = "string",
#'     forwardedCookies = list(
#'       option = "none"|"allow-list"|"all",
#'       cookiesAllowList = list(
#'         "string"
#'       )
#'     ),
#'     forwardedHeaders = list(
#'       option = "none"|"allow-list"|"all",
#'       headersAllowList = list(
#'         "Accept"|"Accept-Charset"|"Accept-Datetime"|"Accept-Encoding"|"Accept-Language"|"Authorization"|"CloudFront-Forwarded-Proto"|"CloudFront-Is-Desktop-Viewer"|"CloudFront-Is-Mobile-Viewer"|"CloudFront-Is-SmartTV-Viewer"|"CloudFront-Is-Tablet-Viewer"|"CloudFront-Viewer-Country"|"Host"|"Origin"|"Referer"
#'       )
#'     ),
#'     forwardedQueryStrings = list(
#'       option = TRUE|FALSE,
#'       queryStringsAllowList = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   cacheBehaviors = list(
#'     list(
#'       path = "string",
#'       behavior = "dont-cache"|"cache"
#'     )
#'   ),
#'   isEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_distribution
lightsail_update_distribution <- function(distributionName, origin = NULL, defaultCacheBehavior = NULL, cacheBehaviorSettings = NULL, cacheBehaviors = NULL, isEnabled = NULL) {
  op <- new_operation(
    name = "UpdateDistribution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_distribution_input(distributionName = distributionName, origin = origin, defaultCacheBehavior = defaultCacheBehavior, cacheBehaviorSettings = cacheBehaviorSettings, cacheBehaviors = cacheBehaviors, isEnabled = isEnabled)
  output <- .lightsail$update_distribution_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_distribution <- lightsail_update_distribution

#' Updates the bundle of your Amazon Lightsail content delivery network
#' (CDN) distribution
#'
#' @description
#' Updates the bundle of your Amazon Lightsail content delivery network
#' (CDN) distribution.
#' 
#' A distribution bundle specifies the monthly network transfer quota and
#' monthly cost of your dsitribution.
#' 
#' Update your distribution's bundle if your distribution is going over its
#' monthly network transfer quota and is incurring an overage fee.
#' 
#' You can update your distribution's bundle only one time within your
#' monthly AWS billing cycle. To determine if you can update your
#' distribution's bundle, use the
#' [`get_distributions`][lightsail_get_distributions] action. The
#' `ableToUpdateBundle` parameter in the result will indicate whether you
#' can currently update your distribution's bundle.
#'
#' @usage
#' lightsail_update_distribution_bundle(distributionName, bundleId)
#'
#' @param distributionName The name of the distribution for which to update the bundle.
#' 
#' Use the [`get_distributions`][lightsail_get_distributions] action to get
#' a list of distribution names that you can specify.
#' @param bundleId The bundle ID of the new bundle to apply to your distribution.
#' 
#' Use the [`get_distribution_bundles`][lightsail_get_distribution_bundles]
#' action to get a list of distribution bundle IDs that you can specify.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operation = list(
#'     id = "string",
#'     resourceName = "string",
#'     resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'     createdAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     location = list(
#'       availabilityZone = "string",
#'       regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'     ),
#'     isTerminal = TRUE|FALSE,
#'     operationDetails = "string",
#'     operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'     status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'     statusChangedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     errorCode = "string",
#'     errorDetails = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_distribution_bundle(
#'   distributionName = "string",
#'   bundleId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_distribution_bundle
lightsail_update_distribution_bundle <- function(distributionName = NULL, bundleId = NULL) {
  op <- new_operation(
    name = "UpdateDistributionBundle",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_distribution_bundle_input(distributionName = distributionName, bundleId = bundleId)
  output <- .lightsail$update_distribution_bundle_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_distribution_bundle <- lightsail_update_distribution_bundle

#' Updates a domain recordset after it is created
#'
#' @description
#' Updates a domain recordset after it is created.
#' 
#' The `update domain entry` operation supports tag-based access control
#' via resource tags applied to the resource identified by `domain name`.
#' For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_update_domain_entry(domainName, domainEntry)
#'
#' @param domainName &#91;required&#93; The name of the domain recordset to update.
#' @param domainEntry &#91;required&#93; An array of key-value pairs containing information about the domain
#' entry.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_domain_entry(
#'   domainName = "string",
#'   domainEntry = list(
#'     id = "string",
#'     name = "string",
#'     target = "string",
#'     isAlias = TRUE|FALSE,
#'     type = "string",
#'     options = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_domain_entry
lightsail_update_domain_entry <- function(domainName, domainEntry) {
  op <- new_operation(
    name = "UpdateDomainEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_domain_entry_input(domainName = domainName, domainEntry = domainEntry)
  output <- .lightsail$update_domain_entry_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_domain_entry <- lightsail_update_domain_entry

#' Updates the specified attribute for a load balancer
#'
#' @description
#' Updates the specified attribute for a load balancer. You can only update
#' one attribute at a time.
#' 
#' The `update load balancer attribute` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' `load balancer name`. For more information, see the Lightsail Dev Guide.
#'
#' @usage
#' lightsail_update_load_balancer_attribute(loadBalancerName,
#'   attributeName, attributeValue)
#'
#' @param loadBalancerName &#91;required&#93; The name of the load balancer that you want to modify (e.g.,
#' `my-load-balancer`.
#' @param attributeName &#91;required&#93; The name of the attribute you want to update. Valid values are below.
#' @param attributeValue &#91;required&#93; The value that you want to specify for the attribute name.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_load_balancer_attribute(
#'   loadBalancerName = "string",
#'   attributeName = "HealthCheckPath"|"SessionStickinessEnabled"|"SessionStickiness_LB_CookieDurationSeconds",
#'   attributeValue = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_load_balancer_attribute
lightsail_update_load_balancer_attribute <- function(loadBalancerName, attributeName, attributeValue) {
  op <- new_operation(
    name = "UpdateLoadBalancerAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_load_balancer_attribute_input(loadBalancerName = loadBalancerName, attributeName = attributeName, attributeValue = attributeValue)
  output <- .lightsail$update_load_balancer_attribute_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_load_balancer_attribute <- lightsail_update_load_balancer_attribute

#' Allows the update of one or more attributes of a database in Amazon
#' Lightsail
#'
#' @description
#' Allows the update of one or more attributes of a database in Amazon
#' Lightsail.
#' 
#' Updates are applied immediately, or in cases where the updates could
#' result in an outage, are applied during the database's predefined
#' maintenance window.
#' 
#' The `update relational database` operation supports tag-based access
#' control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_update_relational_database(relationalDatabaseName,
#'   masterUserPassword, rotateMasterUserPassword, preferredBackupWindow,
#'   preferredMaintenanceWindow, enableBackupRetention,
#'   disableBackupRetention, publiclyAccessible, applyImmediately,
#'   caCertificateIdentifier)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database to update.
#' @param masterUserPassword The password for the master user of your database. The password can
#' include any printable ASCII character except "/", """, or "@@".
#' 
#' Constraints: Must contain 8 to 41 characters.
#' @param rotateMasterUserPassword When `true`, the master user password is changed to a new strong
#' password generated by Lightsail.
#' 
#' Use the `get relational database master user password` operation to get
#' the new password.
#' @param preferredBackupWindow The daily time range during which automated backups are created for your
#' database if automated backups are enabled.
#' 
#' Constraints:
#' 
#' -   Must be in the `hh24:mi-hh24:mi` format.
#' 
#'     Example: `16:00-16:30`
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Must not conflict with the preferred maintenance window.
#' 
#' -   Must be at least 30 minutes.
#' @param preferredMaintenanceWindow The weekly time range during which system maintenance can occur on your
#' database.
#' 
#' The default is a 30-minute window selected at random from an 8-hour
#' block of time for each AWS Region, occurring on a random day of the
#' week.
#' 
#' Constraints:
#' 
#' -   Must be in the `ddd:hh24:mi-ddd:hh24:mi` format.
#' 
#' -   Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
#' 
#' -   Must be at least 30 minutes.
#' 
#' -   Specified in Coordinated Universal Time (UTC).
#' 
#' -   Example: `Tue:17:00-Tue:17:30`
#' @param enableBackupRetention When `true`, enables automated backup retention for your database.
#' 
#' Updates are applied during the next maintenance window because this can
#' result in an outage.
#' @param disableBackupRetention When `true`, disables automated backup retention for your database.
#' 
#' Disabling backup retention deletes all automated database backups.
#' Before disabling this, you may want to create a snapshot of your
#' database using the `create relational database snapshot` operation.
#' 
#' Updates are applied during the next maintenance window because this can
#' result in an outage.
#' @param publiclyAccessible Specifies the accessibility options for your database. A value of `true`
#' specifies a database that is available to resources outside of your
#' Lightsail account. A value of `false` specifies a database that is
#' available only to your Lightsail resources in the same region as your
#' database.
#' @param applyImmediately When `true`, applies changes immediately. When `false`, applies changes
#' during the preferred maintenance window. Some changes may cause an
#' outage.
#' 
#' Default: `false`
#' @param caCertificateIdentifier Indicates the certificate that needs to be associated with the database.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_relational_database(
#'   relationalDatabaseName = "string",
#'   masterUserPassword = "string",
#'   rotateMasterUserPassword = TRUE|FALSE,
#'   preferredBackupWindow = "string",
#'   preferredMaintenanceWindow = "string",
#'   enableBackupRetention = TRUE|FALSE,
#'   disableBackupRetention = TRUE|FALSE,
#'   publiclyAccessible = TRUE|FALSE,
#'   applyImmediately = TRUE|FALSE,
#'   caCertificateIdentifier = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_relational_database
lightsail_update_relational_database <- function(relationalDatabaseName, masterUserPassword = NULL, rotateMasterUserPassword = NULL, preferredBackupWindow = NULL, preferredMaintenanceWindow = NULL, enableBackupRetention = NULL, disableBackupRetention = NULL, publiclyAccessible = NULL, applyImmediately = NULL, caCertificateIdentifier = NULL) {
  op <- new_operation(
    name = "UpdateRelationalDatabase",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_relational_database_input(relationalDatabaseName = relationalDatabaseName, masterUserPassword = masterUserPassword, rotateMasterUserPassword = rotateMasterUserPassword, preferredBackupWindow = preferredBackupWindow, preferredMaintenanceWindow = preferredMaintenanceWindow, enableBackupRetention = enableBackupRetention, disableBackupRetention = disableBackupRetention, publiclyAccessible = publiclyAccessible, applyImmediately = applyImmediately, caCertificateIdentifier = caCertificateIdentifier)
  output <- .lightsail$update_relational_database_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_relational_database <- lightsail_update_relational_database

#' Allows the update of one or more parameters of a database in Amazon
#' Lightsail
#'
#' @description
#' Allows the update of one or more parameters of a database in Amazon
#' Lightsail.
#' 
#' Parameter updates don't cause outages; therefore, their application is
#' not subject to the preferred maintenance window. However, there are two
#' ways in which parameter updates are applied: `dynamic` or
#' `pending-reboot`. Parameters marked with a `dynamic` apply type are
#' applied immediately. Parameters marked with a `pending-reboot` apply
#' type are applied only after the database is rebooted using the
#' `reboot relational database` operation.
#' 
#' The `update relational database parameters` operation supports tag-based
#' access control via resource tags applied to the resource identified by
#' relationalDatabaseName. For more information, see the Lightsail Dev
#' Guide.
#'
#' @usage
#' lightsail_update_relational_database_parameters(relationalDatabaseName,
#'   parameters)
#'
#' @param relationalDatabaseName &#91;required&#93; The name of your database for which to update parameters.
#' @param parameters &#91;required&#93; The database parameters to update.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   operations = list(
#'     list(
#'       id = "string",
#'       resourceName = "string",
#'       resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
#'       createdAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       location = list(
#'         availabilityZone = "string",
#'         regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
#'       ),
#'       isTerminal = TRUE|FALSE,
#'       operationDetails = "string",
#'       operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
#'       status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
#'       statusChangedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       errorCode = "string",
#'       errorDetails = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_relational_database_parameters(
#'   relationalDatabaseName = "string",
#'   parameters = list(
#'     list(
#'       allowedValues = "string",
#'       applyMethod = "string",
#'       applyType = "string",
#'       dataType = "string",
#'       description = "string",
#'       isModifiable = TRUE|FALSE,
#'       parameterName = "string",
#'       parameterValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname lightsail_update_relational_database_parameters
lightsail_update_relational_database_parameters <- function(relationalDatabaseName, parameters) {
  op <- new_operation(
    name = "UpdateRelationalDatabaseParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .lightsail$update_relational_database_parameters_input(relationalDatabaseName = relationalDatabaseName, parameters = parameters)
  output <- .lightsail$update_relational_database_parameters_output()
  config <- get_config()
  svc <- .lightsail$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lightsail$operations$update_relational_database_parameters <- lightsail_update_relational_database_parameters
