% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_open_instance_public_ports}
\alias{lightsail_open_instance_public_ports}
\title{Opens ports for a specific Amazon Lightsail instance, and specifies the
IP addresses allowed to connect to the instance through the ports, and
the protocol}
\usage{
lightsail_open_instance_public_ports(portInfo, instanceName)
}
\arguments{
\item{portInfo}{[required] An object to describe the ports to open for the specified instance.}

\item{instanceName}{[required] The name of the instance for which to open ports.}
}
\description{
Opens ports for a specific Amazon Lightsail instance, and specifies the
IP addresses allowed to connect to the instance through the ports, and
the protocol.

The \code{OpenInstancePublicPorts} action supports tag-based access control
via resource tags applied to the resource identified by \code{instanceName}.
For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$open_instance_public_ports(
  portInfo = list(
    fromPort = 123,
    toPort = 123,
    protocol = "tcp"|"all"|"udp"|"icmp",
    cidrs = list(
      "string"
    ),
    cidrListAliases = list(
      "string"
    )
  ),
  instanceName = "string"
)
}
}

\keyword{internal}
