% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_blueprints}
\alias{lightsail_get_blueprints}
\title{Returns the list of available instance images, or blueprints}
\usage{
lightsail_get_blueprints(includeInactive, pageToken)
}
\arguments{
\item{includeInactive}{A Boolean value indicating whether to include inactive results in your
request.}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial \code{GetBlueprints} request. If your
results are paginated, the response will return a next page token that
you can specify as the page token in a subsequent request.}
}
\description{
Returns the list of available instance images, or \emph{blueprints}. You can
use a blueprint to create a new instance already running a specific
operating system, as well as a preinstalled app or development stack.
The software each instance is running depends on the blueprint image you
choose.

Use active blueprints when creating new instances. Inactive blueprints
are listed to support customers with existing instances and are not
necessarily available to create new instances. Blueprints are marked
inactive when they become outdated due to operating system updates or
new application releases.
}
\section{Request syntax}{
\preformatted{svc$get_blueprints(
  includeInactive = TRUE|FALSE,
  pageToken = "string"
)
}
}

\keyword{internal}
