% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_groups_for_capacity_reservation}
\alias{ec2_get_groups_for_capacity_reservation}
\title{Lists the resource groups to which a Capacity Reservation has been added}
\usage{
ec2_get_groups_for_capacity_reservation(CapacityReservationId,
  NextToken, MaxResults, DryRun)
}
\arguments{
\item{CapacityReservationId}{[required] The ID of the Capacity Reservation.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned \code{nextToken} value. This value can be between 5 and 500. If
\code{maxResults} is given a larger value than 500, you receive an error.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Lists the resource groups to which a Capacity Reservation has been
added.
}
\section{Request syntax}{
\preformatted{svc$get_groups_for_capacity_reservation(
  CapacityReservationId = "string",
  NextToken = "string",
  MaxResults = 123,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
