% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_snapshots}
\alias{ec2_describe_snapshots}
\title{Describes one or more of the EBS snapshots available to you}
\usage{
ec2_describe_snapshots(Filters, MaxResults, NextToken, OwnerIds,
  RestorableByUserIds, SnapshotIds, DryRun)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{description} - A description of the snapshot.
\item \code{owner-alias} - Value from an Amazon-maintained list (\code{amazon} \|
\code{aws-marketplace} \| \code{microsoft}) of snapshot owners. Not to be
confused with the user-configured AWS account alias, which is set
from the IAM console.
\item \code{owner-id} - The ID of the AWS account that owns the snapshot.
\item \code{progress} - The progress of the snapshot, as a percentage (for
example, 80\%).
\item \code{snapshot-id} - The snapshot ID.
\item \code{start-time} - The time stamp when the snapshot was initiated.
\item \code{status} - The status of the snapshot (\code{pending} \| \code{completed} \|
\code{error}).
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{volume-id} - The ID of the volume the snapshot is for.
\item \code{volume-size} - The size of the volume, in GiB.
}}

\item{MaxResults}{The maximum number of snapshot results returned by \code{DescribeSnapshots}
in paginated output. When this parameter is used, \code{DescribeSnapshots}
only returns \code{MaxResults} results in a single page along with a
\code{NextToken} response element. The remaining results of the initial
request can be seen by sending another \code{DescribeSnapshots} request with
the returned \code{NextToken} value. This value can be between 5 and 1000; if
\code{MaxResults} is given a value larger than 1000, only 1000 results are
returned. If this parameter is not used, then \code{DescribeSnapshots}
returns all results. You cannot specify this parameter and the snapshot
IDs parameter in the same request.}

\item{NextToken}{The \code{NextToken} value returned from a previous paginated
\code{DescribeSnapshots} request where \code{MaxResults} was used and the results
exceeded the value of that parameter. Pagination continues from the end
of the previous results that returned the \code{NextToken} value. This value
is \code{null} when there are no more results to return.}

\item{OwnerIds}{Describes the snapshots owned by one or more owners.}

\item{RestorableByUserIds}{One or more AWS accounts IDs that can create volumes from the snapshot.}

\item{SnapshotIds}{One or more snapshot IDs.

Default: Describes the snapshots for which you have create volume
permissions.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more of the EBS snapshots available to you. Available
snapshots include public snapshots available for use by any AWS account,
private snapshots that you own, and private snapshots owned by another
AWS account for which you've been given explicit create volume
permissions.
}
\details{
The create volume permissions fall into the following categories:
\itemize{
\item \emph{public}: The owner of the snapshot granted create volume
permissions for the snapshot to the \code{all} group. All AWS accounts
have create volume permissions for these snapshots.
\item \emph{explicit}: The owner of the snapshot granted create volume
permissions to a specific AWS account.
\item \emph{implicit}: An AWS account has implicit create volume permissions
for all snapshots it owns.
}

The list of snapshots returned can be modified by specifying snapshot
IDs, snapshot owners, or AWS accounts with create volume permissions. If
no options are specified, Amazon EC2 returns all snapshots for which you
have create volume permissions.

If you specify one or more snapshot IDs, only snapshots that have the
specified IDs are returned. If you specify an invalid snapshot ID, an
error is returned. If you specify a snapshot ID for which you do not
have access, it is not included in the returned results.

If you specify one or more snapshot owners using the \code{OwnerIds} option,
only snapshots from the specified owners and for which you have access
are returned. The results can include the AWS account IDs of the
specified owners, \code{amazon} for snapshots owned by Amazon, or \code{self} for
snapshots that you own.

If you specify a list of restorable users, only snapshots with create
snapshot permissions for those users are returned. You can specify AWS
account IDs (if you own the snapshots), \code{self} for snapshots for which
you own or have explicit permissions, or \code{all} for public snapshots.

If you are describing a long list of snapshots, you can paginate the
output to make the list more manageable. The \code{MaxResults} parameter sets
the maximum number of results returned in a single page. If the list of
results exceeds your \code{MaxResults} value, then that number of results is
returned along with a \code{NextToken} value that can be passed to a
subsequent \code{DescribeSnapshots} request to retrieve the remaining
results.

For more information about EBS snapshots, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html}{Amazon EBS Snapshots}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_snapshots(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  OwnerIds = list(
    "string"
  ),
  RestorableByUserIds = list(
    "string"
  ),
  SnapshotIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example describes a snapshot with the snapshot ID of
# ``snap-1234567890abcdef0``.
\donttest{svc$describe_snapshots(
  SnapshotIds = list(
    "snap-1234567890abcdef0"
  )
)}

# This example describes all snapshots owned by the ID 012345678910 that
# are in the ``pending`` status.
\donttest{svc$describe_snapshots(
  Filters = list(
    list(
      Name = "status",
      Values = list(
        "pending"
      )
    )
  ),
  OwnerIds = list(
    "012345678910"
  )
)}

}
\keyword{internal}
