% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_volume}
\alias{ec2_create_volume}
\title{Creates an EBS volume that can be attached to an instance in the same
Availability Zone}
\usage{
ec2_create_volume(AvailabilityZone, Encrypted, Iops, KmsKeyId, Size,
  SnapshotId, VolumeType, DryRun, TagSpecifications)
}
\arguments{
\item{AvailabilityZone}{[required] The Availability Zone in which to create the volume. Use
DescribeAvailabilityZones to list the Availability Zones that are
currently available to you.}

\item{Encrypted}{Specifies whether the volume should be encrypted. Encrypted Amazon EBS
volumes may only be attached to instances that support Amazon EBS
encryption. Volumes that are created from encrypted snapshots are
automatically encrypted. There is no way to create an encrypted volume
from an unencrypted snapshot or vice versa. If your AMI uses encrypted
volumes, you can only launch it on supported instance types. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{Iops}{The number of I/O operations per second (IOPS) to provision for the
volume, with a maximum ratio of 50 IOPS/GiB. Range is 100 to 64,000 IOPS
for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed only
on \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances}{Nitro-based instances}.
Other instance families guarantee performance up to 32,000 IOPS. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html}{Amazon EBS Volume Types}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

This parameter is valid only for Provisioned IOPS SSD (io1) volumes.}

\item{KmsKeyId}{An identifier for the AWS Key Management Service (AWS KMS) customer
master key (CMK) to use when creating the encrypted volume. This
parameter is only required if you want to use a non-default CMK; if this
parameter is not specified, the default CMK for EBS is used. If a
\code{KmsKeyId} is specified, the \code{Encrypted} flag must also be set.

The CMK identifier may be provided in any of the following formats:
\itemize{
\item Key ID
\item Key alias
\item ARN using key ID. The ID ARN contains the \code{arn:aws:kms} namespace,
followed by the region of the CMK, the AWS account ID of the CMK
owner, the \code{key} namespace, and then the CMK ID. For example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:key/\emph{abcd1234-a123-456a-a12b-a123b4cd56ef}.
\item ARN using key alias. The alias ARN contains the \code{arn:aws:kms}
namespace, followed by the region of the CMK, the AWS account ID of
the CMK owner, the \code{alias} namespace, and then the CMK alias. For
example,
arn:aws:kms:\emph{us-east-1}:\emph{012345678910}:alias/\emph{ExampleAlias}.
}

AWS parses \code{KmsKeyId} asynchronously, meaning that the action you call
may appear to complete even though you provided an invalid identifier.
The action will eventually fail.}

\item{Size}{The size of the volume, in GiBs.

Constraints: 1-16,384 for \code{gp2}, 4-16,384 for \code{io1}, 500-16,384 for
\code{st1}, 500-16,384 for \code{sc1}, and 1-1,024 for \code{standard}. If you specify
a snapshot, the volume size must be equal to or larger than the snapshot
size.

Default: If you're creating the volume from a snapshot and don't
specify a volume size, the default is the snapshot size.

At least one of Size or SnapshotId are required.}

\item{SnapshotId}{The snapshot from which to create the volume.

At least one of Size or SnapshotId are required.}

\item{VolumeType}{The volume type. This can be \code{gp2} for General Purpose SSD, \code{io1} for
Provisioned IOPS SSD, \code{st1} for Throughput Optimized HDD, \code{sc1} for Cold
HDD, or \code{standard} for Magnetic volumes.

Defaults: If no volume type is specified, the default is \code{standard} in
us-east-1, eu-west-1, eu-central-1, us-west-2, us-west-1, sa-east-1,
ap-northeast-1, ap-northeast-2, ap-southeast-1, ap-southeast-2,
ap-south-1, us-gov-west-1, and cn-north-1. In all other Regions, EBS
defaults to \code{gp2}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{TagSpecifications}{The tags to apply to the volume during creation.}
}
\description{
Creates an EBS volume that can be attached to an instance in the same
Availability Zone. The volume is created in the regional endpoint that
you send the HTTP request to. For more information see \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{Regions and Endpoints}.
}
\details{
You can create a new empty volume or restore a volume from an EBS
snapshot. Any AWS Marketplace product codes from the snapshot are
propagated to the volume.

You can create encrypted volumes with the \code{Encrypted} parameter.
Encrypted volumes may only be attached to instances that support Amazon
EBS encryption. Volumes that are created from encrypted snapshots are
also automatically encrypted. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html}{Amazon EBS Encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

You can tag your volumes during creation. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html}{Tagging Your Amazon EC2 Resources}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html}{Creating an Amazon EBS Volume}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_volume(
  AvailabilityZone = "string",
  Encrypted = TRUE|FALSE,
  Iops = 123,
  KmsKeyId = "string",
  Size = 123,
  SnapshotId = "string",
  VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1",
  DryRun = TRUE|FALSE,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-instances-request"|"subnet"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\examples{
# This example creates an 80 GiB General Purpose (SSD) volume in the
# Availability Zone ``us-east-1a``.
\donttest{svc$create_volume(
  AvailabilityZone = "us-east-1a",
  Size = 80L,
  VolumeType = "gp2"
)}

# This example creates a new Provisioned IOPS (SSD) volume with 1000
# provisioned IOPS from a snapshot in the Availability Zone
# ``us-east-1a``.
\donttest{svc$create_volume(
  AvailabilityZone = "us-east-1a",
  Iops = 1000L,
  SnapshotId = "snap-066877671789bd71b",
  VolumeType = "io1"
)}

}
\keyword{internal}
