% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_phewas.R
\name{plot_phewas}
\alias{plot_phewas}
\title{Plot \code{PheWAS()} results.}
\usage{
plot_phewas(
  data,
  disease = TRUE,
  source = c("GCST", "FINNGEN", "NEALE", "SAIGE")
)
}
\arguments{
\item{data}{Data Frame: The result of the \code{PheWAS()} function in data frame format, containing the PheWAS information for a selected variant ID.}

\item{disease}{Logical: A logical variable indicating whether to filter the PheWAS data for disease (default: TRUE).}

\item{source}{Character vector: Choices for the data sources of PheWAS analysis, including FINNGEN, GCST, NEALE (UKBiobank), and SAIGE.}
}
\value{
A plot to prioritize variants based on their -log10(p-value).
}
\description{
This plot visualizes which traits are associated with the user's selected variant in the UK Biobank,
FinnGen, and/or GWAS Catalog summary statistics repository based on PheWAS analysis.
The associated traits are mapped onto the \emph{x-axis}, and their corresponding -log10(p-value) values are plotted on the \emph{y-axis}.
A horizontal line is shown at a p-value cutoff of 0.005 to indicate significant associations.
Associations above this cutoff are labeled with the trait's name, and the sources of the associations are color-coded as points.
}
\examples{
\dontrun{
p <- pheWAS(variant_id = "14_87978408_G_A") \%>\%
     plot_phewas(disease = TRUE)
p
}
}
